/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.flap.FlapDockPerspective;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationLayout;
import bibliothek.gui.dock.station.flap.RetroFlapDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class FlapDockStationFactory
implements DockFactory<FlapDockStation, FlapDockPerspective, FlapDockStationLayout> {
    public static final String ID = "flap dock";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public FlapDockStationLayout getLayout(FlapDockStation flapDockStation, Map<Dockable, Integer> map) {
        PlaceholderMap placeholderMap = flapDockStation.getPlaceholders(map);
        return new FlapDockStationLayout(flapDockStation.isAutoDirection(), flapDockStation.getDirection(), placeholderMap);
    }

    @Override
    public void setLayout(FlapDockStation flapDockStation, FlapDockStationLayout flapDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        flapDockStation.setDirection(flapDockStationLayout.getDirection());
        flapDockStation.setAutoDirection(flapDockStationLayout.isAutoDirection());
    }

    @Override
    public void setLayout(FlapDockStation flapDockStation, FlapDockStationLayout flapDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        DockController dockController = flapDockStation.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            int n = flapDockStation.getDockableCount() - 1;
            while (n >= 0) {
                flapDockStation.remove(n);
                --n;
            }
            flapDockStation.setDirection(flapDockStationLayout.getDirection());
            flapDockStation.setAutoDirection(flapDockStationLayout.isAutoDirection());
            if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
                RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
                int[] nArray = retroFlapDockStationLayout.getChildren();
                boolean[] blArray = retroFlapDockStationLayout.getHolds();
                int[] nArray2 = retroFlapDockStationLayout.getSizes();
                int n2 = 0;
                int n3 = nArray.length;
                while (n2 < n3) {
                    Dockable dockable = map.get(nArray[n2]);
                    if (dockable != null) {
                        flapDockStation.add(dockable);
                        flapDockStation.setHold(dockable, blArray[n2]);
                        flapDockStation.setWindowSize(dockable, nArray2[n2]);
                    }
                    ++n2;
                }
            } else {
                flapDockStation.setPlaceholders(flapDockStationLayout.getPlaceholders().filter(placeholderStrategy), map);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public FlapDockPerspective layoutPerspective(FlapDockStationLayout flapDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        FlapDockPerspective flapDockPerspective = new FlapDockPerspective();
        this.layoutPerspective(flapDockPerspective, flapDockStationLayout, map);
        return flapDockPerspective;
    }

    @Override
    public void layoutPerspective(FlapDockPerspective flapDockPerspective, FlapDockStationLayout flapDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        flapDockPerspective.read(flapDockStationLayout.getPlaceholders(), map);
    }

    @Override
    public FlapDockStationLayout getPerspectiveLayout(FlapDockPerspective flapDockPerspective, Map<PerspectiveDockable, Integer> map) {
        boolean bl = true;
        FlapDockStation.Direction direction = FlapDockStation.Direction.SOUTH;
        PlaceholderMap placeholderMap = flapDockPerspective.toMap(map);
        return new FlapDockStationLayout(bl, direction, placeholderMap);
    }

    @Override
    public void estimateLocations(FlapDockStationLayout flapDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
            int[] nArray = retroFlapDockStationLayout.getChildren();
            boolean[] blArray = retroFlapDockStationLayout.getHolds();
            int[] nArray2 = retroFlapDockStationLayout.getSizes();
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                DockLayoutInfo dockLayoutInfo = locationEstimationMap.getChild(nArray[n]);
                if (dockLayoutInfo != null) {
                    FlapDockProperty flapDockProperty = new FlapDockProperty(n, blArray[n], nArray2[n], dockLayoutInfo.getPlaceholder());
                    dockLayoutInfo.setLocation(flapDockProperty);
                }
                ++n;
            }
        } else {
            DockablePlaceholderList.simulatedRead(flapDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, PlaceholderListItem<Dockable>>(){

                @Override
                public PlaceholderListItem<Dockable> convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    int n2 = convertedPlaceholderListItem.getInt("index");
                    boolean bl = convertedPlaceholderListItem.getBoolean("hold");
                    int n3 = convertedPlaceholderListItem.getInt("size");
                    Path path = null;
                    if (convertedPlaceholderListItem.contains("placeholder")) {
                        path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                    }
                    FlapDockProperty flapDockProperty = new FlapDockProperty(n2, bl, n3, path);
                    locationEstimationMap.getChild(n).setLocation(flapDockProperty);
                    int n4 = 0;
                    int n5 = locationEstimationMap.getSubChildCount(n);
                    while (n4 < n5) {
                        DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n, n4);
                        dockLayoutInfo.setLocation(new FlapDockProperty(n, bl, n3, dockLayoutInfo.getPlaceholder()));
                        ++n4;
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout flapDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        FlapDockStation flapDockStation = this.createStation();
        this.setLayout(flapDockStation, flapDockStationLayout, map, placeholderStrategy);
        return flapDockStation;
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout flapDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        FlapDockStation flapDockStation = this.createStation();
        this.setLayout(flapDockStation, flapDockStationLayout, placeholderStrategy);
        return flapDockStation;
    }

    @Override
    public void write(FlapDockStationLayout flapDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
            Version.write(dataOutputStream, Version.VERSION_1_0_4);
            dataOutputStream.writeBoolean(flapDockStationLayout.isAutoDirection());
            dataOutputStream.writeInt(flapDockStationLayout.getDirection().ordinal());
            int n = retroFlapDockStationLayout.getChildren().length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(retroFlapDockStationLayout.getChildren()[n2]);
                dataOutputStream.writeBoolean(retroFlapDockStationLayout.getHolds()[n2]);
                dataOutputStream.writeInt(retroFlapDockStationLayout.getSizes()[n2]);
                ++n2;
            }
        } else {
            Version.write(dataOutputStream, Version.VERSION_1_0_8);
            dataOutputStream.writeBoolean(flapDockStationLayout.isAutoDirection());
            dataOutputStream.writeInt(flapDockStationLayout.getDirection().ordinal());
            flapDockStationLayout.getPlaceholders().write(dataOutputStream);
        }
    }

    @Override
    public FlapDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        boolean bl2 = dataInputStream.readBoolean();
        FlapDockStation.Direction direction = FlapDockStation.Direction.values()[dataInputStream.readInt()];
        if (bl) {
            PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
            placeholderMap.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(bl2, direction, placeholderMap);
        }
        int n = dataInputStream.readInt();
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = dataInputStream.readInt();
            blArray[n2] = dataInputStream.readBoolean();
            nArray2[n2] = dataInputStream.readInt();
            ++n2;
        }
        return new RetroFlapDockStationLayout(nArray, blArray, nArray2, bl2, direction);
    }

    @Override
    public void write(FlapDockStationLayout flapDockStationLayout, XElement xElement) {
        if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
            XElement xElement2 = xElement.addElement("window");
            xElement2.addBoolean("auto", flapDockStationLayout.isAutoDirection());
            xElement2.addString("direction", flapDockStationLayout.getDirection().name());
            XElement xElement3 = xElement.addElement("children");
            int n = 0;
            int n2 = retroFlapDockStationLayout.getChildren().length;
            while (n < n2) {
                XElement xElement4 = xElement3.addElement("child");
                xElement4.addInt("id", retroFlapDockStationLayout.getChildren()[n]);
                xElement4.addBoolean("hold", retroFlapDockStationLayout.getHolds()[n]);
                xElement4.addInt("size", retroFlapDockStationLayout.getSizes()[n]);
                ++n;
            }
        } else {
            XElement xElement5 = xElement.addElement("window");
            xElement5.addBoolean("auto", flapDockStationLayout.isAutoDirection());
            xElement5.addString("direction", flapDockStationLayout.getDirection().name());
            XElement xElement6 = xElement.addElement("placeholders");
            flapDockStationLayout.getPlaceholders().write(xElement6);
        }
    }

    @Override
    public FlapDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        int n;
        int n2;
        XElement xElement2 = xElement.getElement("window");
        XElement xElement3 = xElement.getElement("placeholders");
        if (xElement3 != null) {
            PlaceholderMap placeholderMap = new PlaceholderMap(xElement3, placeholderStrategy);
            placeholderMap.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(xElement2.getBoolean("auto"), FlapDockStation.Direction.valueOf(xElement2.getString("direction")), placeholderMap);
        }
        XElement xElement4 = xElement.getElement("children");
        XElement[] xElementArray = xElement4.getElements("child");
        int[] nArray = new int[xElementArray.length];
        boolean[] blArray = new boolean[xElementArray.length];
        int[] nArray2 = new int[xElementArray.length];
        XAttribute xAttribute = xElement2.getAttribute("size");
        if (xAttribute != null) {
            n2 = xAttribute.getInt();
            n = 0;
            while (n < nArray2.length) {
                nArray2[n] = n2;
                ++n;
            }
        } else {
            n2 = 0;
            n = xElementArray.length;
            while (n2 < n) {
                nArray2[n2] = xElementArray[n2].getInt("size");
                ++n2;
            }
        }
        n2 = 0;
        n = xElementArray.length;
        while (n2 < n) {
            nArray[n2] = xElementArray[n2].getInt("id");
            blArray[n2] = xElementArray[n2].getBoolean("hold");
            ++n2;
        }
        return new RetroFlapDockStationLayout(nArray, blArray, nArray2, xElement2.getBoolean("auto"), FlapDockStation.Direction.valueOf(xElement2.getString("direction")));
    }

    protected FlapDockStation createStation() {
        return new FlapDockStation();
    }
}

