/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FlapDockProperty
extends AbstractDockableProperty {
    public static final FlapDockProperty FIRST = new FlapDockProperty(0);
    public static final FlapDockProperty LAST = new FlapDockProperty(Integer.MAX_VALUE);
    private int index;
    private boolean holding = false;
    private int size = -1;
    private Path placeholder;

    public FlapDockProperty() {
    }

    public FlapDockProperty(int n) {
        this.setIndex(n);
    }

    public FlapDockProperty(int n, boolean bl, int n2) {
        this(n, bl, n2, null);
    }

    public FlapDockProperty(int n, boolean bl, int n2, Path path) {
        this.setIndex(n);
        this.setHolding(bl);
        this.setSize(n2);
        this.setPlaceholder(path);
    }

    @Override
    public FlapDockProperty copy() {
        FlapDockProperty flapDockProperty = new FlapDockProperty(this.index, this.holding, this.size, this.placeholder);
        this.copy(flapDockProperty);
        return flapDockProperty;
    }

    public void setIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Index must be >= 0: " + n);
        }
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setHolding(boolean bl) {
        this.holding = bl;
    }

    public boolean isHolding() {
        return this.holding;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setPlaceholder(Path path) {
        this.placeholder = path;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeInt(this.index);
        dataOutputStream.writeBoolean(this.holding);
        dataOutputStream.writeInt(this.size);
        if (this.placeholder == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this.placeholder.toString());
        }
    }

    @Override
    public void store(XElement xElement) {
        xElement.addElement("index").setInt(this.index);
        xElement.addElement("holding").setBoolean(this.holding);
        if (this.size >= 0) {
            xElement.addElement("size").setInt(this.size);
        }
        if (this.placeholder != null) {
            xElement.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.setIndex(dataInputStream.readInt());
        if (version.compareTo(Version.VERSION_1_0_8) >= 0) {
            this.holding = dataInputStream.readBoolean();
            this.size = dataInputStream.readInt();
            if (dataInputStream.readBoolean()) {
                this.placeholder = new Path(dataInputStream.readUTF());
            }
        } else if (version.compareTo(Version.VERSION_1_0_7) >= 0) {
            this.holding = dataInputStream.readBoolean();
            this.size = dataInputStream.readInt();
        } else {
            this.holding = false;
            this.size = -1;
        }
    }

    @Override
    public void load(XElement xElement) {
        XElement xElement2 = xElement.getElement("index");
        XElement xElement3 = xElement.getElement("holding");
        XElement xElement4 = xElement.getElement("size");
        XElement xElement5 = xElement.getElement("placeholder");
        if (xElement2 == null && xElement3 == null) {
            this.index = xElement.getInt();
        } else {
            if (xElement2 != null) {
                this.index = xElement2.getInt();
            }
            if (xElement3 != null) {
                this.holding = xElement3.getBoolean();
            }
            this.size = xElement4 == null ? -1 : xElement4.getInt();
        }
        if (xElement5 != null) {
            this.placeholder = new Path(xElement5.getString());
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[index=" + this.index + ", holding=" + this.holding + ", size=" + this.size + ", placeholder=" + this.placeholder + "]";
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.holding ? 1231 : 1237);
        n = 31 * n + this.index;
        n = 31 * n + (this.placeholder == null ? 0 : this.placeholder.hashCode());
        n = 31 * n + this.size;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FlapDockProperty flapDockProperty = (FlapDockProperty)object;
        if (this.holding != flapDockProperty.holding) {
            return false;
        }
        if (this.index != flapDockProperty.index) {
            return false;
        }
        if (this.placeholder == null ? flapDockProperty.placeholder != null : !this.placeholder.equals(flapDockProperty.placeholder)) {
            return false;
        }
        return this.size == flapDockProperty.size;
    }
}

