/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

public class FlapDockPerspective
implements PerspectiveDockable,
PerspectiveStation {
    private PerspectiveStation parent;
    private PerspectivePlaceholderList<Item> dockables = new PerspectivePlaceholderList();
    private boolean defaultHold = false;
    private int defaultSize = 150;

    public void read(PlaceholderMap placeholderMap, final Map<Integer, PerspectiveDockable> map) {
        this.dockables.read(placeholderMap, new PlaceholderListItemAdapter<PerspectiveDockable, Item>(){

            @Override
            public Item convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                if (map == null) {
                    return null;
                }
                int n = convertedPlaceholderListItem.getInt("id");
                PerspectiveDockable perspectiveDockable = (PerspectiveDockable)map.get(n);
                if (perspectiveDockable != null) {
                    boolean bl = convertedPlaceholderListItem.getBoolean("hold");
                    int n2 = convertedPlaceholderListItem.getInt("size");
                    Item item = new Item();
                    item.dockable = perspectiveDockable;
                    item.hold = bl;
                    item.size = n2;
                    perspectiveDockable.setParent(FlapDockPerspective.this);
                    return item;
                }
                return null;
            }
        });
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are already children present on this station");
        }
        this.dockables = new PerspectivePlaceholderList(placeholderMap);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMap toMap(final Map<PerspectiveDockable, Integer> map) {
        return this.dockables.toMap(new PlaceholderListItemAdapter<PerspectiveDockable, Item>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, Item item) {
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("id", (Integer)map.get(item.asDockable()));
                convertedPlaceholderListItem.putInt("index", n);
                convertedPlaceholderListItem.putBoolean("hold", item.hold);
                convertedPlaceholderListItem.putInt("size", item.size);
                Path path = convertedPlaceholderListItem.getPlaceholder();
                if (path != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("defaultSize must be at least 0: " + n);
        }
        this.defaultSize = n;
    }

    public boolean isDefaultHold() {
        return this.defaultHold;
    }

    public void setDefaultHold(boolean bl) {
        this.defaultHold = bl;
    }

    public void insertPlaceholder(int n, PerspectiveDockable perspectiveDockable) {
        Item item = new Item();
        item.dockable = perspectiveDockable;
        this.dockables.dockables().add(n, item);
        this.dockables.dockables().remove(n);
    }

    public void insertPlaceholder(int n, Path path) {
        this.dockables.list().insertPlaceholder(n, path);
    }

    public void addPlaceholder(PerspectiveDockable perspectiveDockable) {
        this.insertPlaceholder(this.getDockableCount(), perspectiveDockable);
    }

    public void addPlaceholder(Path path) {
        this.insertPlaceholder(this.dockables.list().size(), path);
    }

    public void add(PerspectiveDockable perspectiveDockable) {
        this.add(perspectiveDockable, this.defaultHold, this.defaultSize);
    }

    public void add(PerspectiveDockable perspectiveDockable, boolean bl, int n) {
        this.insert(this.getDockableCount(), perspectiveDockable, bl, n);
    }

    public void insert(int n, PerspectiveDockable perspectiveDockable) {
        this.insert(n, perspectiveDockable, this.defaultHold, this.defaultSize);
    }

    public void insert(int n, PerspectiveDockable perspectiveDockable, boolean bl, int n2) {
        this.insert(n, perspectiveDockable, bl, n2, false);
    }

    private void insert(int n, PerspectiveDockable perspectiveDockable, boolean bl, int n2, boolean bl2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("size must be >= 0");
        }
        DockUtilities.ensureTreeValidity(this, perspectiveDockable);
        Item item = new Item();
        item.dockable = perspectiveDockable;
        item.hold = bl;
        item.size = n2;
        this.dockables.dockables().add(n, item);
        perspectiveDockable.setParent(this);
    }

    public PerspectiveDockable remove(int n) {
        Item item = (Item)this.dockables.dockables().get(n);
        this.dockables.remove(item);
        item.dockable.setParent(null);
        return item.dockable;
    }

    @Override
    public boolean remove(PerspectiveDockable perspectiveDockable) {
        int n = this.indexOf(perspectiveDockable);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    @Override
    public void replace(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.indexOf(perspectiveDockable);
        if (n < 0) {
            throw new IllegalArgumentException("oldDockable is not a child of this station");
        }
        DockUtilities.ensureTreeValidity(this, perspectiveDockable2);
        boolean bl = this.isHold(perspectiveDockable);
        int n2 = this.getSize(perspectiveDockable);
        this.remove(n);
        this.insert(n, perspectiveDockable2, bl, n2);
    }

    public int indexOf(PerspectiveDockable perspectiveDockable) {
        int n = 0;
        for (Item item : this.dockables.dockables()) {
            if (item.asDockable() == perspectiveDockable) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setHold(PerspectiveDockable perspectiveDockable, boolean bl) {
        this.item((PerspectiveDockable)perspectiveDockable).hold = bl;
    }

    public boolean isHold(PerspectiveDockable perspectiveDockable) {
        return this.item((PerspectiveDockable)perspectiveDockable).hold;
    }

    public void setSize(PerspectiveDockable perspectiveDockable, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size must be >= 0: " + n);
        }
        this.item((PerspectiveDockable)perspectiveDockable).size = n;
    }

    public int getSize(PerspectiveDockable perspectiveDockable) {
        return this.item((PerspectiveDockable)perspectiveDockable).size;
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.indexOf(perspectiveDockable);
        boolean bl = this.isHold(perspectiveDockable);
        int n2 = this.getSize(perspectiveDockable);
        Path path = null;
        path = perspectiveDockable2 != null ? perspectiveDockable2.getPlaceholder() : perspectiveDockable.getPlaceholder();
        return new FlapDockProperty(n, bl, n2, path);
    }

    private Item item(PerspectiveDockable perspectiveDockable) {
        int n = this.indexOf(perspectiveDockable);
        if (n < 0) {
            throw new IllegalArgumentException("not a child of this station: " + perspectiveDockable);
        }
        return (Item)this.dockables.dockables().get(n);
    }

    @Override
    public void setParent(PerspectiveStation perspectiveStation) {
        this.parent = perspectiveStation;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public PerspectiveDockable getDockable(int n) {
        return ((Item)this.dockables.dockables().get((int)n)).dockable;
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    private static class Item
    implements PlaceholderListItem<PerspectiveDockable> {
        public PerspectiveDockable dockable;
        public boolean hold;
        public int size;

        private Item() {
        }

        @Override
        public PerspectiveDockable asDockable() {
            return this.dockable;
        }
    }
}

