/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedSelectableDockAction;
import bibliothek.gui.dock.event.FlapDockListener;
import bibliothek.gui.dock.station.flap.button.ButtonContentAction;
import javax.swing.Icon;

@ButtonContentAction
public class FlapDockHoldToggle
extends GroupedSelectableDockAction.Check<Boolean>
implements ListeningDockAction {
    private FlapDockStation flap;
    private DockController controller;
    private Listener[] icons;
    private DockActionText textStick;
    private DockActionText textStickTooltip;
    private DockActionText textFree;
    private DockActionText textFreeTooltip;

    public FlapDockHoldToggle(FlapDockStation flapDockStation) {
        super(null);
        this.setRemoveEmptyGroups(false);
        this.flap = flapDockStation;
        this.icons = new Listener[]{new Listener("flap.hold"), new Listener("flap.free")};
        flapDockStation.addFlapDockStationListener(new FlapDockListener(){

            @Override
            public void holdChanged(FlapDockStation flapDockStation, Dockable dockable, boolean bl) {
                if (FlapDockHoldToggle.this.isBound(dockable)) {
                    FlapDockHoldToggle.this.setGroup(bl, dockable);
                }
            }
        });
        this.setSelected(Boolean.FALSE, false);
        this.setSelected(Boolean.TRUE, true);
        this.textStick = new DockActionText("flap.stick.true", this){

            @Override
            protected void changed(String string, String string2) {
                FlapDockHoldToggle.this.setText(Boolean.TRUE, string2);
            }
        };
        this.textFree = new DockActionText("flap.stick.false", this){

            @Override
            protected void changed(String string, String string2) {
                FlapDockHoldToggle.this.setText(Boolean.FALSE, string2);
            }
        };
        this.textStickTooltip = new DockActionText("flap.stick.true.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                FlapDockHoldToggle.this.setTooltip(Boolean.TRUE, string2);
            }
        };
        this.textFreeTooltip = new DockActionText("flap.stick.false.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                FlapDockHoldToggle.this.setTooltip(Boolean.FALSE, string2);
            }
        };
    }

    @Override
    public boolean trigger(Dockable dockable) {
        this.setSelected(dockable, !this.isSelected(dockable));
        return true;
    }

    @Override
    public void setSelected(Dockable dockable, boolean bl) {
        this.flap.setHold(dockable, bl);
        this.setGroup(bl, dockable);
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        return this.flap.isHold(dockable);
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            this.controller = dockController;
            Listener[] listenerArray = this.icons;
            int n = this.icons.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                listener.setController(dockController);
                ++n2;
            }
            this.textStick.setController(dockController);
            this.textFree.setController(dockController);
            this.textStickTooltip.setController(dockController);
            this.textFreeTooltip.setController(dockController);
        }
    }

    private class Listener
    extends DockActionIcon {
        public Listener(String string) {
            super(string, FlapDockHoldToggle.this);
        }

        @Override
        protected void changed(Icon icon, Icon icon2) {
            String string = this.getId();
            if (string.equals("flap.free")) {
                FlapDockHoldToggle.this.setIcon(false, icon2);
            } else {
                FlapDockHoldToggle.this.setSelectedIcon(true, icon2);
            }
        }
    }
}

