/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.util.AbstractUIValue;
import javax.swing.Icon;

public class FlapDockDirection
extends SimpleMenuAction
implements ListeningDockAction {
    private DirectedArrow north;
    private DirectedArrow south;
    private DirectedArrow east;
    private DirectedArrow west;
    private DirectedArrow center;
    private DockController controller;
    private FlapIcon[] icons;
    private DockActionText[] texts;

    public FlapDockDirection() {
        DockActionText dockActionText = new DockActionText("flap.direction", this){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.setText(string2);
            }
        };
        DockActionText dockActionText2 = new DockActionText("flap.direction.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.setTooltip(string2);
            }
        };
        this.center = new DirectedArrow(null);
        this.north = new DirectedArrow(FlapDockStation.Direction.NORTH);
        this.south = new DirectedArrow(FlapDockStation.Direction.SOUTH);
        this.east = new DirectedArrow(FlapDockStation.Direction.EAST);
        this.west = new DirectedArrow(FlapDockStation.Direction.WEST);
        DockActionText dockActionText3 = new DockActionText("flap.direction.north", this.north){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.north.setText(string2);
            }
        };
        DockActionText dockActionText4 = new DockActionText("flap.direction.north.tooltip", this.north){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.north.setTooltip(string2);
            }
        };
        DockActionText dockActionText5 = new DockActionText("flap.direction.south", this.south){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.south.setText(string2);
            }
        };
        DockActionText dockActionText6 = new DockActionText("flap.direction.south.tooltip", this.south){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.south.setTooltip(string2);
            }
        };
        DockActionText dockActionText7 = new DockActionText("flap.direction.east", this.east){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.east.setText(string2);
            }
        };
        DockActionText dockActionText8 = new DockActionText("flap.direction.east.tooltip", this.east){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.east.setTooltip(string2);
            }
        };
        DockActionText dockActionText9 = new DockActionText("flap.direction.west", this.west){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.west.setText(string2);
            }
        };
        DockActionText dockActionText10 = new DockActionText("flap.direction.west.tooltip", this.west){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.west.setTooltip(string2);
            }
        };
        DockActionText dockActionText11 = new DockActionText("flap.direction.center", this.center){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.center.setText(string2);
            }
        };
        DockActionText dockActionText12 = new DockActionText("flap.direction.center.tooltip", this.center){

            @Override
            protected void changed(String string, String string2) {
                FlapDockDirection.this.center.setTooltip(string2);
            }
        };
        this.icons = new FlapIcon[]{new FlapIcon("flap.direction"), new FlapIcon("flap.south"), new FlapIcon("flap.east"), new FlapIcon("flap.west"), new FlapIcon("flap.north"), new FlapIcon("flap.auto")};
        this.texts = new DockActionText[]{dockActionText, dockActionText2, dockActionText3, dockActionText4, dockActionText5, dockActionText6, dockActionText7, dockActionText8, dockActionText9, dockActionText10, dockActionText11, dockActionText12};
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new DockAction[0]);
        defaultDockActionSource.add(this.center);
        defaultDockActionSource.addSeparator();
        defaultDockActionSource.add(this.north, this.south, this.east, this.west);
        this.setMenu(defaultDockActionSource);
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            AbstractUIValue abstractUIValue;
            this.controller = dockController;
            AbstractUIValue[] abstractUIValueArray = this.icons;
            int n = this.icons.length;
            int n2 = 0;
            while (n2 < n) {
                abstractUIValue = abstractUIValueArray[n2];
                abstractUIValue.setManager(dockController.getIcons());
                ++n2;
            }
            abstractUIValueArray = this.texts;
            n = this.texts.length;
            n2 = 0;
            while (n2 < n) {
                abstractUIValue = abstractUIValueArray[n2];
                abstractUIValue.setManager(dockController.getTexts());
                ++n2;
            }
        }
    }

    private void fire() {
        this.center.fireSelectedChanged();
        this.north.fireSelectedChanged();
        this.south.fireSelectedChanged();
        this.east.fireSelectedChanged();
        this.west.fireSelectedChanged();
    }

    private FlapDockStation getStation(Dockable dockable) {
        if (dockable instanceof FlapDockStation) {
            return (FlapDockStation)dockable;
        }
        if (dockable.getDockParent() != null) {
            return this.getStation(dockable.getDockParent().asDockable());
        }
        throw new IllegalArgumentException("Dockable or parent is not a FlapDockStation");
    }

    private class DirectedArrow
    extends SimpleSelectableAction.Radio {
        private FlapDockStation.Direction direction;

        public DirectedArrow(FlapDockStation.Direction direction) {
            this.direction = direction;
        }

        @Override
        public boolean isSelected(Dockable dockable) {
            FlapDockStation flapDockStation = FlapDockDirection.this.getStation(dockable);
            if (this.direction == null) {
                return flapDockStation.isAutoDirection();
            }
            return !flapDockStation.isAutoDirection() && flapDockStation.getDirection() == this.direction;
        }

        @Override
        public void setSelected(Dockable dockable, boolean bl) {
            if (bl) {
                FlapDockStation flapDockStation = FlapDockDirection.this.getStation(dockable);
                if (this.direction == null) {
                    flapDockStation.setAutoDirection(true);
                } else {
                    flapDockStation.setAutoDirection(false);
                    flapDockStation.setDirection(this.direction);
                }
                FlapDockDirection.this.fire();
            }
        }

        @Override
        public void fireSelectedChanged() {
            super.fireSelectedChanged();
        }
    }

    private class FlapIcon
    extends DockActionIcon {
        public FlapIcon(String string) {
            super(string, FlapDockDirection.this);
        }

        @Override
        protected void changed(Icon icon, Icon icon2) {
            String string = this.getId();
            if (string.equals("flap.direction")) {
                FlapDockDirection.this.setIcon(icon2);
            } else if (string.equals("flap.north")) {
                FlapDockDirection.this.north.setIcon(icon2);
            } else if (string.equals("flap.south")) {
                FlapDockDirection.this.south.setIcon(icon2);
            } else if (string.equals("flap.east")) {
                FlapDockDirection.this.east.setIcon(icon2);
            } else if (string.equals("flap.west")) {
                FlapDockDirection.this.west.setIcon(icon2);
            } else if (string.equals("flap.auto")) {
                FlapDockDirection.this.center.setIcon(icon2);
            }
        }
    }
}

