/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.flap.FlapWindowBackgroundComponent;
import bibliothek.gui.dock.station.flap.FlapWindowBorder;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DefaultFlapWindow
implements FlapWindow,
MouseListener,
MouseMotionListener {
    private StationChildHandle dockable;
    private DockableDisplayerListener displayerListener = new DockableDisplayerListener(){

        @Override
        public void discard(DockableDisplayer dockableDisplayer) {
            DefaultFlapWindow.this.discardDisplayer();
        }

        @Override
        public void moveableElementChanged(DockableDisplayer dockableDisplayer) {
        }
    };
    private BorderForwarder contentBorder;
    private boolean pressed;
    private FlapDockStation station;
    private ButtonPane buttonPane;
    private FlapDropInfo dropInfo;
    private boolean removal;
    private JComponent contentPane;
    private Parent window;
    private SecureContainer contentContainer;
    private Background background = new Background();

    public DefaultFlapWindow(FlapDockStation flapDockStation, ButtonPane buttonPane, Parent parent) {
        this.station = flapDockStation;
        this.buttonPane = buttonPane;
        this.window = parent;
        this.init();
    }

    private void init() {
        this.contentContainer = new SecureContainer(){

            @Override
            protected void paintOverlay(Graphics graphics) {
                if (DefaultFlapWindow.this.removal || DefaultFlapWindow.this.dropInfo != null && DefaultFlapWindow.this.dropInfo.getCombineTarget() != null) {
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    StationPaint stationPaint = (StationPaint)DefaultFlapWindow.this.station.getPaint().get();
                    if (stationPaint != null) {
                        if (DefaultFlapWindow.this.dropInfo != null && DefaultFlapWindow.this.dropInfo.getCombineTarget() != null) {
                            DefaultFlapWindow.this.dropInfo.getCombineTarget().paint(graphics, DefaultFlapWindow.this.contentContainer, stationPaint, rectangle, rectangle);
                        } else if (DefaultFlapWindow.this.removal) {
                            stationPaint.drawRemoval(graphics, DefaultFlapWindow.this.getStation(), rectangle, rectangle);
                        }
                    }
                }
            }
        };
        BackgroundPanel backgroundPanel = new BackgroundPanel(Transparency.SOLID){

            @Override
            protected void configure(Transparency transparency) {
            }

            @Override
            protected void setupRenderingHints(Graphics graphics) {
            }
        };
        backgroundPanel.setBackground(this.background);
        this.contentContainer.getBasePane().setLayout(new BorderLayout());
        this.contentContainer.getBasePane().add((Component)backgroundPanel, "Center");
        this.contentContainer.setContentPane(backgroundPanel);
        this.window.setContentPane(this.contentContainer);
        this.contentPane = this.contentContainer.getContentPane();
        this.contentPane.setOpaque(false);
        this.contentBorder = new WindowBorder(this.contentPane);
        this.contentBorder.setBorder(BorderFactory.createBevelBorder(0));
        this.contentPane.addMouseListener(this);
        this.contentPane.addMouseMotionListener(this);
        this.contentPane.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String string, Component component) {
            }

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                DockableDisplayer dockableDisplayer = DefaultFlapWindow.this.getDisplayer();
                if (dockableDisplayer == null) {
                    return new Dimension(100, 100);
                }
                return dockableDisplayer.getComponent().getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                DockableDisplayer dockableDisplayer = DefaultFlapWindow.this.getDisplayer();
                if (dockableDisplayer == null) {
                    return new Dimension(100, 100);
                }
                return dockableDisplayer.getComponent().getMinimumSize();
            }

            @Override
            public void layoutContainer(Container container) {
                DockableDisplayer dockableDisplayer = DefaultFlapWindow.this.getDisplayer();
                if (dockableDisplayer != null) {
                    Insets insets = container.getInsets();
                    insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
                    if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
                        insets.bottom += DefaultFlapWindow.this.station.getWindowBorder();
                    } else if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.NORTH) {
                        insets.top += DefaultFlapWindow.this.station.getWindowBorder();
                    } else if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.EAST) {
                        insets.right += DefaultFlapWindow.this.station.getWindowBorder();
                    } else {
                        insets.left += DefaultFlapWindow.this.station.getWindowBorder();
                    }
                    dockableDisplayer.getComponent().setBounds(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
                }
            }
        });
        this.window.asComponent().addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (!DefaultFlapWindow.this.station.isFlapWindow(DefaultFlapWindow.this) || DefaultFlapWindow.this.getDockable() == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultFlapWindow.this.destroy();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setWindowVisible(boolean bl) {
        if (bl) {
            this.updateBounds();
        }
        this.window.setVisible(bl);
    }

    @Override
    public boolean isWindowVisible() {
        return this.window != null && this.window.isVisible();
    }

    @Override
    public Rectangle getWindowBounds() {
        return this.window.asComponent().getBounds();
    }

    @Override
    public void destroy() {
        if (this.window != null) {
            this.setController(null);
            this.setDockable(null);
            this.window.destroy();
            this.window = null;
        }
    }

    @Override
    public void repaint() {
        if (this.window != null) {
            this.window.asComponent().repaint();
        }
    }

    @Override
    public Component getComponent() {
        if (this.window == null) {
            return null;
        }
        return this.window.asComponent();
    }

    public boolean isWindowValid() {
        return this.window != null && this.window.isParentValid();
    }

    @Override
    public boolean containsScreenPoint(Point point) {
        point = new Point(point);
        Component component = this.window.asComponent();
        SwingUtilities.convertPointFromScreen(point, component);
        return component.contains(point);
    }

    public FlapDockStation getStation() {
        return this.station;
    }

    @Override
    public void setDropInfo(FlapDropInfo flapDropInfo) {
        this.dropInfo = flapDropInfo;
        this.repaint();
    }

    @Override
    public void setRemoval(boolean bl) {
        this.removal = bl;
        this.repaint();
    }

    @Override
    public void setDockTitle(DockTitleVersion dockTitleVersion) {
        if (this.dockable != null) {
            this.dockable.setTitleRequest(dockTitleVersion);
        }
    }

    @Override
    public DockTitle getDockTitle() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getTitle();
    }

    @Override
    public Dockable getDockable() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getDockable();
    }

    @Override
    public DockableDisplayer getDisplayer() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getDisplayer();
    }

    @Override
    public void setDockable(Dockable dockable) {
        DockableDisplayer dockableDisplayer;
        Container container = this.getDisplayerParent();
        if (this.dockable != null) {
            dockableDisplayer = this.getDisplayer();
            dockableDisplayer.removeDockableDisplayerListener(this.displayerListener);
            container.remove(dockableDisplayer.getComponent());
            this.dockable.destroy();
            this.dockable = null;
        }
        if (dockable != null) {
            this.dockable = new StationChildHandle(this.station, this.station.getDisplayers(), dockable, this.station.getTitleVersion());
            this.dockable.updateDisplayer();
            dockableDisplayer = this.getDisplayer();
            dockableDisplayer.addDockableDisplayerListener(this.displayerListener);
            container.add(dockableDisplayer.getComponent());
        }
    }

    protected void discardDisplayer() {
        if (this.dockable != null) {
            DockableDisplayer dockableDisplayer = this.dockable.getDisplayer();
            dockableDisplayer.removeDockableDisplayerListener(this.displayerListener);
            this.contentPane.remove(dockableDisplayer.getComponent());
            this.dockable.updateDisplayer();
            dockableDisplayer = this.dockable.getDisplayer();
            dockableDisplayer.addDockableDisplayerListener(this.displayerListener);
            this.contentPane.add(dockableDisplayer.getComponent());
            this.updateBounds();
        }
    }

    protected Container getDisplayerParent() {
        return this.contentPane;
    }

    @Override
    public void setController(DockController dockController) {
        this.background.setController(dockController);
        this.contentContainer.setController(dockController);
        this.contentBorder.setController(dockController);
    }

    @Override
    public Insets getDockableInsets() {
        DockableDisplayer dockableDisplayer = this.dockable.getDisplayer();
        Insets insets = dockableDisplayer.getDockableInsets();
        dockableDisplayer.getComponent().getBounds();
        Component component = this.window.asComponent();
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(dockableDisplayer.getComponent(), point, component);
        int n = point.x;
        int n2 = point.y;
        int n3 = component.getWidth() - dockableDisplayer.getComponent().getWidth();
        int n4 = component.getHeight() - dockableDisplayer.getComponent().getHeight();
        insets.left += n;
        insets.top += n2;
        insets.right += n3 - n;
        insets.bottom += n4 - n2;
        return insets;
    }

    @Override
    public void updateBounds() {
        Dockable dockable;
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        Dockable dockable2 = dockable = dockableDisplayer == null ? null : dockableDisplayer.getDockable();
        if (dockable != null) {
            Dimension dimension;
            Point point;
            this.window.asComponent().validate();
            FlapDockStation.Direction direction = this.station.getDirection();
            int n = this.station.getWindowSize(dockable);
            Rectangle rectangle = this.station.getExpansionBounds();
            Insets insets = this.getDockableInsets();
            if (direction == FlapDockStation.Direction.SOUTH) {
                point = new Point(rectangle.x, rectangle.height);
                dimension = new Dimension(rectangle.width, n += insets.top + insets.bottom);
            } else if (direction == FlapDockStation.Direction.NORTH) {
                point = new Point(rectangle.x, -(n += insets.top + insets.bottom));
                dimension = new Dimension(rectangle.width, n);
            } else if (direction == FlapDockStation.Direction.WEST) {
                point = new Point(-(n += insets.left + insets.right), rectangle.y);
                dimension = new Dimension(n, rectangle.height);
            } else {
                point = new Point(rectangle.width, rectangle.y);
                dimension = new Dimension(n += insets.left + insets.right, rectangle.height);
            }
            SwingUtilities.convertPointToScreen(point, this.buttonPane);
            this.window.setParentLocation(point);
            this.window.setSize(dimension);
            this.window.asComponent().validate();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.pressed) {
            this.window.asComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.station.getDirection() == FlapDockStation.Direction.NORTH) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.station.getDirection() == FlapDockStation.Direction.EAST) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressed) {
            Dockable dockable;
            DockableDisplayer dockableDisplayer = this.getDisplayer();
            Dockable dockable2 = dockable = dockableDisplayer == null ? null : dockableDisplayer.getDockable();
            if (dockable != null) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                Component component = this.station.getComponent();
                Point point2 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point2, component);
                int n = 0;
                n = this.station.getDirection() == FlapDockStation.Direction.SOUTH ? point.y - point2.y - component.getHeight() : (this.station.getDirection() == FlapDockStation.Direction.NORTH ? point2.y - point.y : (this.station.getDirection() == FlapDockStation.Direction.EAST ? point.x - point2.x - component.getWidth() : point2.x - point.x));
                n = Math.max(n, this.station.getWindowMinSize());
                Insets insets = this.getDockableInsets();
                n = this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH ? (n -= insets.top + insets.bottom) : (n -= insets.left + insets.right);
                if (n > 0) {
                    this.station.setWindowSize(dockable, n);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private class Background
    extends BackgroundAlgorithm
    implements FlapWindowBackgroundComponent {
        public Background() {
            super(FlapWindowBackgroundComponent.KIND, "dock.background.station.flap.window");
        }

        @Override
        public FlapWindow getWindow() {
            return DefaultFlapWindow.this;
        }

        @Override
        public DockStation getStation() {
            return DefaultFlapWindow.this.station;
        }

        @Override
        public Component getComponent() {
            return DefaultFlapWindow.this.window.asComponent();
        }
    }

    public static class DialogParent
    extends JDialog
    implements Parent {
        private FlapDockStation station;

        public DialogParent(Frame frame, FlapDockStation flapDockStation) {
            super(frame, false);
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.station = flapDockStation;
        }

        public DialogParent(Dialog dialog, FlapDockStation flapDockStation) {
            super(dialog, false);
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.station = flapDockStation;
        }

        @Override
        public Component asComponent() {
            return this;
        }

        @Override
        public boolean isParentValid() {
            Window window = SwingUtilities.getWindowAncestor(this.station.getComponent());
            return this.getOwner() == window;
        }

        @Override
        public void setParentLocation(Point point) {
            this.setLocation(point);
        }

        @Override
        public void destroy() {
            this.dispose();
        }
    }

    public static interface Parent {
        public boolean isParentValid();

        public Component asComponent();

        public void setParentLocation(Point var1);

        public void setSize(Dimension var1);

        public boolean isVisible();

        public void setVisible(boolean var1);

        public void setContentPane(Container var1);

        public Container getContentPane();

        public void destroy();
    }

    private class WindowBorder
    extends BorderForwarder
    implements FlapWindowBorder {
        public WindowBorder(JComponent jComponent) {
            super(FlapWindowBorder.KIND, "dock.border.flap.window", jComponent);
        }

        @Override
        public FlapWindow getWindow() {
            return DefaultFlapWindow.this;
        }

        @Override
        public FlapDockStation getStation() {
            return DefaultFlapWindow.this.getStation();
        }
    }
}

