/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.flap.AbstractFlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import java.util.HashMap;
import java.util.Map;

public class DefaultFlapLayoutManager
extends AbstractFlapLayoutManager
implements FlapLayoutManager {
    private Map<FlapDockStation, Station> stations = new HashMap<FlapDockStation, Station>();

    @Override
    public void install(FlapDockStation flapDockStation) {
        Station station = new Station();
        flapDockStation.addDockStationListener(station);
        station.size = flapDockStation.getDefaultWindowSize();
        this.stations.put(flapDockStation, station);
    }

    @Override
    public void uninstall(FlapDockStation flapDockStation) {
        Station station = this.stations.remove(flapDockStation);
        if (station != null) {
            flapDockStation.removeDockStationListener(station);
        }
    }

    @Override
    public int getSize(FlapDockStation flapDockStation, Dockable dockable) {
        return this.stations.get((Object)flapDockStation).size;
    }

    @Override
    public boolean isHold(FlapDockStation flapDockStation, Dockable dockable) {
        return Boolean.TRUE.equals(this.stations.get((Object)flapDockStation).hold.get(dockable));
    }

    @Override
    public void setHold(FlapDockStation flapDockStation, Dockable dockable, boolean bl) {
        this.stations.get((Object)flapDockStation).hold.put(dockable, bl);
    }

    @Override
    public void setSize(FlapDockStation flapDockStation, Dockable dockable, int n) {
        this.stations.get((Object)flapDockStation).size = n;
    }

    @Override
    public boolean isHoldSwitchable(FlapDockStation flapDockStation, Dockable dockable) {
        Boolean bl = this.stations.get((Object)flapDockStation).switchable.get(dockable);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setHoldSwitchable(FlapDockStation flapDockStation, Dockable dockable, boolean bl) {
        this.stations.get((Object)flapDockStation).switchable.put(dockable, bl);
        this.fireHoldSwitchableChanged(flapDockStation, dockable);
    }

    private static class Station
    extends DockStationAdapter {
        public Map<Dockable, Boolean> hold = new HashMap<Dockable, Boolean>();
        public Map<Dockable, Boolean> switchable = new HashMap<Dockable, Boolean>();
        public int size;

        private Station() {
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            this.hold.remove(dockable);
            this.switchable.remove(dockable);
        }
    }
}

