/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapSpanStrategy;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class ButtonPane
extends SecureContainer {
    private FlapDockStation station;
    private FlapDropInfo dropInfo;
    private boolean resetStarted = false;
    private Content content;
    private FlapSpanStrategy span;

    public ButtonPane(FlapDockStation flapDockStation) {
        this.span = new FlapSpanStrategy(flapDockStation, this);
        this.content = new Content();
        this.setBasePane(this.content);
        this.station = flapDockStation;
    }

    public void setBackground(BackgroundAlgorithm backgroundAlgorithm) {
        this.content.setBackground(backgroundAlgorithm);
    }

    public void setDropInfo(FlapDropInfo flapDropInfo) {
        if (flapDropInfo == null) {
            this.span.untease();
        } else if (flapDropInfo.getCombineTarget() != null) {
            this.span.tease(-1);
        } else {
            int n = flapDropInfo.getIndex();
            if (n < this.station.getDockableCount() && this.station.getDockable(n) == flapDropInfo.getDockable()) {
                flapDropInfo = null;
                this.span.tease(-1);
            } else if (n - 1 >= 0 && n - 1 < this.station.getDockableCount() && this.station.getDockable(n - 1) == flapDropInfo.getDockable()) {
                flapDropInfo = null;
                this.span.tease(-1);
            } else {
                this.span.tease(flapDropInfo.getIndex());
            }
        }
        this.dropInfo = flapDropInfo;
        this.repaint();
    }

    public boolean titleContains(int n, int n2) {
        if (this.getComponentCount() == 0) {
            int n3;
            int n4 = this.getWidth() / 3;
            return this.contains(n - n4, n2 - (n3 = this.getHeight() / 3)) && this.contains(n + n4, n2 + n3);
        }
        int n5 = 0;
        int n6 = this.getComponentCount();
        while (n5 < n6) {
            Component component = this.getComponent(n5);
            if (component.contains(n - component.getX(), n2 - component.getY())) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public void setProperties(DockController dockController) {
        this.span.setController(dockController);
    }

    public void resetTitles() {
        if (!this.resetStarted) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ButtonPane.this.resetStarted = false;
                    ButtonPane.this.getContentPane().removeAll();
                    int n = 0;
                    int n2 = ButtonPane.this.station.getDockableCount();
                    while (n < n2) {
                        DockTitle dockTitle = ButtonPane.this.station.getButton(n);
                        if (dockTitle != null) {
                            ButtonPane.this.getContentPane().add(dockTitle.getComponent());
                        }
                        ++n;
                    }
                    ButtonPane.this.span.reset();
                    ButtonPane.this.revalidate();
                }
            };
            this.resetStarted = true;
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }

    @Override
    protected void paintOverlay(Graphics graphics) {
        if (this.dropInfo != null && this.dropInfo.getCombineTarget() == null) {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl;
            int n5 = this.dropInfo.getIndex() - 1;
            int n6 = n5 + 1;
            DockTitle dockTitle = n5 < 0 ? null : this.station.getButton(n5);
            DockTitle dockTitle2 = n6 >= this.station.getDockableCount() ? null : this.station.getButton(n6);
            boolean bl2 = bl = this.station.getDirection() == FlapDockStation.Direction.SOUTH || this.station.getDirection() == FlapDockStation.Direction.NORTH;
            if (dockTitle == null && dockTitle2 == null) {
                if (bl) {
                    n4 = 0;
                    n3 = 0;
                    n2 = this.getWidth();
                    n = this.getHeight();
                } else {
                    n4 = 0;
                    n3 = 0;
                    n2 = this.getWidth();
                    n = this.getHeight();
                }
            } else if (dockTitle == null) {
                if (bl) {
                    n4 = 0;
                    n3 = 0;
                    n2 = dockTitle2.getComponent().getX();
                    n = this.getHeight();
                } else {
                    n4 = 0;
                    n3 = 0;
                    n2 = this.getWidth();
                    n = dockTitle2.getComponent().getY();
                }
            } else if (dockTitle2 == null) {
                int n7 = this.getNumberOfButtons();
                if (bl) {
                    n4 = dockTitle.getComponent().getX() + dockTitle.getComponent().getWidth();
                    n3 = 0;
                    n2 = n4 + this.span.getGap(n7);
                    n = this.getHeight();
                } else {
                    n4 = 0;
                    n3 = dockTitle.getComponent().getY() + dockTitle.getComponent().getHeight();
                    n2 = this.getWidth();
                    n = n3 + this.span.getGap(n7);
                }
            } else if (bl) {
                n4 = dockTitle.getComponent().getX() + dockTitle.getComponent().getWidth();
                n3 = 0;
                n2 = dockTitle2.getComponent().getX();
                n = this.getHeight();
            } else {
                n4 = 0;
                n3 = dockTitle.getComponent().getY() + dockTitle.getComponent().getHeight();
                n2 = this.getWidth();
                n = dockTitle2.getComponent().getY();
            }
            if (++n4 >= --n2 || ++n3 >= --n) {
                if (bl) {
                    n2 = n4 = (n4 + n2) / 2;
                } else {
                    n = n3 = (n3 + n) / 2;
                }
                this.station.getPaint().drawInsertionLine(graphics, n4, n3, n2, n);
            } else {
                this.station.getPaint().drawInsertion(graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), new Rectangle(n4, n3, n2 - n4, n - n3));
            }
        }
    }

    public int indexAt(int n, int n2) {
        if (this.station.getDirection() == FlapDockStation.Direction.SOUTH || this.station.getDirection() == FlapDockStation.Direction.NORTH) {
            int n3 = 0;
            int n4 = this.station.getDockableCount();
            while (n3 < n4) {
                DockTitle dockTitle = this.station.getButton(n3);
                if (dockTitle != null) {
                    int n5 = dockTitle.getComponent().getX();
                    int n6 = dockTitle.getComponent().getWidth();
                    if (n <= n5) {
                        return n3;
                    }
                    if (n <= n5 + n6) {
                        if (n < n5 + n6 / 2) {
                            return n3;
                        }
                        return n3 + 1;
                    }
                }
                ++n3;
            }
        } else {
            int n7 = 0;
            int n8 = this.station.getDockableCount();
            while (n7 < n8) {
                DockTitle dockTitle = this.station.getButton(n7);
                if (dockTitle != null) {
                    int n9 = dockTitle.getComponent().getY();
                    int n10 = dockTitle.getComponent().getHeight();
                    if (n2 <= n9) {
                        return n7;
                    }
                    if (n2 <= n9 + n10) {
                        if (n2 < n9 + n10 / 2) {
                            return n7;
                        }
                        return n7 + 1;
                    }
                }
                ++n7;
            }
        }
        return this.station.getDockableCount();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.station.getDockableCount();
        if (this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
            n3 = this.span.getTeasing();
            n = 0;
            while (n < n4) {
                DockTitle dockTitle = this.station.getButton(n);
                if (dockTitle != null) {
                    Dimension dimension = dockTitle.getComponent().getPreferredSize();
                    n2 += dimension.width;
                    n3 = Math.max(n3, dimension.height);
                }
                n2 += this.span.getGap(n);
                ++n;
            }
            if (n4 > 0) {
                n2 += this.span.getGap(n4);
            }
        } else {
            n2 = this.span.getTeasing();
            n = 0;
            while (n < n4) {
                DockTitle dockTitle = this.station.getButton(n);
                if (dockTitle != null) {
                    Dimension dimension = dockTitle.getComponent().getPreferredSize();
                    n3 += dimension.height;
                    n2 = Math.max(n2, dimension.width);
                }
                n3 += this.span.getGap(n);
                ++n;
            }
            if (n4 > 0) {
                n3 += this.span.getGap(n4);
            }
        }
        Dimension dimension = this.station.getMinimumSize();
        return new Dimension(Math.max(dimension.width, n2), Math.max(dimension.height, n3));
    }

    public int getNumberOfButtons() {
        return this.getContentPane().getComponentCount();
    }

    public void spanResized() {
        this.getContentPane().revalidate();
        this.revalidate();
    }

    private class Content
    extends ConfiguredBackgroundPanel {
        public Content() {
            super(null, Transparency.SOLID);
        }

        @Override
        public void setTransparency(Transparency transparency) {
            super.setTransparency(transparency);
            ButtonPane.this.setSolid(transparency == Transparency.SOLID);
        }

        @Override
        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = this.getWidth() - insets.left - insets.right;
            int n4 = this.getHeight() - insets.top - insets.bottom;
            if (ButtonPane.this.station.getDirection() == FlapDockStation.Direction.NORTH || ButtonPane.this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
                int n5 = this.getComponentCount();
                int[] nArray = new int[n5];
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n8 < n5) {
                    Dimension dimension = this.getComponent(n8).getPreferredSize();
                    nArray[n8] = dimension.width;
                    n6 = Math.max(n6, dimension.height);
                    n7 += nArray[n8];
                    n7 += ButtonPane.this.span.getGap(n8);
                    ++n8;
                }
                if (n5 > 0) {
                    n7 += ButtonPane.this.span.getGap(n5);
                }
                if (ButtonPane.this.station.isSmallButtons() && n6 < n4) {
                    n8 = n4 - n6;
                    n2 += n8 / 2;
                    n4 = n6;
                }
                if (n7 > n3) {
                    double d = (double)n3 / (double)n7;
                    int n9 = 0;
                    while (n9 < n5) {
                        int n10 = (int)((double)nArray[n9] * d);
                        this.getComponent(n9).setBounds(n += ButtonPane.this.span.getGap(n9), n2, n10, n4);
                        n += n10;
                        ++n9;
                    }
                } else {
                    n8 = 0;
                    while (n8 < n5) {
                        this.getComponent(n8).setBounds(n += ButtonPane.this.span.getGap(n8), n2, nArray[n8], n4);
                        n += nArray[n8];
                        ++n8;
                    }
                }
            } else {
                int n11 = this.getComponentCount();
                int[] nArray = new int[n11];
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                while (n14 < n11) {
                    Dimension dimension = this.getComponent(n14).getPreferredSize();
                    nArray[n14] = dimension.height;
                    n12 = Math.max(n12, dimension.width);
                    n13 += nArray[n14];
                    n13 += ButtonPane.this.span.getGap(n14);
                    ++n14;
                }
                if (n11 > 0) {
                    n13 += ButtonPane.this.span.getGap(n11);
                }
                if (ButtonPane.this.station.isSmallButtons() && n12 < n3) {
                    n14 = n3 - n12;
                    n += n14 / 2;
                    n3 = n12;
                }
                if (n13 > n4) {
                    double d = (double)n4 / (double)n13;
                    int n15 = 0;
                    while (n15 < n11) {
                        int n16 = (int)((double)nArray[n15] * d);
                        this.getComponent(n15).setBounds(n, n2 += ButtonPane.this.span.getGap(n15), n3, n16);
                        n2 += n16;
                        ++n15;
                    }
                } else {
                    n14 = 0;
                    while (n14 < n11) {
                        this.getComponent(n14).setBounds(n, n2 += ButtonPane.this.span.getGap(n14), n3, nArray[n14]);
                        n2 += nArray[n14];
                        ++n14;
                    }
                }
            }
            this.repaint();
        }
    }
}

