/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;

public class StationChildHandle
implements PlaceholderListItem<Dockable> {
    private DockStation station;
    private Dockable dockable;
    private DisplayerCollection displayers;
    private DockableDisplayer displayer;
    private DockTitleRequest titleRequest;
    private DockableListener listener = new DockableAdapter(){

        @Override
        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            if (dockable == StationChildHandle.this.dockable && StationChildHandle.this.displayer != null && StationChildHandle.this.displayer.getTitle() == dockTitle) {
                StationChildHandle.this.requestTitle();
            }
        }
    };

    public StationChildHandle(DockStation dockStation, DisplayerCollection displayerCollection, Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.station = dockStation;
        this.displayers = displayerCollection;
        this.dockable = dockable;
        dockable.addDockableListener(this.listener);
        this.setTitleRequest(dockTitleVersion, false);
    }

    public void destroy() {
        if (this.displayer != null) {
            DockTitle dockTitle = this.displayer.getTitle();
            if (dockTitle != null) {
                this.dockable.unbind(dockTitle);
            }
            this.displayers.release(this.displayer);
            this.displayer = null;
        }
        if (this.titleRequest != null) {
            this.titleRequest.uninstall();
            this.titleRequest = null;
        }
        this.dockable.removeDockableListener(this.listener);
    }

    public void updateDisplayer() {
        DockTitle dockTitle = null;
        if (this.displayer != null) {
            dockTitle = this.displayer.getTitle();
            this.displayers.release(this.displayer);
        } else if (this.titleRequest != null) {
            this.titleRequest.request();
            dockTitle = (DockTitle)this.titleRequest.getAnswer();
            if (dockTitle != null) {
                this.dockable.bind(dockTitle);
            }
        }
        this.displayer = this.displayers.fetch(this.dockable, dockTitle);
    }

    public DockableDisplayer getDisplayer() {
        return this.displayer;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public Dockable asDockable() {
        return this.getDockable();
    }

    public DockTitle getTitle() {
        if (this.titleRequest == null) {
            return null;
        }
        return (DockTitle)this.titleRequest.getAnswer();
    }

    public void setTitleRequest(DockTitleVersion dockTitleVersion) {
        this.setTitleRequest(dockTitleVersion, true);
    }

    public void setTitleRequest(DockTitleVersion dockTitleVersion, boolean bl) {
        if (this.titleRequest != null) {
            this.titleRequest.uninstall();
            this.titleRequest = null;
            DockTitle dockTitle = this.displayer.getTitle();
            if (dockTitle != null) {
                this.displayer.getDockable().unbind(dockTitle);
                this.displayer.setTitle(null);
            }
        }
        if (dockTitleVersion != null) {
            this.titleRequest = new DockTitleRequest(this.station, this.dockable, dockTitleVersion){

                @Override
                protected void answer(DockTitle dockTitle, DockTitle dockTitle2) {
                    StationChildHandle.this.updateTitle(dockTitle2);
                }
            };
        }
        if (this.titleRequest != null) {
            this.titleRequest.install();
            if (bl) {
                this.titleRequest.request();
            }
        }
    }

    public void requestTitle() {
        if (this.titleRequest != null) {
            this.titleRequest.request();
        }
    }

    protected void updateTitle(DockTitle dockTitle) {
        if (this.displayer != null) {
            DockTitle dockTitle2 = this.displayer.getTitle();
            if (dockTitle2 != null) {
                this.dockable.unbind(dockTitle2);
            }
            if (dockTitle != null) {
                this.dockable.bind(dockTitle);
            }
            this.displayer.setTitle(dockTitle);
        }
    }
}

