/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.util.Workarounds;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class OverpaintablePanel
extends JLayeredPane {
    private Overlay overlay = new Overlay();
    private JComponent content = new JPanel();
    private JComponent base = this.content;
    private boolean solid = true;

    public OverpaintablePanel() {
        this.content.setOpaque(false);
        this.setLayer(this.base, DEFAULT_LAYER);
        this.setLayer(this.overlay, DRAG_LAYER);
        this.add(this.base);
        this.add(this.overlay);
    }

    public void setSolid(boolean bl) {
        this.solid = bl;
        this.setOpaque(bl);
        if (this.base != this.content) {
            this.base.setOpaque(bl);
        }
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setContentPane(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        this.content = jComponent;
        this.setSolid(this.isSolid());
    }

    public JComponent getContentPane() {
        return this.content;
    }

    public void setBasePane(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("Base must not be null");
        }
        this.content = jComponent;
        this.remove(this.base);
        this.base = jComponent;
        this.setLayer(jComponent, DEFAULT_LAYER);
        this.add(jComponent);
        this.setSolid(this.isSolid());
    }

    public JComponent getBasePane() {
        return this.base;
    }

    protected void paintOverlay(Graphics graphics) {
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension dimension = null;
        if (this.base != null) {
            dimension = this.base.getMinimumSize();
        }
        Dimension dimension2 = null;
        if (this.overlay != null) {
            dimension2 = this.overlay.getMinimumSize();
        }
        if (dimension == null && dimension2 == null) {
            return super.getMinimumSize();
        }
        return this.max(dimension, dimension2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = null;
        if (this.base != null) {
            dimension = this.base.getPreferredSize();
        }
        Dimension dimension2 = null;
        if (this.overlay != null) {
            dimension2 = this.overlay.getPreferredSize();
        }
        if (dimension == null && dimension2 == null) {
            return super.getPreferredSize();
        }
        return this.max(dimension, dimension2);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        Dimension dimension = null;
        if (this.base != null) {
            dimension = this.base.getMaximumSize();
        }
        Dimension dimension2 = null;
        if (this.overlay != null) {
            dimension2 = this.overlay.getMaximumSize();
        }
        if (dimension == null && dimension2 == null) {
            return super.getMaximumSize();
        }
        return this.min(dimension, dimension2);
    }

    private Dimension min(Dimension dimension, Dimension dimension2) {
        if (dimension == null) {
            return dimension2;
        }
        if (dimension2 == null) {
            return dimension;
        }
        return new Dimension(Math.min(dimension.width, dimension2.width), Math.min(dimension.height, dimension2.height));
    }

    private Dimension max(Dimension dimension, Dimension dimension2) {
        if (dimension == null) {
            return dimension2;
        }
        if (dimension2 == null) {
            return dimension;
        }
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        this.base.setBounds(n, n2, n3, n4);
        this.overlay.setBounds(n, n2, n3, n4);
    }

    private class Overlay
    extends JPanel {
        public Overlay() {
            this.setLayout(null);
            this.setOpaque(false);
            Workarounds.getDefault().markAsGlassPane(this);
        }

        @Override
        public boolean contains(int n, int n2) {
            return false;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            OverpaintablePanel.this.paintOverlay(graphics);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 0);
        }
    }
}

