/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DisplayerCollection
implements Iterable<DockableDisplayer> {
    private DockStation station;
    private DockController controller;
    private DisplayerFactory factory;
    private List<Handle> displayers = new ArrayList<Handle>();
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();

    public DisplayerCollection(DockStation dockStation, DisplayerFactory displayerFactory) {
        if (dockStation == null) {
            throw new IllegalArgumentException("Station must not be null");
        }
        if (displayerFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.station = dockStation;
        this.factory = displayerFactory;
    }

    public DisplayerCollection(DockStation dockStation, final DefaultDisplayerFactoryValue defaultDisplayerFactoryValue) {
        this(dockStation, new DisplayerFactory(){

            @Override
            public void request(DisplayerRequest displayerRequest) {
                defaultDisplayerFactoryValue.request(displayerRequest);
            }
        });
    }

    public void addDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.add(dockableDisplayerListener);
        for (DockableDisplayer dockableDisplayer : this) {
            dockableDisplayer.addDockableDisplayerListener(dockableDisplayerListener);
        }
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.remove(dockableDisplayerListener);
        for (DockableDisplayer dockableDisplayer : this) {
            dockableDisplayer.removeDockableDisplayerListener(dockableDisplayerListener);
        }
    }

    public boolean isDisplayerComponent(Component component) {
        for (DockableDisplayer dockableDisplayer : this) {
            if (dockableDisplayer.getComponent() != component) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<DockableDisplayer> iterator() {
        return new Iterator<DockableDisplayer>(){
            private Iterator<Handle> handles;
            {
                this.handles = DisplayerCollection.this.displayers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.handles.hasNext();
            }

            @Override
            public DockableDisplayer next() {
                return (DockableDisplayer)this.handles.next().getAnswer();
            }

            @Override
            public void remove() {
                this.handles.remove();
            }
        };
    }

    public DockableDisplayer fetch(Dockable dockable, DockTitle dockTitle) {
        Handle handle = new Handle(dockable);
        handle.setController(this.controller);
        handle.request(dockTitle);
        DockableDisplayer dockableDisplayer = (DockableDisplayer)handle.getAnswer();
        dockableDisplayer.setDockable(dockable);
        dockableDisplayer.setTitle(dockTitle);
        dockableDisplayer.setStation(this.station);
        this.displayers.add(handle);
        for (DockableDisplayerListener dockableDisplayerListener : this.listeners) {
            dockableDisplayer.addDockableDisplayerListener(dockableDisplayerListener);
        }
        return dockableDisplayer;
    }

    public void release(DockableDisplayer dockableDisplayer) {
        for (DockableDisplayerListener object2 : this.listeners) {
            dockableDisplayer.removeDockableDisplayerListener(object2);
        }
        Iterator<DockableDisplayer> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != dockableDisplayer) continue;
            iterator.remove();
        }
        dockableDisplayer.setTitle(null);
        dockableDisplayer.setDockable(null);
        dockableDisplayer.setStation(null);
        dockableDisplayer.setController(null);
    }

    public void setFactory(DisplayerFactory displayerFactory) {
        if (displayerFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = displayerFactory;
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            this.controller = dockController;
            for (Handle handle : this.displayers) {
                handle.setController(dockController);
            }
        }
    }

    private class Handle
    extends DisplayerRequest {
        public Handle(Dockable dockable) {
            super(DisplayerCollection.this.station, dockable, new DisplayerFactory(){

                @Override
                public void request(DisplayerRequest displayerRequest) {
                    DisplayerCollection.this.factory.request(displayerRequest);
                }
            });
        }

        @Override
        public void setController(DockController dockController) {
            super.setController(dockController);
            DockableDisplayer dockableDisplayer = (DockableDisplayer)this.getAnswer();
            if (dockableDisplayer != null) {
                dockableDisplayer.setController(null);
            }
        }

        @Override
        protected void answer(DockableDisplayer dockableDisplayer, DockableDisplayer dockableDisplayer2) {
            if (dockableDisplayer != null) {
                dockableDisplayer.setController(null);
            }
            if (dockableDisplayer2 != null) {
                dockableDisplayer2.setController(this.getController());
            }
        }
    }
}

