/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.DockStationDelegate;
import bibliothek.gui.dock.station.DockStationIcon;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.io.IOException;
import javax.swing.Icon;

public abstract class AbstractDockableStation
extends AbstractDockable
implements DockStation {
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;

    public AbstractDockableStation() {
        super(PropertyKey.DOCK_STATION_TITLE, PropertyKey.DOCK_STATION_TOOLTIP);
    }

    @Override
    protected DockIcon createTitleIcon() {
        return new DockStationIcon("dockStation.default", this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                AbstractDockableStation.this.fireTitleIconChanged(icon, icon2);
            }
        };
    }

    public AbstractDockableStation(DockTheme dockTheme) {
        this();
        this.theme = dockTheme;
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme dockTheme;
        DockController dockController = this.getController();
        if (dockController != null && (dockTheme = dockController.getTheme()) != this.theme) {
            this.theme = dockTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    @Override
    public DockActionSource getDirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public void addDockStationListener(DockStationListener dockStationListener) {
        this.listeners.addListener(dockStationListener);
    }

    @Override
    public void removeDockStationListener(DockStationListener dockStationListener) {
        this.listeners.removeListener(dockStationListener);
    }

    @Override
    @Deprecated
    public boolean isVisible(Dockable dockable) {
        return this.isStationShowing();
    }

    @Override
    public boolean isChildShowing(Dockable dockable) {
        return this.isVisible(dockable);
    }

    @Override
    public boolean isStationShowing() {
        return this.isStationVisible();
    }

    @Override
    @Deprecated
    public boolean isStationVisible() {
        boolean bl = this.isDockableShowing();
        if (bl) {
            return true;
        }
        if (this.getController() != null) {
            return this.getComponent().isShowing();
        }
        return false;
    }

    @Override
    public boolean accept(Dockable dockable) {
        return true;
    }

    public boolean acceptable(Dockable dockable) {
        return DockUtilities.acceptable(this, dockable);
    }

    public boolean acceptable(Dockable dockable, Dockable dockable2) {
        return DockUtilities.acceptable(this, dockable, dockable2);
    }

    @Override
    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        dockTitle.changed(new ActivityDockTitleEvent(this, dockable, bl));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void requestChildDisplayer(DisplayerRequest displayerRequest) {
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new DefaultDropLayer(this)};
    }

    protected void fireDockablesRepositioned(int n) {
        this.fireDockablesRepositioned(n, this.getDockableCount() - 1);
    }

    protected void fireDockablesRepositioned(int n, int n2) {
        int n3 = n2 - n + 1;
        if (n3 > 0) {
            Dockable[] dockableArray = new Dockable[n3];
            int n4 = 0;
            while (n4 < n3) {
                dockableArray[n4] = this.getDockable(n4 + n);
                ++n4;
            }
            this.listeners.fireDockablesRepositioned(dockableArray);
        }
    }

    protected DockStationDelegate delegate() {
        return new DockStationDelegate();
    }
}

