/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.DockStationDelegate;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import java.io.IOException;

public abstract class AbstractDockStation
implements DockStation {
    private DockController controller;
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;
    private DockComponentRootHandler rootHandler;

    protected DockComponentRootHandler getRootHandler() {
        if (this.rootHandler == null) {
            this.rootHandler = this.createRootHandler();
        }
        return this.rootHandler;
    }

    protected abstract DockComponentRootHandler createRootHandler();

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        this.getRootHandler().setController(dockController);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.getRootHandler().getConfiguration();
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        this.getRootHandler().setConfiguration(dockComponentConfiguration);
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme dockTheme;
        DockController dockController = this.getController();
        if (dockController != null && (dockTheme = dockController.getTheme()) != this.theme) {
            this.theme = dockTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    @Override
    public void addDockStationListener(DockStationListener dockStationListener) {
        this.listeners.addListener(dockStationListener);
    }

    @Override
    public void removeDockStationListener(DockStationListener dockStationListener) {
        this.listeners.removeListener(dockStationListener);
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return true;
    }

    @Override
    public boolean accept(Dockable dockable) {
        return true;
    }

    public boolean canCompare(DockStation dockStation) {
        return false;
    }

    public int compare(DockStation dockStation) {
        return 0;
    }

    @Override
    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        dockTitle.changed(new ActivityDockTitleEvent(this, dockable, bl));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void requestChildDisplayer(DisplayerRequest displayerRequest) {
    }

    protected DockStationDelegate delegate() {
        return new DockStationDelegate();
    }
}

