/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.security;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.security.GlassedPane;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.JComponent;

public class SecureContainer
extends OverpaintablePanel {
    private DockController controller;
    private GlassedPane pane;
    private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            SecureContainer.this.checkRestricted();
        }
    };

    public void setController(DockController dockController) {
        this.controller = dockController;
        if (this.pane != null) {
            this.pane.setController(dockController);
        }
        this.restricted.setProperties(dockController);
        this.checkRestricted();
    }

    public DockController getController() {
        return this.controller;
    }

    private void checkRestricted() {
        if (this.restricted.getProperties() != null) {
            this.setUseGlassPane(this.restricted.getValue());
        }
    }

    protected boolean isUseGlassPane() {
        return this.pane != null;
    }

    protected void setUseGlassPane(boolean bl) {
        if (bl) {
            if (this.pane == null) {
                this.pane = this.createGlassPane();
                this.pane.setController(this.controller);
                this.install(this.pane);
            }
        } else if (this.pane != null) {
            this.uninstall(this.pane);
            this.pane.setController(null);
            this.pane = null;
        }
    }

    protected void install(GlassedPane glassedPane) {
        JComponent jComponent = this.getContentPane();
        this.setBasePane(glassedPane);
        glassedPane.setContentPane(jComponent);
        this.setContentPane(jComponent);
    }

    protected void uninstall(GlassedPane glassedPane) {
        JComponent jComponent = this.getContentPane();
        glassedPane.setContentPane(null);
        this.setBasePane(jComponent);
    }

    protected GlassedPane createGlassPane() {
        return new GlassedPane();
    }
}

