/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.security;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.security.DefaultTooltipStrategy;
import bibliothek.gui.dock.security.TooltipStrategy;
import bibliothek.gui.dock.security.TooltipStrategyCallback;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Workarounds;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class GlassedPane
extends JPanel {
    public static final PropertyKey<TooltipStrategy> TOOLTIP_STRATEGY = new PropertyKey<DefaultTooltipStrategy>("tooltip strategy", new ConstantPropertyFactory<DefaultTooltipStrategy>(new DefaultTooltipStrategy()), true);
    private JComponent contentPane = new JPanel();
    private JComponent glassPane = new GlassPane();
    private DockController controller;
    private boolean onSending = false;
    private PropertyValue<TooltipStrategy> tooltips = new PropertyValue<TooltipStrategy>(TOOLTIP_STRATEGY){

        @Override
        protected void valueChanged(TooltipStrategy tooltipStrategy, TooltipStrategy tooltipStrategy2) {
            if (tooltipStrategy != null) {
                tooltipStrategy.uninstall(GlassedPane.this);
            }
            if (tooltipStrategy2 != null) {
                tooltipStrategy2.install(GlassedPane.this);
            }
        }
    };

    public GlassedPane() {
        this.setLayout(null);
        this.contentPane.setOpaque(false);
        this.setOpaque(false);
        this.add(this.glassPane);
        this.add(this.contentPane);
        this.setFocusCycleRoot(true);
    }

    public void setController(DockController dockController) {
        this.controller = dockController;
        this.tooltips.setProperties(dockController);
    }

    @Override
    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.contentPane != null) {
            this.contentPane.setBounds(0, 0, n, n2);
        }
        this.glassPane.setBounds(0, 0, n, n2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.contentPane == null) {
            return super.getPreferredSize();
        }
        return this.contentPane.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.contentPane == null) {
            return super.getMaximumSize();
        }
        return this.contentPane.getMaximumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.contentPane == null) {
            return super.getMinimumSize();
        }
        return this.contentPane.getMinimumSize();
    }

    public void setContentPane(JComponent jComponent) {
        this.contentPane = jComponent;
        this.removeAll();
        this.add(this.glassPane);
        if (jComponent != null) {
            this.add(jComponent);
        }
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public class GlassPane
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Component dragged;
        private Component over;
        private int downCount = 0;
        private TooltipStrategyCallback callback = new TooltipStrategyCallback(){

            @Override
            public void setToolTipText(String string) {
                GlassPane.this.setToolTipText(string);
            }

            @Override
            public String getToolTipText() {
                return GlassPane.this.getToolTipText();
            }

            @Override
            public GlassedPane getGlassedPane() {
                return GlassedPane.this;
            }

            @Override
            public JToolTip createToolTip() {
                return GlassPane.this.superCreateToolTip();
            }
        };

        public GlassPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.setOpaque(false);
            this.setFocusable(false);
            Workarounds.getDefault().markAsGlassPane(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && this.isVisible()) {
                this.send(mouseEvent);
            }
            if (!this.isVisible()) {
                this.downCount = 0;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.send(mouseEvent);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!mouseWheelEvent.isConsumed()) {
                this.send(mouseWheelEvent);
            }
        }

        private void send(MouseEvent mouseEvent) {
            this.send(mouseEvent, mouseEvent.getID());
        }

        private void send(MouseEvent mouseEvent, int n) {
            if (!GlassedPane.this.onSending) {
                try {
                    GlassedPane.this.onSending = true;
                    this.sendNow(mouseEvent, n);
                }
                finally {
                    GlassedPane.this.onSending = false;
                }
            }
        }

        private void sendNow(MouseEvent mouseEvent, int n) {
            Serializable serializable;
            boolean bl;
            if (GlassedPane.this.contentPane == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, point.x, point.y);
            component = component != null && !component.isEnabled() ? null : this.fallThrough(component, mouseEvent);
            boolean bl2 = n == 506;
            boolean bl3 = n == 501;
            boolean bl4 = n == 502;
            boolean bl5 = n == 503;
            boolean bl6 = n == 504;
            boolean bl7 = bl = n == 505;
            if (bl2 && this.dragged == null) {
                this.dragged = component;
            } else if (bl2) {
                component = this.dragged;
            }
            if (bl3) {
                this.downCount |= 1 << mouseEvent.getButton();
            }
            if (this.downCount > 0 && this.dragged != null) {
                component = this.dragged;
            } else if (this.downCount > 0 && this.dragged == null) {
                this.dragged = component;
            } else if (this.downCount == 0) {
                this.dragged = null;
            }
            if (bl4) {
                this.downCount &= ~(1 << mouseEvent.getButton());
            }
            if ((mouseEvent.getModifiersEx() & 0x1C00) == 0) {
                this.downCount = 0;
                this.dragged = null;
            }
            boolean bl8 = false;
            if ((bl5 || bl6 || bl) && this.over != component) {
                bl8 = true;
                if (this.over != null) {
                    serializable = SwingUtilities.convertPoint(this, point, this.over);
                    this.over.dispatchEvent(new MouseEvent(this.over, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), serializable.x, serializable.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                }
                this.over = component;
                if (this.over != null) {
                    serializable = SwingUtilities.convertPoint(this, point, this.over);
                    this.over.dispatchEvent(new MouseEvent(this.over, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), serializable.x, serializable.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                }
            }
            if (component == null) {
                this.setCursor(null);
                this.setToolTipText(null);
            } else {
                point = SwingUtilities.convertPoint(this, point, component);
                serializable = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                if (GlassedPane.this.controller != null) {
                    GlassedPane.this.controller.getGlobalMouseDispatcher().dispatch((MouseEvent)serializable);
                }
                component.dispatchEvent((AWTEvent)serializable);
                Cursor cursor = component.getCursor();
                if (this.getCursor() != cursor) {
                    this.setCursor(cursor);
                }
                ((TooltipStrategy)GlassedPane.this.tooltips.getValue()).setTooltipText(this.over, (MouseEvent)serializable, bl8, this.callback);
            }
        }

        private Component fallThrough(Component component, MouseEvent mouseEvent) {
            Class clazz = null;
            clazz = mouseEvent.getID() == 506 || mouseEvent.getID() == 503 ? MouseMotionListener.class : (mouseEvent.getID() == 507 ? MouseWheelListener.class : MouseListener.class);
            while (component != null && component.getListeners(clazz).length == 0) {
                component = component.getParent();
            }
            return component;
        }

        @Override
        public JToolTip createToolTip() {
            return ((TooltipStrategy)GlassedPane.this.tooltips.getValue()).createTooltip(this.over, this.callback);
        }

        private JToolTip superCreateToolTip() {
            return super.createToolTip();
        }

        private void send(MouseWheelEvent mouseWheelEvent) {
            if (GlassedPane.this.contentPane == null) {
                return;
            }
            Point point = mouseWheelEvent.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, point.x, point.y);
            if (component != null) {
                point = SwingUtilities.convertPoint(this, point, component);
                MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent(component, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                if (GlassedPane.this.controller != null) {
                    GlassedPane.this.controller.getGlobalMouseDispatcher().dispatch(mouseWheelEvent2);
                }
                component.dispatchEvent(mouseWheelEvent2);
            }
        }
    }
}

