/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.perspective;

import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Perspective {
    private DockSituation situation;

    public Perspective(DockSituation dockSituation) {
        this.situation = dockSituation;
    }

    public Map<String, PerspectiveStation> readXML(XElement xElement) {
        Map<String, DockLayoutComposition> map = this.situation.readCompositionsXML(xElement);
        HashMap<String, PerspectiveStation> hashMap = new HashMap<String, PerspectiveStation>();
        for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
            PerspectiveStation perspectiveStation;
            PerspectiveElement perspectiveElement = this.convert(entry.getValue());
            PerspectiveStation perspectiveStation2 = perspectiveStation = perspectiveElement == null ? null : perspectiveElement.asStation();
            if (perspectiveStation == null) continue;
            hashMap.put(entry.getKey(), perspectiveStation);
        }
        return hashMap;
    }

    public void writeXML(Map<String, PerspectiveStation> map, XElement xElement) {
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, PerspectiveStation> entry : map.entrySet()) {
            DockLayoutComposition dockLayoutComposition = this.convert(entry.getValue());
            if (dockLayoutComposition == null) continue;
            hashMap.put(entry.getKey(), dockLayoutComposition);
        }
        this.situation.writeCompositionsXML(hashMap, xElement);
    }

    public Map<String, PerspectiveStation> read(DataInputStream dataInputStream) throws IOException {
        Map<String, DockLayoutComposition> map = this.situation.readCompositions(dataInputStream);
        HashMap<String, PerspectiveStation> hashMap = new HashMap<String, PerspectiveStation>();
        for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
            PerspectiveStation perspectiveStation;
            PerspectiveElement perspectiveElement = this.convert(entry.getValue());
            PerspectiveStation perspectiveStation2 = perspectiveStation = perspectiveElement == null ? null : perspectiveElement.asStation();
            if (perspectiveStation == null) continue;
            hashMap.put(entry.getKey(), perspectiveStation);
        }
        return hashMap;
    }

    public void write(Map<String, PerspectiveStation> map, DataOutputStream dataOutputStream) throws IOException {
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, PerspectiveStation> entry : map.entrySet()) {
            DockLayoutComposition dockLayoutComposition = this.convert(entry.getValue());
            if (dockLayoutComposition == null) continue;
            hashMap.put(entry.getKey(), dockLayoutComposition);
        }
        this.situation.writeCompositions(hashMap, dataOutputStream);
    }

    public DockLayoutComposition convert(PerspectiveElement perspectiveElement) {
        Object object;
        PerspectiveDockable perspectiveDockable;
        if (perspectiveElement == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        DockSituationIgnore dockSituationIgnore = this.situation.getIgnore();
        if (dockSituationIgnore != null && dockSituationIgnore.ignoreElement(perspectiveElement)) {
            return null;
        }
        String string = this.getID(perspectiveElement);
        DockFactory<?, ?, ?> dockFactory = this.getFactory(string);
        if (dockFactory == null) {
            throw new IllegalArgumentException("missing factory: " + perspectiveElement.getFactoryID());
        }
        HashMap<PerspectiveDockable, Integer> hashMap = new HashMap<PerspectiveDockable, Integer>();
        ArrayList<DockLayoutComposition> arrayList = new ArrayList<DockLayoutComposition>();
        boolean bl = false;
        PerspectiveStation perspectiveStation = perspectiveElement.asStation();
        if (perspectiveStation != null) {
            if (dockSituationIgnore == null || !dockSituationIgnore.ignoreChildren(perspectiveStation)) {
                int n = 0;
                int n2 = 0;
                int n3 = perspectiveStation.getDockableCount();
                while (n2 < n3) {
                    perspectiveDockable = perspectiveStation.getDockable(n2);
                    object = this.convert(perspectiveDockable);
                    if (object != null) {
                        arrayList.add((DockLayoutComposition)object);
                        hashMap.put(perspectiveDockable, n++);
                    }
                    ++n2;
                }
            } else {
                bl = true;
            }
        }
        Object l = dockFactory.getPerspectiveLayout(perspectiveElement, hashMap);
        DockLayout dockLayout = new DockLayout(string, l);
        DockLayoutInfo dockLayoutInfo = new DockLayoutInfo(dockLayout);
        perspectiveDockable = perspectiveElement.asDockable();
        if (perspectiveDockable != null) {
            dockLayoutInfo.setPlaceholder(perspectiveDockable.getPlaceholder());
        }
        object = null;
        for (AdjacentDockFactory<?> adjacentDockFactory : this.situation.getAdjacentFactorys().values()) {
            if (!adjacentDockFactory.interested(perspectiveElement) || (l = adjacentDockFactory.getPerspectiveLayout(perspectiveElement, hashMap)) == null) continue;
            dockLayout = new DockLayout(adjacentDockFactory.getID(), l);
            if (object == null) {
                object = new ArrayList();
            }
            object.add(dockLayout);
        }
        return new DockLayoutComposition(dockLayoutInfo, (List<DockLayout<?>>)object, (List<DockLayoutComposition>)arrayList, bl);
    }

    public PerspectiveElement convert(DockLayoutComposition dockLayoutComposition) {
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo == null) {
            return null;
        }
        DockLayout<?> dockLayout = dockLayoutInfo.getDataLayout();
        if (dockLayout == null || dockLayout.getData() == null) {
            return null;
        }
        DockFactory<?, ?, ?> dockFactory = this.getFactory(dockLayout.getFactoryID());
        if (dockFactory == null) {
            return null;
        }
        PerspectiveElement perspectiveElement = null;
        if (dockLayoutComposition.isIgnoreChildren()) {
            for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
                this.convert(dockLayoutComposition2);
            }
            perspectiveElement = (PerspectiveElement)dockFactory.layoutPerspective(dockLayout.getData(), null);
        } else {
            HashMap<Integer, PerspectiveDockable> hashMap = new HashMap<Integer, PerspectiveDockable>();
            int n = 0;
            for (DockLayoutComposition dockLayoutComposition3 : dockLayoutComposition.getChildren()) {
                PerspectiveDockable perspectiveDockable;
                PerspectiveElement perspectiveElement2 = this.convert(dockLayoutComposition3);
                if (perspectiveElement2 != null && (perspectiveDockable = perspectiveElement2.asDockable()) != null) {
                    hashMap.put(n, perspectiveDockable);
                }
                ++n;
            }
            perspectiveElement = (PerspectiveElement)dockFactory.layoutPerspective(dockLayout.getData(), hashMap);
        }
        return perspectiveElement;
    }

    public DockSituation getSituation() {
        return this.situation;
    }

    protected abstract String getID(PerspectiveElement var1);

    protected abstract DockFactory<?, ?, ?> getFactory(String var1);
}

