/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout.location;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.layout.location.DefaultAsideAnswer;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;

public class DefaultAsideRequest
implements AsideRequest {
    private DockableProperty location;
    private Path placeholder;
    private DockStation parent;
    private Forward current;
    private DockableProperty resultingLocation;
    private PlaceholderMap resultingLayout;
    private boolean hasAnswer = false;
    private AsideAnswer successorAnswer;

    public DefaultAsideRequest(DockableProperty dockableProperty, Path path) {
        this.location = dockableProperty;
        this.placeholder = path;
    }

    protected DefaultAsideRequest createForwardRequest(DockableProperty dockableProperty) {
        return new DefaultAsideRequest(dockableProperty, this.getPlaceholder());
    }

    @Override
    public DockableProperty getLocation() {
        return this.location;
    }

    @Override
    public Path getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public PlaceholderMap getLayout() {
        return this.current.getLayout();
    }

    @Override
    public DockStation getParentStation() {
        return this.parent;
    }

    protected void setParentStation(DockStation dockStation) {
        this.parent = dockStation;
    }

    @Override
    public void answer() {
        this.answer((DockableProperty)null);
    }

    @Override
    public void answer(DockableProperty dockableProperty) {
        this.hasAnswer = true;
        this.resultingLocation = dockableProperty;
    }

    @Override
    public void answer(PlaceholderMap placeholderMap) {
        this.hasAnswer = true;
        this.resultingLayout = placeholderMap;
    }

    @Override
    public void answer(DockableProperty dockableProperty, PlaceholderMap placeholderMap) {
        this.answer(dockableProperty);
        this.answer(placeholderMap);
    }

    protected void setCurrent(Forward forward) {
        this.current = forward;
        this.resultingLayout = forward.getLayout();
    }

    @Override
    public AsideAnswer execute(DockStation dockStation) {
        this.setCurrent(new DockStationForward(dockStation));
        return this.execute();
    }

    protected AsideAnswer execute() {
        if (this.hasAnswer) {
            throw new IllegalStateException("this request is already used, it cannot be executed a second time");
        }
        this.current.execute(this);
        if (this.hasAnswer) {
            this.hasAnswer = true;
            DockableProperty dockableProperty = this.answerLocation(this.successorAnswer);
            return new DefaultAsideAnswer(false, dockableProperty, this.resultingLayout);
        }
        return new DefaultAsideAnswer(true, null, null);
    }

    private DockableProperty answerLocation(AsideAnswer asideAnswer) {
        if (asideAnswer == null || asideAnswer.getLocation() == null) {
            return this.resultingLocation;
        }
        if (this.resultingLocation == null) {
            return asideAnswer.getLocation();
        }
        DockableProperty dockableProperty = this.resultingLocation;
        while (dockableProperty.getSuccessor() != null) {
            dockableProperty = dockableProperty.getSuccessor();
        }
        dockableProperty.setSuccessor(asideAnswer.getLocation());
        return this.resultingLocation;
    }

    @Override
    public AsideAnswer forward(DockStation dockStation) {
        return this.forward(new DockStationForward(dockStation));
    }

    @Override
    public AsideAnswer forward(Combiner combiner) {
        return this.forward(new CombinerForward(combiner, null));
    }

    @Override
    public AsideAnswer forward(Combiner combiner, PlaceholderMap placeholderMap) {
        return this.forward(new CombinerForward(combiner, placeholderMap));
    }

    protected AsideAnswer forward(Forward forward) {
        DockableProperty dockableProperty = null;
        if (this.location != null) {
            dockableProperty = this.location.getSuccessor();
        }
        DefaultAsideRequest defaultAsideRequest = this.createForwardRequest(dockableProperty);
        defaultAsideRequest.setCurrent(forward);
        defaultAsideRequest.setParentStation(this.current.getStation());
        this.successorAnswer = defaultAsideRequest.execute();
        return this.successorAnswer;
    }

    protected static class CombinerForward
    implements Forward {
        private Combiner combiner;
        private PlaceholderMap layout;

        public CombinerForward(Combiner combiner, PlaceholderMap placeholderMap) {
            this.combiner = combiner;
            this.layout = placeholderMap;
        }

        @Override
        public PlaceholderMap getLayout() {
            return this.layout;
        }

        @Override
        public void execute(AsideRequest asideRequest) {
            this.combiner.aside(asideRequest);
        }

        @Override
        public DockStation getStation() {
            return null;
        }
    }

    protected static class DockStationForward
    implements Forward {
        private DockStation station;

        public DockStationForward(DockStation dockStation) {
            this.station = dockStation;
        }

        @Override
        public PlaceholderMap getLayout() {
            return null;
        }

        @Override
        public void execute(AsideRequest asideRequest) {
            this.station.aside(asideRequest);
        }

        @Override
        public DockStation getStation() {
            return this.station;
        }
    }

    protected static interface Forward {
        public PlaceholderMap getLayout();

        public DockStation getStation();

        public void execute(AsideRequest var1);
    }
}

