/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.BackupFactoryData;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.layout.PredefinedLayout;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PredefinedPerspective;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PredefinedDockSituation
extends DockSituation {
    private Map<String, DockElement> stringToElement = new HashMap<String, DockElement>();
    private Map<DockElement, String> elementToString = new HashMap<DockElement, String>();
    private static final String KNOWN = "predefined";
    private static final String UNKNOWN = "delegate_";
    private Map<String, DockFactory<? extends DockElement, ?, ? extends BackupFactoryData<?>>> backups = new HashMap();
    private final PreloadFactory factory = new PreloadFactory();

    public PredefinedDockSituation(DockController dockController) {
        super(dockController);
    }

    @Override
    public PredefinedPerspective createPerspective() {
        return new PredefinedPerspective(this){
            private PreloadFactory preload;
            {
                this.preload = new PreloadFactory(this);
            }

            @Override
            protected String getID(PerspectiveElement perspectiveElement) {
                return PredefinedDockSituation.this.getID(perspectiveElement, this);
            }

            @Override
            protected DockFactory<?, ?, ?> getFactory(String string) {
                DockFactory<? extends DockElement, ?, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == PredefinedDockSituation.this.factory) {
                    return this.preload;
                }
                return dockFactory;
            }
        };
    }

    public void addBackup(DockFactory<? extends DockElement, ?, ? extends BackupFactoryData<?>> dockFactory) {
        this.backups.put(UNKNOWN + dockFactory.getID(), dockFactory);
    }

    public void removeBackup(String string) {
        this.backups.remove(UNKNOWN + string);
    }

    @Deprecated
    public void put(DockElement dockElement) {
        this.put(String.valueOf(this.stringToElement.size()), dockElement);
    }

    public void put(String string, DockElement dockElement) {
        if (this.stringToElement.containsKey(string)) {
            throw new IllegalArgumentException("Key does already exist: " + string);
        }
        this.stringToElement.put(string, dockElement);
        this.elementToString.put(dockElement, string);
    }

    protected boolean shouldLayout(DockElement dockElement) {
        return true;
    }

    protected boolean shouldLayout(PerspectiveElement perspectiveElement, PredefinedPerspective predefinedPerspective) {
        DockElement dockElement;
        String string = predefinedPerspective.get(perspectiveElement);
        if (string != null && (dockElement = this.stringToElement.get(string)) != null) {
            return this.shouldLayout(dockElement);
        }
        return true;
    }

    @Override
    protected DockLayoutInfo fillMissing(DockLayoutInfo dockLayoutInfo) {
        DockLayout<?> dockLayout = dockLayoutInfo.getDataLayout();
        if (KNOWN.equals(dockLayout.getFactoryID())) {
            PredefinedLayout predefinedLayout = (PredefinedLayout)dockLayout.getData();
            DockLayoutInfo dockLayoutInfo2 = predefinedLayout.getDelegate();
            DockLayoutInfo dockLayoutInfo3 = null;
            if (dockLayoutInfo2.getKind() == DockLayoutInfo.Data.BYTE) {
                dockLayoutInfo3 = this.fillMissingStream(predefinedLayout);
            } else if (dockLayoutInfo2.getKind() == DockLayoutInfo.Data.XML) {
                dockLayoutInfo3 = this.fillMissingXML(predefinedLayout);
            }
            if (dockLayoutInfo3 != null) {
                dockLayoutInfo = new DockLayoutInfo(new DockLayout<PredefinedLayout>(KNOWN, new PredefinedLayout(predefinedLayout.getPredefined(), dockLayoutInfo3)));
            }
        }
        return dockLayoutInfo;
    }

    public <D extends DockElement> Set<D> listVisible(Collection<D> collection, DockLayoutComposition dockLayoutComposition) {
        HashSet hashSet = new HashSet();
        this.listVisible(collection, dockLayoutComposition, hashSet);
        return hashSet;
    }

    private <D extends DockElement> void listVisible(final Collection<D> collection, DockLayoutComposition dockLayoutComposition, final Set<D> set) {
        Object object;
        String string;
        DockElement dockElement;
        DockLayout<?> object22;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && KNOWN.equals((object22 = dockLayoutInfo.getDataLayout()).getFactoryID()) && (dockElement = this.stringToElement.get(string = ((PredefinedLayout)(object = (PredefinedLayout)object22.getData())).getPredefined())) != null) {
            if (collection.contains(dockElement)) {
                set.add(dockElement);
            }
            if (dockLayoutComposition.isIgnoreChildren()) {
                DockUtilities.visit(dockElement, new DockUtilities.DockVisitor(){

                    @Override
                    public void handleDockable(Dockable dockable) {
                        if (collection.contains(dockable)) {
                            set.add(dockable);
                        }
                    }

                    @Override
                    public void handleDockStation(DockStation dockStation) {
                        if (collection.contains(dockStation)) {
                            set.add(dockStation);
                        }
                    }
                });
            }
        }
        for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
            this.listVisible(collection, dockLayoutComposition2, set);
        }
    }

    public Map<String, DockableProperty> listEstimatedLocations(DockLayoutComposition dockLayoutComposition, boolean bl) {
        return this.listEstimatedLocations(dockLayoutComposition, dockLayoutComposition.getLayout().getLocation(), bl);
    }

    public Map<String, DockableProperty> listEstimatedLocations(DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty, boolean bl) {
        String string;
        this.estimateLocations(dockLayoutComposition, dockableProperty);
        HashMap<String, DockableProperty> hashMap = new HashMap<String, DockableProperty>();
        this.listEstimatedLocations(dockLayoutComposition, bl, hashMap);
        if (dockableProperty != null && (string = this.getKey(dockLayoutComposition, bl)) != null) {
            hashMap.put(string, dockableProperty);
        }
        return hashMap;
    }

    private void listEstimatedLocations(DockLayoutComposition dockLayoutComposition, boolean bl, Map<String, DockableProperty> map) {
        Object object;
        DockableProperty dockableProperty = dockLayoutComposition.getLayout().getLocation();
        if (dockableProperty != null && (object = this.getKey(dockLayoutComposition, bl)) != null) {
            map.put((String)object, dockableProperty);
        }
        if ((object = dockLayoutComposition.getChildren()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DockLayoutComposition dockLayoutComposition2 = (DockLayoutComposition)iterator.next();
                this.listEstimatedLocations(dockLayoutComposition2, bl, map);
            }
        }
    }

    public Map<String, DockLayoutComposition> listLayouts(DockLayoutComposition dockLayoutComposition, boolean bl) {
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        this.listLayouts(dockLayoutComposition, bl, hashMap);
        return hashMap;
    }

    private void listLayouts(DockLayoutComposition dockLayoutComposition, boolean bl, Map<String, DockLayoutComposition> map) {
        List<DockLayoutComposition> list;
        String string = this.getKey(dockLayoutComposition, bl);
        if (string != null) {
            map.put(string, dockLayoutComposition);
        }
        if ((list = dockLayoutComposition.getChildren()) != null) {
            for (DockLayoutComposition dockLayoutComposition2 : list) {
                this.listLayouts(dockLayoutComposition2, bl, map);
            }
        }
    }

    private String getKey(DockLayoutComposition dockLayoutComposition, boolean bl) {
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() != DockLayoutInfo.Data.DOCK_LAYOUT) {
            return null;
        }
        if (!KNOWN.equals(dockLayoutInfo.getDataLayout().getFactoryID())) {
            return null;
        }
        PredefinedLayout predefinedLayout = (PredefinedLayout)dockLayoutInfo.getDataLayout().getData();
        if (bl && predefinedLayout.getDelegate().getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && this.stringToElement.containsKey(predefinedLayout.getPredefined())) {
            return null;
        }
        String string = predefinedLayout.getPredefined();
        return string;
    }

    private DockLayoutInfo fillMissingStream(PredefinedLayout predefinedLayout) {
        byte[] byArray = predefinedLayout.getDelegate().getDataByte();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            String string = dataInputStream.readUTF();
            DockFactory<DockElement, ?, ?> dockFactory = this.getFactory(string);
            DockLayoutInfo dockLayoutInfo = null;
            if (dockFactory == null) {
                BackupFactoryData backupFactoryData;
                DockFactory<DockElement, ?, BackupFactoryData<?>> dockFactory2 = this.getBackup(string);
                if (dockFactory2 != null && (backupFactoryData = (BackupFactoryData)dockFactory2.read(dataInputStream, this.getPlaceholderStrategy())) != null && backupFactoryData.getData() != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, backupFactoryData.getData()));
                }
            } else {
                Object l = dockFactory.read(dataInputStream, this.getPlaceholderStrategy());
                if (l != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, l));
                }
            }
            dataInputStream.close();
            return dockLayoutInfo;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read stream", iOException);
        }
    }

    private DockLayoutInfo fillMissingXML(PredefinedLayout predefinedLayout) {
        XElement xElement = predefinedLayout.getDelegate().getDataXML();
        String string = xElement.getString("id");
        Object l = null;
        DockFactory<DockElement, ?, ?> dockFactory = this.getFactory(string);
        if (dockFactory == null) {
            BackupFactoryData backupFactoryData;
            DockFactory<DockElement, ?, BackupFactoryData<?>> dockFactory2 = this.getBackup(string);
            if (dockFactory2 != null && (backupFactoryData = (BackupFactoryData)dockFactory2.read(xElement, this.getPlaceholderStrategy())) != null) {
                l = backupFactoryData.getData();
            }
        } else {
            l = dockFactory.read(xElement, this.getPlaceholderStrategy());
        }
        if (l == null) {
            return null;
        }
        return new DockLayoutInfo(new DockLayout<Object>(string, l));
    }

    protected String getID(PerspectiveElement perspectiveElement, PredefinedPerspective predefinedPerspective) {
        String string = predefinedPerspective.get(perspectiveElement);
        if (string == null) {
            return UNKNOWN + super.getID(perspectiveElement);
        }
        return KNOWN;
    }

    @Override
    public String getID(DockElement dockElement) {
        String string = this.elementToString.get(dockElement);
        if (string == null) {
            return UNKNOWN + super.getID(dockElement);
        }
        return KNOWN;
    }

    @Override
    protected String getID(DockFactory<?, ?, ?> dockFactory) {
        if (dockFactory == this.factory) {
            return KNOWN;
        }
        return UNKNOWN + super.getID(dockFactory);
    }

    @Override
    protected String getFactoryID(String string) {
        if (KNOWN.equals(string)) {
            return this.factory.getID();
        }
        return string.substring(UNKNOWN.length());
    }

    public static String convertFactoryID(String string) {
        return UNKNOWN + string;
    }

    @Override
    public DockFactory<? extends DockElement, ?, ?> getFactory(String string) {
        if (KNOWN.equals(string)) {
            return this.factory;
        }
        return super.getFactory(string);
    }

    protected DockFactory<? extends DockElement, ?, BackupFactoryData<?>> getBackup(String string) {
        return this.backups.get(string);
    }

    @Override
    public String getIdentifier(DockLayoutComposition dockLayoutComposition) {
        DockLayout<?> dockLayout = dockLayoutComposition.getLayout().getDataLayout();
        if (dockLayout != null && dockLayout.getFactoryID().equals(KNOWN)) {
            PredefinedLayout predefinedLayout = (PredefinedLayout)dockLayout.getData();
            return predefinedLayout.getPredefined();
        }
        return null;
    }

    private class PreloadFactory
    implements DockFactory<DockElement, PerspectiveElement, PredefinedLayout> {
        private PredefinedPerspective perspective;

        public PreloadFactory() {
        }

        public PreloadFactory(PredefinedPerspective predefinedPerspective) {
            this.perspective = predefinedPerspective;
        }

        @Override
        public String getID() {
            return PredefinedDockSituation.KNOWN;
        }

        @Override
        public void estimateLocations(PredefinedLayout predefinedLayout, LocationEstimationMap locationEstimationMap) {
            String string;
            DockFactory<DockElement, ?, ?> dockFactory;
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && (dockFactory = PredefinedDockSituation.this.getFactory(string = dockLayoutInfo.getDataLayout().getFactoryID())) != null) {
                dockFactory.estimateLocations(dockLayoutInfo.getDataLayout().getData(), locationEstimationMap);
            }
        }

        @Override
        public PredefinedLayout getLayout(DockElement dockElement, Map<Dockable, Integer> map) {
            if (PredefinedDockSituation.this.shouldLayout(dockElement)) {
                String string = PredefinedDockSituation.UNKNOWN + PredefinedDockSituation.super.getID(dockElement);
                DockFactory<DockElement, ?, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == null) {
                    throw new IllegalStateException("Missing factory: " + string);
                }
                Object l = dockFactory.getLayout(dockElement, map);
                DockLayout dockLayout = new DockLayout(string, l);
                return new PredefinedLayout((String)PredefinedDockSituation.this.elementToString.get(dockElement), new DockLayoutInfo(dockLayout));
            }
            return new PredefinedLayout((String)PredefinedDockSituation.this.elementToString.get(dockElement), new DockLayoutInfo());
        }

        @Override
        public void setLayout(DockElement dockElement, PredefinedLayout predefinedLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
            String string;
            DockFactory<DockElement, ?, ?> dockFactory;
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(dockElement) && (dockFactory = PredefinedDockSituation.this.getFactory(string = dockLayoutInfo.getDataLayout().getFactoryID())) != null) {
                DockController dockController = dockElement.getController();
                try {
                    if (dockController != null) {
                        dockController.freezeLayout();
                    }
                    dockFactory.setLayout(dockElement, dockLayoutInfo.getDataLayout().getData(), map, placeholderStrategy);
                }
                finally {
                    if (dockController != null) {
                        dockController.meltLayout();
                    }
                }
            }
        }

        @Override
        public void setLayout(DockElement dockElement, PredefinedLayout predefinedLayout, PlaceholderStrategy placeholderStrategy) {
            String string;
            DockFactory<DockElement, ?, ?> dockFactory;
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(dockElement) && (dockFactory = PredefinedDockSituation.this.getFactory(string = dockLayoutInfo.getDataLayout().getFactoryID())) != null) {
                DockController dockController = dockElement.getController();
                try {
                    if (dockController != null) {
                        dockController.freezeLayout();
                    }
                    dockFactory.setLayout(dockElement, dockLayoutInfo.getDataLayout().getData(), placeholderStrategy);
                }
                finally {
                    if (dockController != null) {
                        dockController.meltLayout();
                    }
                }
            }
        }

        @Override
        public DockElement layout(PredefinedLayout predefinedLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
            boolean bl;
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            boolean bl2 = dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl3 = bl = dockLayoutInfo.getKind() == DockLayoutInfo.Data.NULL;
            if (!bl2 && !bl) {
                return null;
            }
            DockElement dockElement = (DockElement)PredefinedDockSituation.this.stringToElement.get(predefinedLayout.getPredefined());
            if (dockElement == null && bl2) {
                String string = dockLayoutInfo.getDataLayout().getFactoryID();
                DockFactory<DockElement, ?, BackupFactoryData<?>> dockFactory = PredefinedDockSituation.this.getBackup(string);
                if (dockFactory != null) {
                    return dockFactory.layout(new BackupFactoryData(predefinedLayout.getPredefined(), dockLayoutInfo.getDataLayout().getData()), map, placeholderStrategy);
                }
                return null;
            }
            this.setLayout(dockElement, predefinedLayout, map, placeholderStrategy);
            return dockElement;
        }

        @Override
        public DockElement layout(PredefinedLayout predefinedLayout, PlaceholderStrategy placeholderStrategy) {
            boolean bl;
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            boolean bl2 = dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl3 = bl = dockLayoutInfo.getKind() == DockLayoutInfo.Data.NULL;
            if (!bl2 && !bl) {
                return null;
            }
            DockElement dockElement = (DockElement)PredefinedDockSituation.this.stringToElement.get(predefinedLayout.getPredefined());
            if (dockElement == null && bl2) {
                if (predefinedLayout.getDelegate() == null) {
                    return null;
                }
                String string = dockLayoutInfo.getDataLayout().getFactoryID();
                DockFactory<DockElement, ?, BackupFactoryData<?>> dockFactory = PredefinedDockSituation.this.getBackup(string);
                if (dockFactory != null) {
                    return dockFactory.layout(new BackupFactoryData(predefinedLayout.getPredefined(), dockLayoutInfo.getDataLayout().getData()), placeholderStrategy);
                }
                return null;
            }
            this.setLayout(dockElement, predefinedLayout, placeholderStrategy);
            return dockElement;
        }

        @Override
        public PerspectiveElement layoutPerspective(PredefinedLayout predefinedLayout, Map<Integer, PerspectiveDockable> map) {
            boolean bl;
            if (this.perspective == null) {
                throw new IllegalStateException("the perspective of this factory is not set, meaning this factory cannot be used handling perspective dependent tasks");
            }
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            boolean bl2 = dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl3 = bl = dockLayoutInfo.getKind() == DockLayoutInfo.Data.NULL;
            if (!bl2 && !bl) {
                return null;
            }
            PerspectiveElement perspectiveElement = this.perspective.get(predefinedLayout.getPredefined());
            if (perspectiveElement == null && bl2) {
                String string = dockLayoutInfo.getDataLayout().getFactoryID();
                DockFactory<DockElement, ?, BackupFactoryData<?>> dockFactory = PredefinedDockSituation.this.getBackup(string);
                if (dockFactory != null) {
                    return dockFactory.layoutPerspective(new BackupFactoryData(predefinedLayout.getPredefined(), dockLayoutInfo.getDataLayout().getData()), map);
                }
                return null;
            }
            this.layoutPerspective(perspectiveElement, predefinedLayout, map);
            return perspectiveElement;
        }

        @Override
        public void layoutPerspective(PerspectiveElement perspectiveElement, PredefinedLayout predefinedLayout, Map<Integer, PerspectiveDockable> map) {
            String string;
            DockFactory<DockElement, ?, ?> dockFactory;
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(perspectiveElement, this.perspective) && (dockFactory = PredefinedDockSituation.this.getFactory(string = dockLayoutInfo.getDataLayout().getFactoryID())) != null) {
                dockFactory.layoutPerspective(perspectiveElement, dockLayoutInfo.getDataLayout().getData(), map);
            }
        }

        @Override
        public PredefinedLayout getPerspectiveLayout(PerspectiveElement perspectiveElement, Map<PerspectiveDockable, Integer> map) {
            DockLayoutInfo dockLayoutInfo;
            String string;
            if (this.perspective == null) {
                throw new IllegalStateException("the perspective of this factory is not set, meaning this factory cannot be used handling perspective dependent tasks");
            }
            if (PredefinedDockSituation.this.shouldLayout(perspectiveElement, this.perspective)) {
                string = PredefinedDockSituation.UNKNOWN + PredefinedDockSituation.super.getID(perspectiveElement);
                DockFactory<DockElement, ?, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == null) {
                    throw new IllegalStateException("Missing factory: " + string);
                }
                Object l = dockFactory.getPerspectiveLayout(perspectiveElement, map);
                DockLayout dockLayout = new DockLayout(string, l);
                dockLayoutInfo = new DockLayoutInfo(dockLayout);
            } else {
                dockLayoutInfo = new DockLayoutInfo();
            }
            string = this.perspective.get(perspectiveElement);
            if (string == null) {
                throw new IllegalStateException("Expected a key for an element, the element should be known to the perspective, otherwise this method would not have been called: '" + perspectiveElement + "'");
            }
            return new PredefinedLayout(string, dockLayoutInfo);
        }

        @Override
        public void write(PredefinedLayout predefinedLayout, DataOutputStream dataOutputStream) throws IOException {
            Version.write(dataOutputStream, Version.VERSION_1_0_7);
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            dataOutputStream.writeUTF(predefinedLayout.getPredefined());
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.write(dockLayoutInfo.getDataByte());
            } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
                dataOutputStream.writeBoolean(true);
                DockLayout<?> dockLayout = dockLayoutInfo.getDataLayout();
                String string = dockLayout.getFactoryID();
                DockFactory<DockElement, ?, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == null) {
                    throw new IOException("Missing factory: " + string);
                }
                dataOutputStream.writeUTF(string);
                dockFactory.write(dockLayout.getData(), dataOutputStream);
            } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.NULL) {
                dataOutputStream.writeBoolean(false);
            } else {
                throw new IllegalArgumentException("Cannot store information as byte[], it is not present as raw byte[] or in an understandable format");
            }
        }

        @Override
        public PredefinedLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
            Version version = Version.read(dataInputStream);
            version.checkCurrent();
            boolean bl = Version.VERSION_1_0_7.compareTo(version) <= 0;
            String string = dataInputStream.readUTF();
            boolean bl2 = false;
            if (bl) {
                bl2 = !dataInputStream.readBoolean();
            }
            DockLayoutInfo dockLayoutInfo = null;
            if (bl2) {
                dockLayoutInfo = new DockLayoutInfo();
            } else {
                String string2 = dataInputStream.readUTF();
                DockFactory<DockElement, ?, ?> dockFactory = PredefinedDockSituation.this.getFactory(string2);
                if (dockFactory == null) {
                    DockFactory<DockElement, ?, BackupFactoryData<?>> dockFactory2 = PredefinedDockSituation.this.getBackup(string2);
                    if (dockFactory2 != null) {
                        BackupFactoryData backupFactoryData = (BackupFactoryData)dockFactory2.read(dataInputStream, placeholderStrategy);
                        if (backupFactoryData != null && backupFactoryData.getData() != null) {
                            dockLayoutInfo = new DockLayoutInfo(new DockLayout(string2, backupFactoryData.getData()));
                        }
                    } else {
                        int n;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        dataOutputStream.writeUTF(string2);
                        while ((n = dataInputStream.read()) != -1) {
                            dataOutputStream.write(n);
                        }
                        dataOutputStream.close();
                        dockLayoutInfo = new DockLayoutInfo(byteArrayOutputStream.toByteArray());
                    }
                } else {
                    Object l = dockFactory.read(dataInputStream, placeholderStrategy);
                    if (l != null) {
                        dockLayoutInfo = new DockLayoutInfo(new DockLayout(string2, l));
                    }
                }
            }
            if (dockLayoutInfo == null) {
                return null;
            }
            return new PredefinedLayout(string, dockLayoutInfo);
        }

        @Override
        public void write(PredefinedLayout predefinedLayout, XElement xElement) {
            xElement.addElement("replacement").addString("id", predefinedLayout.getPredefined());
            DockLayoutInfo dockLayoutInfo = predefinedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
                xElement.addElement(dockLayoutInfo.getDataXML());
            } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
                DockLayout<?> dockLayout = predefinedLayout.getDelegate().getDataLayout();
                String string = dockLayout.getFactoryID();
                DockFactory<DockElement, ?, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == null) {
                    throw new XException("Missing factory: " + string);
                }
                XElement xElement2 = xElement.addElement("delegate");
                xElement2.addString("id", string);
                dockFactory.write(dockLayout.getData(), xElement2);
            } else if (dockLayoutInfo.getKind() != DockLayoutInfo.Data.NULL) {
                throw new IllegalArgumentException("Cannot store information as xml, it is neither present as raw xml nor in an understandable format");
            }
        }

        @Override
        public PredefinedLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
            DockFactory<DockElement, ?, BackupFactoryData<?>> dockFactory;
            String string = xElement.getElement("replacement").getString("id");
            XElement xElement2 = xElement.getElement("delegate");
            if (xElement2 == null) {
                return new PredefinedLayout(string, new DockLayoutInfo());
            }
            String string2 = xElement2.getString("id");
            Object l = null;
            DockFactory<DockElement, ?, ?> dockFactory2 = PredefinedDockSituation.this.getFactory(string2);
            if (dockFactory2 == null) {
                BackupFactoryData backupFactoryData;
                dockFactory = PredefinedDockSituation.this.getBackup(string2);
                if (dockFactory != null && (backupFactoryData = (BackupFactoryData)dockFactory.read(xElement2, placeholderStrategy)) != null) {
                    l = backupFactoryData.getData();
                }
            } else {
                l = dockFactory2.read(xElement2, placeholderStrategy);
            }
            if (l == null) {
                return new PredefinedLayout(string, new DockLayoutInfo(xElement2));
            }
            dockFactory = new DockLayout<Object>(string2, l);
            return new PredefinedLayout(string, new DockLayoutInfo((DockLayout<?>)((Object)dockFactory)));
        }
    }
}

