/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.dockable.DefaultDockableFactory;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DefaultLocationEstimationMap;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.Perspective;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DockSituation {
    private Map<String, DockFactory<?, ?, ?>> factories = new HashMap();
    private Map<String, AdjacentDockFactory<?>> adjacent = new HashMap();
    private DockSituationIgnore ignore;
    private PlaceholderStrategy intermediatePlaceholders;
    private PlaceholderStrategy placeholders;

    public DockSituation(DockFactory<?, ?, ?> ... dockFactoryArray) {
        DockFactory<?, ?, ?>[] dockFactoryArray2 = dockFactoryArray;
        int n = dockFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFactory<?, ?, ?> dockFactory = dockFactoryArray2[n2];
            this.factories.put(this.getID(dockFactory), dockFactory);
            ++n2;
        }
    }

    public DockSituation(DockController dockController) {
        this(new DefaultDockableFactory(), new SplitDockStationFactory(), new StackDockStationFactory(), new FlapDockStationFactory());
    }

    public Perspective createPerspective() {
        return new Perspective(this){

            @Override
            protected String getID(PerspectiveElement perspectiveElement) {
                return DockSituation.this.getID(perspectiveElement);
            }

            @Override
            protected DockFactory<?, ?, ?> getFactory(String string) {
                return DockSituation.this.getFactory(string);
            }
        };
    }

    public void setIgnore(DockSituationIgnore dockSituationIgnore) {
        this.ignore = dockSituationIgnore;
    }

    public DockSituationIgnore getIgnore() {
        return this.ignore;
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholders = placeholderStrategy;
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholders;
    }

    public void setIntermediatePlaceholders(PlaceholderStrategy placeholderStrategy) {
        this.intermediatePlaceholders = placeholderStrategy;
    }

    public PlaceholderStrategy getIntermediatePlaceholders() {
        return this.intermediatePlaceholders;
    }

    protected Path getPlaceholder(DockElement dockElement) {
        if (this.placeholders == null) {
            return null;
        }
        Dockable dockable = dockElement.asDockable();
        if (dockable == null) {
            return null;
        }
        return this.placeholders.getPlaceholderFor(dockable);
    }

    public void add(DockFactory<?, ?, ?> dockFactory) {
        this.factories.put(this.getID(dockFactory), dockFactory);
    }

    public void addAdjacent(AdjacentDockFactory<?> adjacentDockFactory) {
        this.adjacent.put(this.getAdjacentID(adjacentDockFactory), adjacentDockFactory);
    }

    public DockLayoutComposition convert(DockElement dockElement) {
        AdjacentDockFactory<?> adjacentDockFactory2;
        if (this.ignoreElement(dockElement)) {
            return null;
        }
        String string = this.getID(dockElement);
        DockFactory<DockElement, ?, ?> dockFactory = this.getFactory(string);
        if (dockFactory == null) {
            throw new IllegalArgumentException("Unknown factory-id: " + dockElement.getFactoryID());
        }
        DockStation dockStation = dockElement.asDockStation();
        HashMap<Dockable, Integer> hashMap = new HashMap<Dockable, Integer>();
        ArrayList<DockLayoutComposition> arrayList = new ArrayList<DockLayoutComposition>();
        boolean bl = false;
        if (dockStation != null && !(bl = this.ignoreChildren(dockStation))) {
            int n = 0;
            int n2 = 0;
            int n3 = dockStation.getDockableCount();
            while (n2 < n3) {
                adjacentDockFactory2 = dockStation.getDockable(n2);
                DockLayoutComposition dockLayoutComposition = this.convert((DockElement)((Object)adjacentDockFactory2));
                if (dockLayoutComposition != null) {
                    arrayList.add(dockLayoutComposition);
                    hashMap.put((Dockable)((Object)adjacentDockFactory2), n++);
                }
                ++n2;
            }
        }
        Object l = dockFactory.getLayout(dockElement, hashMap);
        DockLayout dockLayout = new DockLayout(string, l);
        ArrayList arrayList2 = null;
        for (AdjacentDockFactory<?> adjacentDockFactory2 : this.adjacent.values()) {
            if (!adjacentDockFactory2.interested(dockElement)) continue;
            Object l2 = adjacentDockFactory2.getLayout(dockElement, hashMap);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
            }
            arrayList2.add(new DockLayout(this.getAdjacentID(adjacentDockFactory2), l2));
        }
        adjacentDockFactory2 = new DockLayoutInfo(dockLayout);
        ((DockLayoutInfo)((Object)adjacentDockFactory2)).setPlaceholder(this.getPlaceholder(dockElement));
        return new DockLayoutComposition((DockLayoutInfo)((Object)adjacentDockFactory2), arrayList2, arrayList, bl);
    }

    /*
     * WARNING - void declaration
     */
    public DockElement convert(DockLayoutComposition dockLayoutComposition) {
        List<DockLayout<?>> list;
        AdjacentDockFactory<?> adjacentDockFactory;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo == null) {
            return null;
        }
        DockLayout<?> dockLayout = dockLayoutInfo.getDataLayout();
        if (dockLayout == null) {
            return null;
        }
        DockFactory<DockElement, ?, ?> dockFactory = this.getFactory(dockLayout.getFactoryID());
        if (dockFactory == null) {
            return null;
        }
        DockElement dockElement = null;
        HashMap<Integer, Dockable> hashMap = null;
        if (dockLayoutComposition.isIgnoreChildren()) {
            for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
                this.convert(dockLayoutComposition2);
            }
            dockElement = dockFactory.layout(dockLayout.getData(), this.placeholders);
        } else {
            hashMap = new HashMap<Integer, Dockable>();
            boolean bl = false;
            for (DockLayoutComposition dockLayoutComposition3 : dockLayoutComposition.getChildren()) {
                void var7_14;
                Dockable dockable;
                adjacentDockFactory = this.convert(dockLayoutComposition3);
                if (adjacentDockFactory != null && (dockable = adjacentDockFactory.asDockable()) != null) {
                    hashMap.put((int)var7_14, dockable);
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                }
                ++var7_14;
            }
            dockElement = dockFactory.layout(dockLayout.getData(), hashMap, this.placeholders);
        }
        if (dockElement != null && (list = dockLayoutComposition.getAdjacent()) != null) {
            for (DockLayout dockLayout2 : list) {
                adjacentDockFactory = this.getAdjacentFactory(dockLayout2.getFactoryID());
                if (adjacentDockFactory == null) continue;
                if (hashMap == null) {
                    adjacentDockFactory.setLayout(dockElement, dockLayout2.getData(), this.placeholders);
                    continue;
                }
                adjacentDockFactory.setLayout(dockElement, dockLayout2.getData(), hashMap, this.placeholders);
            }
        }
        return dockElement;
    }

    public void writeComposition(DockLayoutComposition dockLayoutComposition, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        this.writeCompositionStream(dockLayoutComposition, dataOutputStream);
    }

    private void writeCompositionStream(DockLayoutComposition dockLayoutComposition, DataOutputStream dataOutputStream) throws IOException {
        AdjacentDockFactory<?> adjacentDockFactory;
        Object object;
        Object object2;
        DockLayout<?> dockLayout;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        Path path = dockLayoutInfo.getPlaceholder();
        dataOutputStream.writeBoolean(path != null);
        if (path != null) {
            dataOutputStream.writeUTF(path.toString());
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
            dataOutputStream.write(dockLayoutInfo.getDataByte());
        } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            dockLayout = dockLayoutInfo.getDataLayout();
            object2 = this.getFactory(dockLayout.getFactoryID());
            if (object2 == null) {
                throw new IOException("Missing factory: " + dockLayout.getFactoryID());
            }
            dataOutputStream.writeUTF(this.getID((DockFactory<?, ?, ?>)object2));
            object = new ByteArrayOutputStream();
            adjacentDockFactory = new DataOutputStream((OutputStream)object);
            object2.write(dockLayout.getData(), (DataOutputStream)((Object)adjacentDockFactory));
            ((FilterOutputStream)((Object)adjacentDockFactory)).close();
            dataOutputStream.writeInt(((ByteArrayOutputStream)object).size());
            ((ByteArrayOutputStream)object).writeTo(dataOutputStream);
        } else {
            throw new IllegalArgumentException("Cannot store layout in stream: it was never translated and its raw format is not a byte stream");
        }
        dockLayout = dockLayoutComposition.getAdjacent();
        if (dockLayout == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(dockLayout.size());
            object = dockLayout.iterator();
            while (object.hasNext()) {
                object2 = (DockLayout)object.next();
                adjacentDockFactory = this.getAdjacentFactory(((DockLayout)object2).getFactoryID());
                if (adjacentDockFactory == null) {
                    throw new IOException("Missing adjacent factory: " + ((DockLayout)object2).getFactoryID());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
                adjacentDockFactory.write(((DockLayout)object2).getData(), dataOutputStream2);
                dataOutputStream2.close();
                dataOutputStream.writeUTF(this.getAdjacentID(adjacentDockFactory));
                dataOutputStream.writeInt(byteArrayOutputStream.size());
                byteArrayOutputStream.writeTo(dataOutputStream);
            }
        }
        dataOutputStream.writeBoolean(dockLayoutComposition.isIgnoreChildren());
        object2 = dockLayoutComposition.getChildren();
        dataOutputStream.writeInt(object2.size());
        adjacentDockFactory = object2.iterator();
        while (adjacentDockFactory.hasNext()) {
            object = (DockLayoutComposition)adjacentDockFactory.next();
            this.writeCompositionStream((DockLayoutComposition)object, dataOutputStream);
        }
    }

    public DockLayoutComposition readComposition(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        return this.readCompositionStream(dataInputStream, version);
    }

    private DockLayoutComposition readCompositionStream(DataInputStream dataInputStream, Version version) throws IOException {
        int n;
        Object object;
        int n2;
        Path path = null;
        if (dataInputStream.readBoolean()) {
            path = new Path(dataInputStream.readUTF());
        }
        byte[] byArray = this.readBuffer(dataInputStream);
        DockLayoutInfo dockLayoutInfo = this.readEntry(byArray, path);
        ArrayList arrayList = null;
        int n3 = dataInputStream.readInt();
        if (n3 > 0) {
            arrayList = new ArrayList(n3);
            n2 = 0;
            while (n2 < n3) {
                object = dataInputStream.readUTF();
                n = dataInputStream.readInt();
                AdjacentDockFactory<?> adjacentDockFactory = this.getAdjacentFactory((String)object);
                if (adjacentDockFactory == null) {
                    while (n > 0) {
                        int n4 = (int)dataInputStream.skip(n);
                        if (n4 <= 0) {
                            throw new EOFException();
                        }
                        n -= n4;
                    }
                } else {
                    DataInputStream dataInputStream2 = this.readBuffer(dataInputStream, n);
                    Object l = adjacentDockFactory.read(dataInputStream2, this.intermediatePlaceholders);
                    if (l != null) {
                        arrayList.add(new DockLayout((String)object, l));
                    }
                    dataInputStream2.close();
                }
                ++n2;
            }
        }
        n2 = dataInputStream.readBoolean();
        object = new ArrayList();
        n = dataInputStream.readInt();
        int n5 = 0;
        while (n5 < n) {
            object.add(this.readCompositionStream(dataInputStream, version));
            ++n5;
        }
        return new DockLayoutComposition(dockLayoutInfo, arrayList, (List<DockLayoutComposition>)object, n2 != 0);
    }

    private DockLayoutInfo readEntry(byte[] byArray, Path path) throws IOException {
        DockLayoutInfo dockLayoutInfo;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        DockFactory<DockElement, ?, ?> dockFactory = this.getFactory(string);
        if (dockFactory == null) {
            dockLayoutInfo = null;
            if (dockLayoutInfo == null) {
                dockLayoutInfo = new DockLayoutInfo(byArray);
                dockLayoutInfo.setPlaceholder(path);
            }
        } else {
            Object l = dockFactory.read(dataInputStream, this.intermediatePlaceholders);
            if (l == null) {
                dockLayoutInfo = null;
            } else {
                dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, l));
                dockLayoutInfo.setPlaceholder(path);
            }
            dataInputStream.close();
        }
        return dockLayoutInfo;
    }

    private DataInputStream readBuffer(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.read(byArray, n2, n - n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 += n3;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
        return dataInputStream2;
    }

    private byte[] readBuffer(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 4 + 4 + n);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.read();
            if (n3 == -1) {
                throw new EOFException("unexpectetly reached end of file");
            }
            dataOutputStream.write(n3);
            ++n2;
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write(Map<String, DockStation> map) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.write(map, dataOutputStream);
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void write(Map<String, DockStation> map, DataOutputStream dataOutputStream) throws IOException {
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, DockStation> entry : map.entrySet()) {
            DockLayoutComposition dockLayoutComposition = this.convert(entry.getValue());
            if (dockLayoutComposition == null) continue;
            hashMap.put(entry.getKey(), dockLayoutComposition);
        }
        this.writeCompositions(hashMap, dataOutputStream);
    }

    public void writeCompositions(Map<String, DockLayoutComposition> map, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeInt(map.size());
        for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            this.writeComposition(entry.getValue(), dataOutputStream);
        }
    }

    public Map<String, DockStation> read(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        Map<String, DockStation> map = this.read(dataInputStream);
        dataInputStream.close();
        return map;
    }

    public Map<String, DockStation> read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        int n = dataInputStream.readInt();
        HashMap<String, DockStation> hashMap = new HashMap<String, DockStation>();
        int n2 = 0;
        while (n2 < n) {
            DockStation dockStation;
            String string = dataInputStream.readUTF();
            DockLayoutComposition dockLayoutComposition = this.readComposition(dataInputStream);
            DockElement dockElement = dockLayoutComposition == null ? null : this.convert(dockLayoutComposition);
            DockStation dockStation2 = dockStation = dockElement == null ? null : dockElement.asDockStation();
            if (dockStation != null) {
                hashMap.put(string, dockStation);
            }
            ++n2;
        }
        return hashMap;
    }

    public Map<String, DockLayoutComposition> readCompositions(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        int n = dataInputStream.readInt();
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            DockLayoutComposition dockLayoutComposition = this.readComposition(dataInputStream);
            if (dockLayoutComposition != null) {
                hashMap.put(string, dockLayoutComposition);
            }
            ++n2;
        }
        return hashMap;
    }

    public void writeCompositionXML(DockLayoutComposition dockLayoutComposition, XElement xElement) {
        AdjacentDockFactory<?> adjacentDockFactory;
        Object object;
        DockFactory<? extends DockElement, ?, ?> dockFactory;
        DockLayout<?> dockLayout;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
            xElement.addElement(dockLayoutInfo.getDataXML());
        } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            dockLayout = dockLayoutInfo.getDataLayout();
            dockFactory = this.getFactory(dockLayout.getFactoryID());
            if (dockFactory == null) {
                throw new IllegalArgumentException("Missing factory: " + dockLayout.getFactoryID());
            }
            XElement object22 = xElement.addElement("layout");
            object22.addString("factory", this.getID(dockFactory));
            object = dockLayoutInfo.getPlaceholder();
            if (object != null) {
                object22.addString("placeholder", ((Path)object).toString());
            }
            dockFactory.write(dockLayout.getData(), object22);
        } else {
            throw new IllegalArgumentException("Cannot store layout as XML: it was never translated and its raw format is not XML");
        }
        dockLayout = dockLayoutComposition.getAdjacent();
        if (dockLayout != null) {
            dockFactory = xElement.addElement("adjacent");
            object = dockLayout.iterator();
            while (object.hasNext()) {
                DockLayout dockLayout2 = (DockLayout)object.next();
                adjacentDockFactory = this.getAdjacentFactory(dockLayout2.getFactoryID());
                if (adjacentDockFactory == null) {
                    throw new IllegalArgumentException("Missing adjacent factory: " + dockLayout2.getFactoryID());
                }
                XElement xElement2 = ((XElement)((Object)dockFactory)).addElement("layout");
                xElement2.addString("factory", this.getAdjacentID(adjacentDockFactory));
                adjacentDockFactory.write(dockLayout2.getData(), xElement2);
            }
        }
        dockFactory = xElement.addElement("children");
        ((XElement)((Object)dockFactory)).addBoolean("ignore", dockLayoutComposition.isIgnoreChildren());
        for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
            adjacentDockFactory = ((XElement)((Object)dockFactory)).addElement("child");
            this.writeCompositionXML(dockLayoutComposition2, (XElement)((Object)adjacentDockFactory));
        }
    }

    public DockLayoutComposition readCompositionXML(XElement xElement) {
        Object object;
        XElement xElement2;
        int n;
        Object object2;
        XElement xElement3 = xElement.getElement("layout");
        DockLayoutInfo dockLayoutInfo = this.readEntry(xElement3);
        XElement xElement4 = xElement.getElement("adjacent");
        ArrayList arrayList = null;
        if (xElement4 != null) {
            arrayList = new ArrayList();
            object2 = xElement4.getElements("layout");
            int n2 = ((XElement[])object2).length;
            n = 0;
            while (n < n2) {
                xElement2 = object2[n];
                String string = xElement2.getString("factory");
                AdjacentDockFactory<?> adjacentDockFactory = this.getAdjacentFactory(string);
                if (adjacentDockFactory != null && (object = adjacentDockFactory.read(xElement2, this.intermediatePlaceholders)) != null) {
                    arrayList.add(new DockLayout<XElement[]>(string, (XElement[])object));
                }
                ++n;
            }
        }
        xElement2 = xElement.getElement("children");
        n = 1;
        ArrayList<DockLayoutComposition> arrayList2 = new ArrayList<DockLayoutComposition>();
        if (xElement2 != null) {
            n = xElement2.getBoolean("ignore");
            object = xElement2.getElements("child");
            int n3 = ((XElement[])object).length;
            int n4 = 0;
            while (n4 < n3) {
                object2 = object[n4];
                arrayList2.add(this.readCompositionXML((XElement)object2));
                ++n4;
            }
        }
        return new DockLayoutComposition(dockLayoutInfo, arrayList, arrayList2, n != 0);
    }

    private DockLayoutInfo readEntry(XElement xElement) {
        DockLayoutInfo dockLayoutInfo = null;
        if (xElement != null) {
            DockFactory<DockElement, ?, ?> dockFactory;
            String string = xElement.getString("factory");
            Path path = null;
            XAttribute xAttribute = xElement.getAttribute("placeholder");
            if (xAttribute != null) {
                path = new Path(xAttribute.getString());
            }
            if ((dockFactory = this.getFactory(string)) != null) {
                Object l = dockFactory.read(xElement, this.intermediatePlaceholders);
                if (l != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, l));
                    dockLayoutInfo.setPlaceholder(path);
                }
            } else {
                dockLayoutInfo = null;
                if (dockLayoutInfo == null) {
                    dockLayoutInfo = new DockLayoutInfo(xElement);
                    dockLayoutInfo.setPlaceholder(path);
                }
            }
        }
        return dockLayoutInfo;
    }

    public void writeXML(Map<String, DockStation> map, XElement xElement) {
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, DockStation> entry : map.entrySet()) {
            DockLayoutComposition dockLayoutComposition = this.convert(entry.getValue());
            if (dockLayoutComposition == null) continue;
            hashMap.put(entry.getKey(), dockLayoutComposition);
        }
        this.writeCompositionsXML(hashMap, xElement);
    }

    public void writeCompositionsXML(Map<String, DockLayoutComposition> map, XElement xElement) {
        for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
            XElement xElement2 = xElement.addElement("element");
            xElement2.addString("name", entry.getKey());
            this.writeCompositionXML(entry.getValue(), xElement2);
        }
    }

    public Map<String, DockStation> readXML(XElement xElement) {
        HashMap<String, DockStation> hashMap = new HashMap<String, DockStation>();
        XElement[] xElementArray = xElement.getElements("element");
        int n = xElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStation dockStation;
            XElement xElement2 = xElementArray[n2];
            String string = xElement2.getString("name");
            DockLayoutComposition dockLayoutComposition = this.readCompositionXML(xElement2);
            DockElement dockElement = dockLayoutComposition == null ? null : this.convert(dockLayoutComposition);
            DockStation dockStation2 = dockStation = dockElement == null ? null : dockElement.asDockStation();
            if (dockStation != null) {
                hashMap.put(string, dockStation);
            }
            ++n2;
        }
        return hashMap;
    }

    public Map<String, DockLayoutComposition> readCompositionsXML(XElement xElement) {
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        XElement[] xElementArray = xElement.getElements("element");
        int n = xElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            XElement xElement2 = xElementArray[n2];
            String string = xElement2.getString("name");
            DockLayoutComposition dockLayoutComposition = this.readCompositionXML(xElement2);
            if (dockLayoutComposition != null) {
                hashMap.put(string, dockLayoutComposition);
            }
            ++n2;
        }
        return hashMap;
    }

    public DockLayoutComposition fillMissing(DockLayoutComposition dockLayoutComposition) throws IOException, XException {
        ArrayList<DockLayoutComposition> arrayList;
        DockLayoutInfo dockLayoutInfo;
        DockLayoutInfo dockLayoutInfo2 = dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
            if ((dockLayoutInfo = this.readEntry(dockLayoutInfo.getDataByte(), dockLayoutInfo.getPlaceholder())) != null && dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
                dockLayoutInfo = dockLayoutInfo2;
            }
        } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML && (dockLayoutInfo = this.readEntry(dockLayoutInfo.getDataXML())) != null && dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
            dockLayoutInfo = dockLayoutInfo2;
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            dockLayoutInfo = this.fillMissing(dockLayoutInfo);
        }
        boolean bl = dockLayoutInfo != dockLayoutInfo2;
        List<DockLayoutComposition> list = dockLayoutComposition.getChildren();
        if (list != null) {
            arrayList = new ArrayList<DockLayoutComposition>(list.size());
            for (DockLayoutComposition dockLayoutComposition2 : list) {
                DockLayoutComposition dockLayoutComposition3 = this.fillMissing(dockLayoutComposition2);
                arrayList.add(dockLayoutComposition3);
                if (dockLayoutComposition2 == dockLayoutComposition3) continue;
                bl = true;
            }
        } else {
            arrayList = null;
        }
        if (dockLayoutInfo != null && dockLayoutInfo != dockLayoutInfo2) {
            dockLayoutInfo.setLocation(dockLayoutInfo2.getLocation());
        }
        if (bl) {
            return new DockLayoutComposition(dockLayoutInfo, dockLayoutComposition.getAdjacent(), arrayList, dockLayoutComposition.isIgnoreChildren());
        }
        return dockLayoutComposition;
    }

    protected DockLayoutInfo fillMissing(DockLayoutInfo dockLayoutInfo) {
        return dockLayoutInfo;
    }

    public void estimateLocations(DockLayoutComposition dockLayoutComposition) {
        this.estimateLocations(dockLayoutComposition, dockLayoutComposition.getLayout().getLocation());
    }

    public void estimateLocations(DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty) {
        DefaultLocationEstimationMap defaultLocationEstimationMap = new DefaultLocationEstimationMap(dockLayoutComposition);
        this.estimateLocations(defaultLocationEstimationMap);
        if (dockableProperty != null) {
            this.appendFirstOnEstimate(dockLayoutComposition, dockableProperty);
        }
    }

    private void appendFirstOnEstimate(DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty) {
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        DockableProperty dockableProperty2 = dockLayoutInfo.getLocation();
        if (dockableProperty2 != null) {
            dockLayoutInfo.setLocation(DockUtilities.append(dockableProperty2, dockableProperty));
        }
        for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
            this.appendFirstOnEstimate(dockLayoutComposition2, dockableProperty);
        }
    }

    protected void estimateLocations(DefaultLocationEstimationMap defaultLocationEstimationMap) {
        DockLayoutComposition dockLayoutComposition = defaultLocationEstimationMap.getRoot();
        List<DockLayoutComposition> list = dockLayoutComposition.getChildren();
        if (list == null || list.size() == 0) {
            return;
        }
        DockLayout<?> dockLayout = dockLayoutComposition.getLayout().getDataLayout();
        if (dockLayout == null) {
            return;
        }
        DockFactory<DockElement, ?, ?> dockFactory = this.getFactory(dockLayout.getFactoryID());
        if (dockFactory == null) {
            return;
        }
        int n = 0;
        int n2 = defaultLocationEstimationMap.getChildCount();
        while (n < n2) {
            this.estimateLocations(defaultLocationEstimationMap.subMap(n));
            ++n;
        }
        defaultLocationEstimationMap.prepare();
        dockFactory.estimateLocations(dockLayout.getData(), defaultLocationEstimationMap);
        defaultLocationEstimationMap.finish();
    }

    protected boolean ignoreElement(DockElement dockElement) {
        if (this.ignore == null) {
            return false;
        }
        return this.ignore.ignoreElement(dockElement);
    }

    protected boolean ignoreChildren(DockStation dockStation) {
        if (this.ignore == null) {
            return false;
        }
        return this.ignore.ignoreChildren(dockStation);
    }

    protected String getID(PerspectiveElement perspectiveElement) {
        return perspectiveElement.getFactoryID();
    }

    protected String getID(DockElement dockElement) {
        return dockElement.getFactoryID();
    }

    protected String getID(DockFactory<?, ?, ?> dockFactory) {
        return dockFactory.getID();
    }

    protected String getFactoryID(DockLayoutInfo dockLayoutInfo) {
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(dockLayoutInfo.getDataByte()));
                String string = dataInputStream.readUTF();
                dataInputStream.close();
                return string;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("byte entry not in the correct format", iOException);
            }
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
            return dockLayoutInfo.getDataXML().getString("factory");
        }
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            return dockLayoutInfo.getDataLayout().getFactoryID();
        }
        return null;
    }

    public String convertFactoryId(DockFactory<?, ?, ?> dockFactory) {
        return this.getID(dockFactory);
    }

    public String convertFactoryId(String string) {
        return this.getFactoryID(string);
    }

    protected String getFactoryID(String string) {
        return string;
    }

    protected String getAdjacentID(AdjacentDockFactory<?> adjacentDockFactory) {
        return adjacentDockFactory.getID();
    }

    protected String getAdjacentFactoryID(String string) {
        return string;
    }

    public DockFactory<? extends DockElement, ?, ?> getFactory(String string) {
        DockFactory<?, ?, ?> dockFactory = this.factories.get(string);
        if (dockFactory == null) {
            String string2 = null;
            if (string.startsWith("delegate_secure ")) {
                string2 = string.substring("delegate_secure ".length());
                string = "delegate_" + string2;
            } else if (string.startsWith("secure ")) {
                string = string2 = string.substring("secure ".length());
            }
            if ("flap dock".equals(string2) || "StackDockStationFactory".equals(string2) || "SplitDockStationFactory".equals(string2)) {
                dockFactory = this.factories.get(string);
            }
        }
        return dockFactory;
    }

    public AdjacentDockFactory<?> getAdjacentFactory(String string) {
        return this.adjacent.get(string);
    }

    public Map<String, AdjacentDockFactory<?>> getAdjacentFactorys() {
        return Collections.unmodifiableMap(this.adjacent);
    }

    public String getIdentifier(DockLayoutComposition dockLayoutComposition) {
        return null;
    }
}

