/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.VetoableDockFrontendEvent;
import bibliothek.gui.dock.event.VetoableDockFrontendListener;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VetoManager {
    private DockFrontend frontend;
    private Set<Dockable> expectedToShow = new HashSet<Dockable>();
    private Set<Dockable> expectedToHide = new HashSet<Dockable>();
    private Set<Dockable> dockables = new HashSet<Dockable>();
    private List<VetoableDockFrontendListener> vetoableListeners = new ArrayList<VetoableDockFrontendListener>();

    public VetoManager(DockFrontend dockFrontend) {
        if (dockFrontend == null) {
            throw new IllegalArgumentException("Frontend must not be null");
        }
        this.frontend = dockFrontend;
        dockFrontend.addFrontendListener(new DockFrontendAdapter(){

            @Override
            public void shown(DockFrontend dockFrontend, Dockable dockable) {
                boolean bl = VetoManager.this.expectedToShow.remove(dockable);
                if (VetoManager.this.dockables.add(dockable)) {
                    VetoManager.this.fireShown(dockable, bl);
                }
            }

            @Override
            public void hidden(DockFrontend dockFrontend, Dockable dockable) {
                boolean bl = VetoManager.this.expectedToHide.remove(dockable);
                if (VetoManager.this.dockables.remove(dockable)) {
                    VetoManager.this.fireHidden(dockable, bl);
                }
            }
        });
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public boolean expectToHide(Dockable dockable, boolean bl) {
        return this.expectToHide(DockUtilities.listDockables(dockable, true), bl);
    }

    public boolean expectToHide(Collection<Dockable> collection, boolean bl) {
        boolean bl2 = this.fireAllHiding(collection, bl);
        if (bl2) {
            return false;
        }
        this.expectedToHide.addAll(collection);
        return true;
    }

    public boolean expectToShow(Dockable dockable, boolean bl) {
        return this.expectToShow(DockUtilities.listDockables(dockable, true), bl);
    }

    public boolean expectToShow(Collection<Dockable> collection, boolean bl) {
        boolean bl2 = this.fireAllShowing(collection, bl);
        if (bl2) {
            return false;
        }
        this.expectedToShow.addAll(collection);
        return true;
    }

    public void addVetoableListener(VetoableDockFrontendListener vetoableDockFrontendListener) {
        this.vetoableListeners.add(vetoableDockFrontendListener);
    }

    public void removeVetoableListener(VetoableDockFrontendListener vetoableDockFrontendListener) {
        this.vetoableListeners.remove(vetoableDockFrontendListener);
    }

    protected VetoableDockFrontendListener[] vetoableListeners() {
        return this.vetoableListeners.toArray(new VetoableDockFrontendListener[this.vetoableListeners.size()]);
    }

    protected boolean fireAllHiding(Dockable dockable, boolean bl) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        List<Dockable> list = DockUtilities.listDockables(dockable, true);
        return this.fireAllHiding(list, bl);
    }

    protected boolean fireAllHiding(Collection<Dockable> collection, boolean bl) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        if (collection.isEmpty()) {
            return false;
        }
        VetoableDockFrontendEvent vetoableDockFrontendEvent = new VetoableDockFrontendEvent(this.frontend, bl, true, collection.toArray(new Dockable[collection.size()]));
        VetoableDockFrontendListener[] vetoableDockFrontendListenerArray = this.vetoableListeners();
        int n = vetoableDockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockFrontendListener vetoableDockFrontendListener = vetoableDockFrontendListenerArray[n2];
            vetoableDockFrontendListener.hiding(vetoableDockFrontendEvent);
            ++n2;
        }
        return vetoableDockFrontendEvent.isCanceled();
    }

    protected void fireAllHidden(Collection<Dockable> collection, boolean bl) {
        if (!collection.isEmpty()) {
            VetoableDockFrontendEvent vetoableDockFrontendEvent = new VetoableDockFrontendEvent(this.frontend, false, bl, collection.toArray(new Dockable[collection.size()]));
            VetoableDockFrontendListener[] vetoableDockFrontendListenerArray = this.vetoableListeners();
            int n = vetoableDockFrontendListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                VetoableDockFrontendListener vetoableDockFrontendListener = vetoableDockFrontendListenerArray[n2];
                vetoableDockFrontendListener.hidden(vetoableDockFrontendEvent);
                ++n2;
            }
        }
    }

    protected void fireHidden(Dockable dockable, boolean bl) {
        VetoableDockFrontendEvent vetoableDockFrontendEvent = new VetoableDockFrontendEvent(this.frontend, false, bl, dockable);
        VetoableDockFrontendListener[] vetoableDockFrontendListenerArray = this.vetoableListeners();
        int n = vetoableDockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockFrontendListener vetoableDockFrontendListener = vetoableDockFrontendListenerArray[n2];
            vetoableDockFrontendListener.hidden(vetoableDockFrontendEvent);
            ++n2;
        }
    }

    protected void fireAllHidden(Dockable dockable, boolean bl) {
        this.fireAllHidden(DockUtilities.listDockables(dockable, true), bl);
    }

    protected boolean fireAllShowing(Dockable dockable, boolean bl) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        return this.fireAllShowing(DockUtilities.listDockables(dockable, true), bl);
    }

    protected boolean fireAllShowing(Collection<Dockable> collection, boolean bl) {
        if (this.vetoableListeners.size() == 0) {
            return false;
        }
        if (collection.isEmpty()) {
            return false;
        }
        VetoableDockFrontendEvent vetoableDockFrontendEvent = new VetoableDockFrontendEvent(this.frontend, bl, true, collection.toArray(new Dockable[collection.size()]));
        VetoableDockFrontendListener[] vetoableDockFrontendListenerArray = this.vetoableListeners();
        int n = vetoableDockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockFrontendListener vetoableDockFrontendListener = vetoableDockFrontendListenerArray[n2];
            vetoableDockFrontendListener.showing(vetoableDockFrontendEvent);
            ++n2;
        }
        return vetoableDockFrontendEvent.isCanceled();
    }

    protected void fireAllShown(Dockable dockable, boolean bl) {
        if (this.vetoableListeners.size() == 0) {
            return;
        }
        List<Dockable> list = DockUtilities.listDockables(dockable, true);
        this.fireAllShown(list, bl);
    }

    protected void fireAllShown(Collection<Dockable> collection, boolean bl) {
        if (this.vetoableListeners.size() == 0) {
            return;
        }
        if (!collection.isEmpty()) {
            VetoableDockFrontendEvent vetoableDockFrontendEvent = new VetoableDockFrontendEvent(this.frontend, false, bl, collection.toArray(new Dockable[collection.size()]));
            VetoableDockFrontendListener[] vetoableDockFrontendListenerArray = this.vetoableListeners();
            int n = vetoableDockFrontendListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                VetoableDockFrontendListener vetoableDockFrontendListener = vetoableDockFrontendListenerArray[n2];
                vetoableDockFrontendListener.shown(vetoableDockFrontendEvent);
                ++n2;
            }
        }
    }

    protected void fireShown(Dockable dockable, boolean bl) {
        VetoableDockFrontendEvent vetoableDockFrontendEvent = new VetoableDockFrontendEvent(this.frontend, false, bl, dockable);
        VetoableDockFrontendListener[] vetoableDockFrontendListenerArray = this.vetoableListeners();
        int n = vetoableDockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockFrontendListener vetoableDockFrontendListener = vetoableDockFrontendListenerArray[n2];
            vetoableDockFrontendListener.shown(vetoableDockFrontendEvent);
            ++n2;
        }
    }
}

