/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Setting {
    private Map<String, DockLayoutComposition> roots = new HashMap<String, DockLayoutComposition>();
    private List<Invisible> dockables = new ArrayList<Invisible>();

    public void putRoot(String string, DockLayoutComposition dockLayoutComposition) {
        this.roots.put(string, dockLayoutComposition);
    }

    public DockLayoutComposition getRoot(String string) {
        return this.roots.get(string);
    }

    public String[] getRootKeys() {
        Set<String> set = this.roots.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void addInvisible(String string, String string2, DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty) {
        Invisible invisible = new Invisible();
        invisible.key = string;
        invisible.root = string2;
        invisible.location = dockableProperty;
        invisible.layout = dockLayoutComposition;
        this.dockables.add(invisible);
    }

    public int getInvisibleCount() {
        return this.dockables.size();
    }

    public String getInvisibleKey(int n) {
        return this.dockables.get((int)n).key;
    }

    public String getInvisibleRoot(int n) {
        return this.dockables.get((int)n).root;
    }

    public DockableProperty getInvisibleLocation(int n) {
        return this.dockables.get((int)n).location;
    }

    public DockLayoutComposition getInvisibleLayout(int n) {
        return this.dockables.get((int)n).layout;
    }

    public void fillMissing(DockSituation dockSituation) {
        try {
            for (Map.Entry<String, DockLayoutComposition> entry : this.roots.entrySet()) {
                entry.setValue(dockSituation.fillMissing(entry.getValue()));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        catch (XException xException) {
            throw new IllegalArgumentException(xException);
        }
    }

    public void write(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_7);
        String[] stringArray = this.getRootKeys();
        dataOutputStream.writeInt(stringArray.length);
        Object object = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = object[n2];
            dataOutputStream.writeUTF(string);
            dockSituation.writeComposition(this.getRoot(string), dataOutputStream);
            ++n2;
        }
        dataOutputStream.writeInt(this.getInvisibleCount());
        int n3 = 0;
        n2 = this.getInvisibleCount();
        while (n3 < n2) {
            dataOutputStream.writeUTF(this.getInvisibleKey(n3));
            String string = this.getInvisibleRoot(n3);
            if (string == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeUTF(string);
            }
            object = this.getInvisibleLocation(n3);
            if (object == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                propertyTransformer.write(this.getInvisibleLocation(n3), dataOutputStream);
            }
            DockLayoutComposition dockLayoutComposition = this.getInvisibleLayout(n3);
            if (dockLayoutComposition == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                dockSituation.writeComposition(dockLayoutComposition, dataOutputStream);
            }
            ++n3;
        }
    }

    public void writeXML(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, XElement xElement) {
        Object object;
        Object object2;
        XElement xElement2 = xElement.addElement("roots");
        String[] stringArray = this.getRootKeys();
        Object object3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object3[n2];
            object = xElement2.addElement("root");
            ((XElement)object).addString("name", (String)object2);
            dockSituation.writeCompositionXML(this.getRoot((String)object2), (XElement)object);
            ++n2;
        }
        object2 = xElement.addElement("children");
        n2 = 0;
        n = this.getInvisibleCount();
        while (n2 < n) {
            DockableProperty dockableProperty;
            object3 = ((XElement)object2).addElement("child");
            ((XElement)object3).addString("key", this.getInvisibleKey(n2));
            object = this.getInvisibleRoot(n2);
            if (object != null) {
                ((XElement)object3).addString("root", (String)object);
            }
            if ((dockableProperty = this.getInvisibleLocation(n2)) == null) {
                ((XElement)object3).addBoolean("location", false);
            } else {
                ((XElement)object3).addBoolean("location", true);
                propertyTransformer.writeXML(this.getInvisibleLocation(n2), ((XElement)object3).addElement("location"));
            }
            DockLayoutComposition dockLayoutComposition = this.getInvisibleLayout(n2);
            if (dockLayoutComposition != null) {
                dockSituation.writeCompositionXML(dockLayoutComposition, ((XElement)object3).addElement("layout"));
            }
            ++n2;
        }
    }

    public void read(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, DataInputStream dataInputStream) throws IOException {
        Object object;
        String string;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = Version.VERSION_1_0_7.compareTo(version) <= 0;
        this.roots.clear();
        this.dockables.clear();
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            string = dataInputStream.readUTF();
            object = dockSituation.readComposition(dataInputStream);
            if (object != null) {
                this.putRoot(string, (DockLayoutComposition)object);
            }
            ++n2;
        }
        n = dataInputStream.readInt();
        n2 = 0;
        while (n2 < n) {
            string = dataInputStream.readUTF();
            object = null;
            if (bl2) {
                if (dataInputStream.readBoolean()) {
                    object = dataInputStream.readUTF();
                }
            } else {
                object = dataInputStream.readUTF();
            }
            DockableProperty dockableProperty = null;
            if (bl2) {
                if (dataInputStream.readBoolean()) {
                    dockableProperty = propertyTransformer.read(dataInputStream);
                }
            } else {
                dockableProperty = propertyTransformer.read(dataInputStream);
            }
            DockLayoutComposition dockLayoutComposition = null;
            if (bl2 && dataInputStream.readBoolean()) {
                dockLayoutComposition = dockSituation.readComposition(dataInputStream);
            }
            this.addInvisible(string, (String)object, dockLayoutComposition, dockableProperty);
            ++n2;
        }
    }

    public void readXML(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, XElement xElement) {
        Object object;
        Object object2;
        XElement xElement2;
        int n;
        this.roots.clear();
        this.dockables.clear();
        XElement xElement3 = xElement.getElement("roots");
        if (xElement3 != null) {
            XElement[] xElementArray = xElement3.getElements("root");
            n = xElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                xElement2 = xElementArray[n2];
                object2 = xElement2.getString("name");
                object = dockSituation.readCompositionXML(xElement2);
                if (object != null) {
                    this.putRoot((String)object2, (DockLayoutComposition)object);
                }
                ++n2;
            }
        }
        if ((xElement2 = xElement.getElement("children")) != null) {
            object2 = xElement2.getElements("child");
            int n3 = ((XElement[])object2).length;
            n = 0;
            while (n < n3) {
                XElement xElement4 = object2[n];
                object = xElement4.getString("key");
                String string = null;
                XAttribute xAttribute = xElement4.getAttribute("root");
                if (xAttribute != null) {
                    string = xAttribute.getString();
                }
                boolean bl2 = true;
                boolean bl3 = false;
                XAttribute xAttribute2 = xElement4.getAttribute("location");
                if (xAttribute2 != null) {
                    bl2 = false;
                    bl3 = xAttribute2.getBoolean();
                }
                DockableProperty dockableProperty = null;
                DockLayoutComposition dockLayoutComposition = null;
                if (bl2) {
                    dockableProperty = propertyTransformer.readXML(xElement4);
                } else {
                    XElement xElement5;
                    if (bl3) {
                        xElement5 = xElement4.getElement("location");
                        dockableProperty = propertyTransformer.readXML(xElement5);
                    }
                    if ((xElement5 = xElement4.getElement("layout")) != null) {
                        dockLayoutComposition = dockSituation.readCompositionXML(xElement5);
                    }
                }
                this.addInvisible((String)object, string, dockLayoutComposition, dockableProperty);
                ++n;
            }
        }
    }

    private static class Invisible {
        public String key;
        public String root;
        public DockableProperty location;
        public DockLayoutComposition layout;

        private Invisible() {
        }
    }
}

