/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.BackupFactoryData;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class RegisteringDockFactory<D extends Dockable, P extends PerspectiveElement, L>
implements DockFactory<D, P, BackupFactoryData<L>> {
    private DockFrontend frontend;
    private DockFactory<D, P, L> factory;

    public RegisteringDockFactory(DockFrontend dockFrontend, DockFactory<D, P, L> dockFactory) {
        this.frontend = dockFrontend;
        this.factory = dockFactory;
    }

    @Override
    public String getID() {
        return this.factory.getID();
    }

    @Override
    public void estimateLocations(BackupFactoryData<L> backupFactoryData, LocationEstimationMap locationEstimationMap) {
        this.factory.estimateLocations(backupFactoryData.getData(), locationEstimationMap);
    }

    @Override
    public BackupFactoryData<L> getLayout(D d, Map<Dockable, Integer> map) {
        return new BackupFactoryData(null, this.factory.getLayout(d, map));
    }

    @Override
    public D layout(BackupFactoryData<L> backupFactoryData, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        String string;
        Dockable dockable = (Dockable)this.factory.layout(backupFactoryData.getData(), map, placeholderStrategy);
        if (dockable != null && (string = backupFactoryData.getIdentifier()).startsWith("dockable") && this.frontend.getDockable(string = string.substring("dockable".length())) == null) {
            this.frontend.addDockable(string, dockable);
        }
        return (D)dockable;
    }

    @Override
    public D layout(BackupFactoryData<L> backupFactoryData, PlaceholderStrategy placeholderStrategy) {
        String string;
        Dockable dockable = (Dockable)this.factory.layout(backupFactoryData.getData(), placeholderStrategy);
        if (dockable != null && (string = backupFactoryData.getIdentifier()).startsWith("dockable") && this.frontend.getDockable(string = string.substring("dockable".length())) == null) {
            this.frontend.addDockable(string, dockable);
        }
        return (D)dockable;
    }

    @Override
    public BackupFactoryData<L> read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        return new BackupFactoryData(null, this.factory.read(dataInputStream, placeholderStrategy));
    }

    @Override
    public BackupFactoryData<L> read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        return new BackupFactoryData(null, this.factory.read(xElement, placeholderStrategy));
    }

    @Override
    public void setLayout(D d, BackupFactoryData<L> backupFactoryData, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        this.factory.setLayout(d, backupFactoryData.getData(), map, placeholderStrategy);
    }

    @Override
    public void setLayout(D d, BackupFactoryData<L> backupFactoryData, PlaceholderStrategy placeholderStrategy) {
        this.factory.setLayout(d, backupFactoryData.getData(), placeholderStrategy);
    }

    @Override
    public void write(BackupFactoryData<L> backupFactoryData, DataOutputStream dataOutputStream) throws IOException {
        this.factory.write(backupFactoryData.getData(), dataOutputStream);
    }

    @Override
    public void write(BackupFactoryData<L> backupFactoryData, XElement xElement) {
        this.factory.write(backupFactoryData.getData(), xElement);
    }

    @Override
    public BackupFactoryData<L> getPerspectiveLayout(P p, Map<PerspectiveDockable, Integer> map) {
        return new BackupFactoryData(null, this.factory.getPerspectiveLayout(p, map));
    }

    @Override
    public P layoutPerspective(BackupFactoryData<L> backupFactoryData, Map<Integer, PerspectiveDockable> map) {
        if (backupFactoryData.getData() == null) {
            return null;
        }
        return this.factory.layoutPerspective(backupFactoryData.getData(), map);
    }

    @Override
    public void layoutPerspective(P p, BackupFactoryData<L> backupFactoryData, Map<Integer, PerspectiveDockable> map) {
        if (backupFactoryData.getData() != null) {
            this.factory.layoutPerspective(p, backupFactoryData.getData(), map);
        }
    }
}

