/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.frontend.DefaultDockFrontendPerspective;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.LayoutChangeStrategy;
import bibliothek.gui.dock.frontend.RegisteringDockFactory;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.perspective.PredefinedMap;
import bibliothek.gui.dock.perspective.PredefinedPerspective;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultLayoutChangeStrategy
implements LayoutChangeStrategy {
    private boolean updatingFullLayout = false;

    @Override
    public boolean setLayout(DockFrontendInternals dockFrontendInternals, Setting setting, boolean bl) throws IOException, XException {
        try {
            this.updatingFullLayout = true;
            boolean bl2 = this.updateLayout(dockFrontendInternals, setting, bl);
            return bl2;
        }
        finally {
            this.updatingFullLayout = false;
        }
    }

    @Override
    public boolean shouldUpdateLayoutOnAdd(Dockable dockable) {
        return !this.updatingFullLayout;
    }

    private boolean updateLayout(DockFrontendInternals dockFrontendInternals, Setting setting, boolean bl) throws IOException, XException {
        SettingAccess settingAccess;
        PredefinedDockSituation predefinedDockSituation = this.createSituation(dockFrontendInternals, bl, true);
        DockSituationIgnore dockSituationIgnore = predefinedDockSituation.getIgnore();
        if (dockSituationIgnore == null) {
            dockSituationIgnore = new DockSituationIgnore(){

                @Override
                public boolean ignoreChildren(DockStation dockStation) {
                    return false;
                }

                @Override
                public boolean ignoreElement(DockElement dockElement) {
                    return false;
                }

                @Override
                public boolean ignoreChildren(PerspectiveStation perspectiveStation) {
                    return false;
                }

                @Override
                public boolean ignoreElement(PerspectiveElement perspectiveElement) {
                    return false;
                }
            };
        }
        if (this.approveClosing(dockFrontendInternals, predefinedDockSituation, settingAccess = this.createAccess(dockFrontendInternals, setting)) == null) {
            return false;
        }
        dockFrontendInternals.clean(dockSituationIgnore);
        this.applyLayout(dockFrontendInternals, predefinedDockSituation, settingAccess, bl);
        this.applyInvisibleLayout(dockFrontendInternals, predefinedDockSituation, settingAccess);
        return true;
    }

    protected SettingAccess createAccess(DockFrontendInternals dockFrontendInternals, Setting setting) {
        return new SettingAccess(setting);
    }

    @Override
    public PredefinedDockSituation createSituation(DockFrontendInternals dockFrontendInternals, boolean bl) {
        return this.createSituation(dockFrontendInternals, bl, false);
    }

    protected PredefinedDockSituation createSituation(final DockFrontendInternals dockFrontendInternals, final boolean bl, boolean bl2) {
        Object object;
        PredefinedDockSituation predefinedDockSituation = new PredefinedDockSituation(dockFrontendInternals.getFrontend().getController()){

            @Override
            protected boolean shouldLayout(DockElement dockElement) {
                DockFrontend.DockInfo dockInfo;
                Dockable dockable;
                if (bl && (dockable = dockElement.asDockable()) != null && (dockInfo = dockFrontendInternals.getInfo(dockable)) != null) {
                    return dockInfo.isEntryLayout();
                }
                return true;
            }

            @Override
            protected boolean shouldLayout(PerspectiveElement perspectiveElement, PredefinedPerspective predefinedPerspective) {
                DockFrontend.DockInfo dockInfo;
                String string;
                if (bl && (string = predefinedPerspective.get(perspectiveElement)) != null && (dockInfo = dockFrontendInternals.getInfo(string)) != null) {
                    return dockInfo.isEntryLayout();
                }
                return true;
            }
        };
        Object[] objectArray = dockFrontendInternals.getRoots();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            predefinedDockSituation.put("root" + ((DockFrontend.RootInfo)object).getName(), ((DockFrontend.RootInfo)object).getStation());
            ++n2;
        }
        objectArray = dockFrontendInternals.getDockables();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (((DockFrontend.DockInfo)object).getDockable() != null && this.shouldPredefine(((DockFrontend.DockInfo)object).getDockable())) {
                predefinedDockSituation.put("dockable" + ((DockFrontend.DockInfo)object).getKey(), ((DockFrontend.DockInfo)object).getDockable());
            }
            ++n2;
        }
        objectArray = dockFrontendInternals.getDockFactories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            predefinedDockSituation.add((DockFactory<?, ?, ?>)object);
            ++n2;
        }
        objectArray = dockFrontendInternals.getBackupDockFactories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            predefinedDockSituation.addBackup(new RegisteringDockFactory(dockFrontendInternals.getFrontend(), object));
            ++n2;
        }
        objectArray = dockFrontendInternals.getAdjacentDockFactories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            predefinedDockSituation.addAdjacent((AdjacentDockFactory<?>)object);
            ++n2;
        }
        if (bl) {
            predefinedDockSituation.setIgnore(dockFrontendInternals.getFrontend().getIgnoreForEntry());
        } else {
            predefinedDockSituation.setIgnore(dockFrontendInternals.getFrontend().getIgnoreForFinal());
        }
        return predefinedDockSituation;
    }

    protected boolean shouldPredefine(Dockable dockable) {
        return true;
    }

    @Override
    public DockFrontendPerspective createPerspective(DockFrontendInternals dockFrontendInternals, boolean bl, final FrontendPerspectiveCache frontendPerspectiveCache) {
        PerspectiveElement perspectiveElement;
        Object object;
        PredefinedDockSituation predefinedDockSituation = this.createSituation(dockFrontendInternals, bl);
        PredefinedPerspective predefinedPerspective = predefinedDockSituation.createPerspective();
        Object[] objectArray = dockFrontendInternals.getDockables();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (((DockFrontend.DockInfo)object).getDockable() != null && (perspectiveElement = frontendPerspectiveCache.get(((DockFrontend.DockInfo)object).getKey(), ((DockFrontend.DockInfo)object).getDockable(), false)) != null) {
                predefinedPerspective.put("dockable" + ((DockFrontend.DockInfo)object).getKey(), perspectiveElement);
            }
            ++n2;
        }
        objectArray = dockFrontendInternals.getRoots();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            perspectiveElement = frontendPerspectiveCache.get(((DockFrontend.RootInfo)object).getName(), ((DockFrontend.RootInfo)object).getStation(), true);
            predefinedPerspective.put("root" + ((DockFrontend.RootInfo)object).getName(), perspectiveElement);
            ++n2;
        }
        predefinedPerspective.put(new PredefinedMap(){

            @Override
            public PerspectiveElement get(String string) {
                if (string.startsWith("dockable")) {
                    return frontendPerspectiveCache.get(string.substring("dockable".length()), false);
                }
                if (string.startsWith("root")) {
                    return frontendPerspectiveCache.get(string.substring("root".length()), true);
                }
                return null;
            }

            @Override
            public String get(PerspectiveElement perspectiveElement) {
                String string = frontendPerspectiveCache.get(perspectiveElement);
                if (string == null) {
                    return null;
                }
                if (perspectiveElement.asStation() != null && frontendPerspectiveCache.isRootStation(perspectiveElement.asStation())) {
                    return "root" + string;
                }
                return "dockable" + string;
            }
        });
        return new DefaultDockFrontendPerspective(dockFrontendInternals.getFrontend(), predefinedPerspective, bl);
    }

    @Override
    public PropertyTransformer createTransformer(DockFrontendInternals dockFrontendInternals) {
        PropertyTransformer propertyTransformer = new PropertyTransformer(dockFrontendInternals.getFrontend().getController());
        DockablePropertyFactory[] dockablePropertyFactoryArray = dockFrontendInternals.getPropertyFactories();
        int n = dockablePropertyFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockablePropertyFactory dockablePropertyFactory = dockablePropertyFactoryArray[n2];
            propertyTransformer.addFactory(dockablePropertyFactory);
            ++n2;
        }
        return propertyTransformer;
    }

    protected void applyLayout(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, SettingAccess settingAccess, boolean bl) throws IOException, XException {
        dockFrontendInternals.getFrontend();
        DockFrontend.RootInfo[] rootInfoArray = dockFrontendInternals.getRoots();
        int n = rootInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontend.RootInfo rootInfo = rootInfoArray[n2];
            DockLayoutComposition dockLayoutComposition = settingAccess.getRoot(rootInfo.getName());
            if (dockLayoutComposition != null) {
                Object object;
                Map.Entry<String, DockableProperty> entry22;
                Map<String, DockableProperty> map = this.listEstimateLocations(dockSituation, dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition));
                if (map != null) {
                    for (Map.Entry<String, DockableProperty> entry22 : map.entrySet()) {
                        String string = (String)entry22.getKey();
                        object = dockFrontendInternals.getInfo(string);
                        if (object == null) continue;
                        ((DockFrontend.DockInfo)object).setLocation(rootInfo.getName(), (DockableProperty)entry22.getValue());
                        ((DockFrontend.DockInfo)object).setShown(true);
                    }
                }
                if ((entry22 = this.listLayouts(dockSituation, dockLayoutComposition)) != null) {
                    for (Map.Entry entry : entry22.entrySet()) {
                        object = (String)entry.getKey();
                        DockFrontend.DockInfo dockInfo = dockFrontendInternals.getInfo((String)object);
                        if (dockInfo == null) continue;
                        dockInfo.setShown(true);
                        if (bl && !dockInfo.isEntryLayout()) continue;
                        dockInfo.setLayout((DockLayoutComposition)entry.getValue());
                    }
                }
                dockSituation.convert(dockLayoutComposition);
            }
            ++n2;
        }
    }

    protected void applyInvisibleLayout(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, SettingAccess settingAccess) throws IOException, XException {
        dockFrontendInternals.getFrontend();
        int n = 0;
        int n2 = settingAccess.getInvisibleCount();
        while (n < n2) {
            String string = settingAccess.getInvisibleKey(n);
            DockFrontend.DockInfo dockInfo = dockFrontendInternals.getInfo(string);
            if (dockInfo != null) {
                dockInfo.setShown(false);
                dockInfo.setLocation(settingAccess.getInvisibleRoot(n), settingAccess.getInvisibleLocation(n));
                DockLayoutComposition dockLayoutComposition = settingAccess.getInvisibleLayout(n);
                if (dockLayoutComposition != null) {
                    dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition);
                    if (dockInfo.getDockable() != null) {
                        dockSituation.convert(dockLayoutComposition);
                        dockLayoutComposition = null;
                    }
                    dockInfo.setLayout(dockLayoutComposition);
                }
            }
            ++n;
        }
    }

    protected Map<String, DockLayoutComposition> listLayouts(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            Map<String, DockLayoutComposition> map = ((PredefinedDockSituation)dockSituation).listLayouts(dockLayoutComposition, true);
            HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
            for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string.startsWith("dockable")) {
                    hashMap.put(string.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (string.startsWith("root")) {
                    hashMap.put(string.substring("root".length()), entry.getValue());
                    continue;
                }
                hashMap.put(string, entry.getValue());
            }
            return hashMap;
        }
        return null;
    }

    protected Map<String, DockableProperty> listEstimateLocations(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            Map<String, DockableProperty> map = ((PredefinedDockSituation)dockSituation).listEstimatedLocations(dockLayoutComposition, true);
            HashMap<String, DockableProperty> hashMap = new HashMap<String, DockableProperty>();
            for (Map.Entry<String, DockableProperty> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string.startsWith("dockable")) {
                    hashMap.put(string.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (string.startsWith("root")) {
                    hashMap.put(string.substring("root".length()), entry.getValue());
                    continue;
                }
                hashMap.put(string, entry.getValue());
            }
            return hashMap;
        }
        return null;
    }

    @Override
    public void estimateLocations(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            ((PredefinedDockSituation)dockSituation).estimateLocations(dockLayoutComposition);
        }
    }

    protected Collection<Dockable> approveClosing(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, SettingAccess settingAccess) {
        Collection<Dockable> collection;
        HashSet<Dockable> hashSet = new HashSet<Dockable>();
        DockFrontend.RootInfo[] rootInfoArray = dockFrontendInternals.getRoots();
        int n = rootInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set<Dockable> set;
            collection = rootInfoArray[n2];
            DockLayoutComposition dockLayoutComposition = settingAccess.getRoot(((DockFrontend.RootInfo)((Object)collection)).getName());
            if (dockLayoutComposition != null && (set = this.estimateVisible(dockFrontendInternals, dockSituation, dockLayoutComposition)) != null) {
                hashSet.addAll(set);
            }
            ++n2;
        }
        collection = this.getClosingDockables(dockFrontendInternals, hashSet);
        if (!collection.isEmpty() && !dockFrontendInternals.getVetos().expectToHide(collection, true)) {
            return null;
        }
        return collection;
    }

    protected Collection<Dockable> getClosingDockables(DockFrontendInternals dockFrontendInternals, Set<Dockable> set) {
        ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
        DockFrontend.DockInfo[] dockInfoArray = dockFrontendInternals.getDockables();
        int n = dockInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontend.DockInfo dockInfo = dockInfoArray[n2];
            Dockable dockable = dockInfo.getDockable();
            if (dockable != null && dockInfo.isHideable() && !set.contains(dockable)) {
                arrayList.add(dockInfo.getDockable());
            }
            ++n2;
        }
        return arrayList;
    }

    protected Set<Dockable> estimateVisible(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            Object object;
            HashSet<Dockable> hashSet = new HashSet<Dockable>();
            DockFrontend.DockInfo[] dockInfoArray = dockFrontendInternals.getDockables();
            int n = dockInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = dockInfoArray[n2];
                Dockable dockable = ((DockFrontend.DockInfo)object).getDockable();
                if (dockable != null) {
                    hashSet.add(dockable);
                }
                ++n2;
            }
            object = (PredefinedDockSituation)dockSituation;
            Set<Dockable> set = ((PredefinedDockSituation)object).listVisible(hashSet, dockLayoutComposition);
            return set;
        }
        return null;
    }

    @Override
    public PlaceholderStrategy getPlaceholderStrategy(DockFrontendInternals dockFrontendInternals) {
        return null;
    }

    protected class SettingAccess {
        private Setting setting;

        public SettingAccess(Setting setting) {
            this.setting = setting;
        }

        public Setting getSetting() {
            return this.setting;
        }

        public DockLayoutComposition getRoot(String string) {
            return this.setting.getRoot(string);
        }

        public String[] getRootKeys() {
            return this.setting.getRootKeys();
        }

        public int getInvisibleCount() {
            return this.setting.getInvisibleCount();
        }

        public String getInvisibleKey(int n) {
            return this.setting.getInvisibleKey(n);
        }

        public String getInvisibleRoot(int n) {
            return this.setting.getInvisibleRoot(n);
        }

        public DockableProperty getInvisibleLocation(int n) {
            return this.setting.getInvisibleLocation(n);
        }

        public DockLayoutComposition getInvisibleLayout(int n) {
            return this.setting.getInvisibleLayout(n);
        }

        public void fillMissing(DockSituation dockSituation) {
            this.setting.fillMissing(dockSituation);
        }
    }
}

