/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.frontend.FrontendDockablePerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.flap.FlapDockPerspective;
import bibliothek.gui.dock.station.split.SplitDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import java.util.HashMap;
import java.util.Map;

public class DefaultFrontendPerspectiveCache
implements FrontendPerspectiveCache {
    private Map<PerspectiveElement, String> identifiers = new HashMap<PerspectiveElement, String>();
    private DockFrontend frontend;

    public DefaultFrontendPerspectiveCache(DockFrontend dockFrontend) {
        if (dockFrontend == null) {
            throw new IllegalArgumentException("frontend must not be null");
        }
        this.frontend = dockFrontend;
    }

    @Override
    public PerspectiveElement get(String string, DockElement dockElement, boolean bl) {
        PerspectiveDockable perspectiveDockable = null;
        if (dockElement instanceof StackDockStation) {
            perspectiveDockable = new StackDockPerspective();
        }
        if (dockElement instanceof FlapDockStation) {
            perspectiveDockable = new FlapDockPerspective();
        }
        if (dockElement instanceof SplitDockStation) {
            SplitDockPerspective splitDockPerspective = new SplitDockPerspective();
            splitDockPerspective.setHasFullscreenAction(((SplitDockStation)dockElement).hasFullScreenAction());
            perspectiveDockable = splitDockPerspective;
        }
        if (dockElement instanceof DefaultDockable) {
            perspectiveDockable = new FrontendDockablePerspective(string);
        }
        if (perspectiveDockable == null) {
            throw new IllegalArgumentException("'" + string + "' is of unknown type: " + dockElement);
        }
        if (!dockElement.getFactoryID().equals(perspectiveDockable.getFactoryID())) {
            throw new IllegalArgumentException("the factory configured for 'element' is '" + dockElement.getFactoryID() + "', but expected was '" + perspectiveDockable.getFactoryID() + "'. Clients need to subclass this cache and handle this special case.");
        }
        this.put(perspectiveDockable, string);
        return perspectiveDockable;
    }

    protected void put(PerspectiveElement perspectiveElement, String string) {
        if (perspectiveElement == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.identifiers.put(perspectiveElement, string);
    }

    @Override
    public PerspectiveElement get(String string, boolean bl) {
        return null;
    }

    @Override
    public String get(PerspectiveElement perspectiveElement) {
        if (perspectiveElement instanceof FrontendDockablePerspective) {
            return ((FrontendDockablePerspective)perspectiveElement).getId();
        }
        return this.identifiers.get(perspectiveElement);
    }

    @Override
    public boolean isRootStation(PerspectiveStation perspectiveStation) {
        String string = this.get(perspectiveStation);
        if (string == null) {
            return false;
        }
        return this.frontend.getRoot(string) != null;
    }
}

