/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.perspective.PredefinedPerspective;

public class DefaultDockFrontendPerspective
implements DockFrontendPerspective {
    private DockFrontend frontend;
    private PredefinedPerspective perspective;
    private boolean entry;

    public DefaultDockFrontendPerspective(DockFrontend dockFrontend, PredefinedPerspective predefinedPerspective, boolean bl) {
        if (predefinedPerspective == null) {
            throw new IllegalArgumentException("perspective must not be null");
        }
        this.frontend = dockFrontend;
        this.perspective = predefinedPerspective;
    }

    @Override
    public PropertyTransformer getPropertyTransformer() {
        return this.frontend.createPropertyTransformer();
    }

    @Override
    public PredefinedPerspective getPerspective() {
        return this.perspective;
    }

    @Override
    public PerspectiveStation getRoot(String string) {
        PerspectiveElement perspectiveElement = this.perspective.get("root" + string);
        if (perspectiveElement == null) {
            return null;
        }
        return perspectiveElement.asStation();
    }

    @Override
    public void apply() {
        this.frontend.setSetting(this.createSetting(), this.entry);
    }

    @Override
    public void store(String string) {
        this.frontend.setSetting(string, this.createSetting());
    }

    private Setting createSetting() {
        Setting setting = this.frontend.getSetting(this.entry);
        String[] stringArray = this.frontend.getRootNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            setting.putRoot(string, this.perspective.convert(this.getRoot(string)));
            ++n2;
        }
        return setting;
    }
}

