/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.focus;

import bibliothek.gui.dock.focus.SimplifiedFocusTraversalPolicy;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;

public class DockFocusTraversalPolicy
extends FocusTraversalPolicy {
    private SimplifiedFocusTraversalPolicy policy;
    private boolean circle;
    private boolean recursionComponentBefore = false;
    private boolean recursionComponentAfter = false;
    private boolean recursionDefaultComponent = false;

    public DockFocusTraversalPolicy(SimplifiedFocusTraversalPolicy simplifiedFocusTraversalPolicy, boolean bl) {
        if (simplifiedFocusTraversalPolicy == null) {
            throw new IllegalArgumentException("policy must not be null");
        }
        this.policy = simplifiedFocusTraversalPolicy;
        this.circle = bl;
    }

    protected boolean accept(Component component) {
        return component.isFocusable() && component.isEnabled() && component.isDisplayable() && component.isShowing();
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        if (this.recursionComponentAfter) {
            return this.policy.getAfter(container, component);
        }
        try {
            this.recursionComponentAfter = true;
            Component component2 = this.after(component);
            while (true) {
                Container container2;
                if (component2 == component) {
                    return null;
                }
                if (component2 == null) {
                    return null;
                }
                if (component2 instanceof Container && !(container2 = (Container)component2).isFocusCycleRoot() && container2.isFocusTraversalPolicyProvider()) {
                    Component component3 = this.circle ? container2.getFocusTraversalPolicy().getFirstComponent(container2) : container2.getFocusTraversalPolicy().getDefaultComponent(container2);
                    if (component3 == component2) {
                        Component component4 = component2;
                        return component4;
                    }
                    component2 = component3;
                    continue;
                }
                if (this.accept(component2)) {
                    Component component5 = component2;
                    return component5;
                }
                component2 = this.after(component2);
            }
        }
        finally {
            this.recursionComponentAfter = false;
        }
    }

    protected Component after(Component component) {
        Container container = this.getRootOrProvider(component);
        if (container == null) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy(container);
        if (focusTraversalPolicy == null) {
            return null;
        }
        Component component2 = focusTraversalPolicy.getComponentAfter(container, component);
        if (container.isFocusCycleRoot()) {
            return component2;
        }
        if (focusTraversalPolicy == this) {
            if (component2 == null || this.policy.getFirst(container) == component2) {
                component2 = this.after(container);
            }
        } else if (component2 == null || focusTraversalPolicy.getFirstComponent(container) == component2) {
            component2 = this.after(container);
        }
        if (component2 == component) {
            return null;
        }
        return component2;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        if (this.recursionComponentBefore) {
            return this.policy.getBefore(container, component);
        }
        try {
            this.recursionComponentBefore = true;
            Component component2 = this.before(component);
            while (true) {
                Container container2;
                if (component2 == component) {
                    return null;
                }
                if (component2 == null) {
                    return null;
                }
                if (component2 instanceof Container && !(container2 = (Container)component2).isFocusCycleRoot() && container2.isFocusTraversalPolicyProvider()) {
                    Component component3 = this.circle ? container2.getFocusTraversalPolicy().getLastComponent(container2) : container2.getFocusTraversalPolicy().getDefaultComponent(container2);
                    if (component3 == component2) {
                        Component component4 = component2;
                        return component4;
                    }
                    component2 = component3;
                    continue;
                }
                if (this.accept(component2)) {
                    Component component5 = component2;
                    return component5;
                }
                component2 = this.after(component2);
            }
        }
        finally {
            this.recursionComponentBefore = false;
        }
    }

    protected Component before(Component component) {
        Container container = this.getRootOrProvider(component);
        FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy(container);
        Component component2 = focusTraversalPolicy.getComponentBefore(container, component);
        if (container.isFocusCycleRoot()) {
            return component2;
        }
        if (focusTraversalPolicy == this) {
            if (component2 == null || this.policy.getLast(container) == component2) {
                component2 = this.before(container);
            }
        } else if (component2 == null || focusTraversalPolicy.getLastComponent(container) == component2) {
            component2 = this.before(container);
        }
        if (component2 == component) {
            return null;
        }
        return component2;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        if (this.recursionDefaultComponent) {
            return this.policy.getDefault(container);
        }
        try {
            Component component;
            Container container2;
            this.recursionDefaultComponent = true;
            FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy(container);
            Component component2 = focusTraversalPolicy.getDefaultComponent(container);
            if (component2 == container) {
                Component component3 = component2;
                return component3;
            }
            if (component2 instanceof Container && ((container2 = (Container)component2).isFocusCycleRoot() || container2.isFocusTraversalPolicyProvider()) && (component = this.getDefaultComponent(container2)) != null) {
                Component component4 = component;
                return component4;
            }
            Component component5 = component2;
            return component5;
        }
        finally {
            this.recursionDefaultComponent = false;
        }
    }

    @Override
    public Component getFirstComponent(Container container) {
        Component component;
        Container container2;
        FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy(container);
        Component component2 = focusTraversalPolicy.getDefaultComponent(container);
        if (component2 == container) {
            return component2;
        }
        if (component2 instanceof Container && ((container2 = (Container)component2).isFocusCycleRoot() || container2.isFocusTraversalPolicyProvider()) && (component = this.getFirstComponent(container2)) != null) {
            return component;
        }
        return component2;
    }

    @Override
    public Component getLastComponent(Container container) {
        Component component;
        Container container2;
        FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy(container);
        Component component2 = focusTraversalPolicy.getDefaultComponent(container);
        if (component2 == container) {
            return component2;
        }
        if (component2 instanceof Container && ((container2 = (Container)component2).isFocusCycleRoot() || container2.isFocusTraversalPolicyProvider()) && (component = this.getLastComponent(container2)) != null) {
            return component;
        }
        return component2;
    }

    protected Container getRootOrProvider(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container.isFocusCycleRoot() || container.isFocusTraversalPolicyProvider()) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected FocusTraversalPolicy getFocusTraversalPolicy(Container container) {
        while (container != null) {
            if ((container.isFocusCycleRoot() || container.isFocusTraversalPolicyProvider()) && container.isFocusTraversalPolicySet()) {
                return container.getFocusTraversalPolicy();
            }
            container = container.getParent();
        }
        return null;
    }
}

