/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.focus.DockableSelectionListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class AbstractDockableSelection
extends JPanel
implements DockableSelection {
    private List<DockableSelectionListener> listeners = new ArrayList<DockableSelectionListener>();
    protected final Action UP = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDockableSelection.this.up();
        }
    };
    protected final Action DOWN = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDockableSelection.this.down();
        }
    };
    protected final Action LEFT = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDockableSelection.this.left();
        }
    };
    protected final Action RIGHT = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDockableSelection.this.right();
        }
    };
    protected final Action CANCEL = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDockableSelection.this.cancel();
        }
    };
    protected final Action SELECT = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDockableSelection.this.select();
        }
    };
    private DockController controller;
    private Dockable selection;
    private List<Dockable> dockables = new LinkedList<Dockable>();
    private DockableListener dockableListener = new DockableAdapter(){

        @Override
        public void titleTextChanged(Dockable dockable, String string, String string2) {
            int n = AbstractDockableSelection.this.dockables.indexOf(dockable);
            AbstractDockableSelection.this.titleChanged(n, dockable);
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            int n = AbstractDockableSelection.this.dockables.indexOf(dockable);
            AbstractDockableSelection.this.iconChanged(n, dockable);
        }
    };
    private DockRegisterListener registerListener = new DockRegisterAdapter(){

        @Override
        public void dockableRegistered(DockController dockController, Dockable dockable) {
            if (AbstractDockableSelection.this.selectable(dockable)) {
                AbstractDockableSelection.this.add(dockable);
            }
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            AbstractDockableSelection.this.remove(dockable);
        }
    };

    public AbstractDockableSelection() {
        this.setFocusable(true);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "up");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "down");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "left");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "right");
        inputMap.put(KeyStroke.getKeyStroke(224, 0), "up");
        inputMap.put(KeyStroke.getKeyStroke(225, 0), "down");
        inputMap.put(KeyStroke.getKeyStroke(226, 0), "left");
        inputMap.put(KeyStroke.getKeyStroke(227, 0), "right");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "cancel");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "select");
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "select");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("up", this.UP);
        actionMap.put("down", this.DOWN);
        actionMap.put("left", this.LEFT);
        actionMap.put("right", this.RIGHT);
        actionMap.put("cancel", this.CANCEL);
        actionMap.put("select", this.SELECT);
    }

    @Override
    public void addDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        this.listeners.add(dockableSelectionListener);
    }

    @Override
    public void removeDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        this.listeners.remove(dockableSelectionListener);
    }

    @Override
    public boolean hasChoices(DockController dockController) {
        DockRegister dockRegister = dockController.getRegister();
        int n = 0;
        int n2 = 0;
        int n3 = dockRegister.getDockableCount();
        while (n2 < n3) {
            if (this.selectable(dockRegister.getDockable(n2)) && ++n >= 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void open(DockController dockController) {
        if (this.controller != null) {
            throw new IllegalStateException("selection already open");
        }
        DockRegister dockRegister = dockController.getRegister();
        int n = 0;
        int n2 = dockRegister.getDockableCount();
        while (n < n2) {
            Dockable dockable = dockRegister.getDockable(n);
            if (this.selectable(dockable)) {
                this.add(dockable);
            }
            ++n;
        }
        this.controller = dockController;
        dockRegister.addDockRegisterListener(this.registerListener);
        Dockable dockable = dockController.getFocusedDockable();
        if (dockable != null && !this.selectable(dockable)) {
            dockable = null;
        }
        this.select(dockable);
    }

    private void add(Dockable dockable) {
        this.dockables.add(dockable);
        dockable.addDockableListener(this.dockableListener);
        this.insert(this.dockables.size() - 1, dockable);
    }

    @Override
    public void close() {
        if (this.controller != null) {
            this.controller.getRegister().removeDockRegisterListener(this.registerListener);
            this.controller = null;
        }
        int n = this.dockables.size() - 1;
        while (n >= 0) {
            Dockable dockable = this.dockables.remove(n);
            dockable.removeDockableListener(this.dockableListener);
            this.remove(n, dockable);
            --n;
        }
        this.selection = null;
    }

    private void remove(Dockable dockable) {
        int n = this.dockables.indexOf(dockable);
        if (n >= 0) {
            this.dockables.remove(n);
            dockable.removeDockableListener(this.dockableListener);
            this.remove(n, dockable);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    protected boolean selectable(Dockable dockable) {
        return dockable.asDockStation() == null && dockable.getDockParent() != null;
    }

    protected abstract void up();

    protected abstract void down();

    protected abstract void left();

    protected abstract void right();

    protected abstract void insert(int var1, Dockable var2);

    protected abstract void remove(int var1, Dockable var2);

    protected abstract void titleChanged(int var1, Dockable var2);

    protected abstract void iconChanged(int var1, Dockable var2);

    protected abstract void select(Dockable var1);

    protected void setSelection(Dockable dockable) {
        this.selection = dockable;
        DockableSelectionListener[] dockableSelectionListenerArray = this.listeners.toArray(new DockableSelectionListener[this.listeners.size()]);
        int n = dockableSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableSelectionListener dockableSelectionListener = dockableSelectionListenerArray[n2];
            dockableSelectionListener.considering(dockable);
            ++n2;
        }
    }

    protected void cancel() {
        DockableSelectionListener[] dockableSelectionListenerArray = this.listeners.toArray(new DockableSelectionListener[this.listeners.size()]);
        int n = dockableSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableSelectionListener dockableSelectionListener = dockableSelectionListenerArray[n2];
            dockableSelectionListener.canceled();
            ++n2;
        }
    }

    protected void select() {
        if (this.selection != null) {
            Dockable dockable = this.selection;
            DockableSelectionListener[] dockableSelectionListenerArray = this.listeners.toArray(new DockableSelectionListener[this.listeners.size()]);
            int n = dockableSelectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockableSelectionListener dockableSelectionListener = dockableSelectionListenerArray[n2];
                dockableSelectionListener.selected(dockable);
                ++n2;
            }
        }
    }
}

