/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.facile.station.split.LockedResizeLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.facile.station.split.ResizeRoot;

public abstract class ResizeElement<T> {
    private ResizeRequest request;
    private ResizeElement<T> parent;
    private LockedResizeLayoutManager<T> layout;

    public ResizeElement(ResizeElement<T> resizeElement, LockedResizeLayoutManager<T> lockedResizeLayoutManager) {
        this.parent = resizeElement;
        this.layout = lockedResizeLayoutManager;
    }

    public ResizeElement<T> getParent() {
        return this.parent;
    }

    public LockedResizeLayoutManager<T> getLayout() {
        return this.layout;
    }

    protected abstract ResizeRequest createRequest();

    public ResizeRequest getRequest() {
        return this.request;
    }

    protected abstract ResizeElement<T>[] getChildren();

    public void prepareResize() {
        ResizeElement<T>[] resizeElementArray = this.getChildren();
        if (resizeElementArray != null) {
            ResizeElement<T>[] resizeElementArray2 = resizeElementArray;
            int n = resizeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResizeElement<T> resizeElement = resizeElementArray2[n2];
                resizeElement.prepareResize();
                ++n2;
            }
        }
    }

    public void prepareRequests() {
        ResizeElement<T>[] resizeElementArray = this.getChildren();
        if (resizeElementArray != null) {
            ResizeElement<T>[] resizeElementArray2 = resizeElementArray;
            int n = resizeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResizeElement<T> resizeElement = resizeElementArray2[n2];
                resizeElement.prepareRequests();
                ++n2;
            }
        }
        this.request = this.createRequest();
    }

    public boolean isValid() {
        ResizeElement<T>[] resizeElementArray = this.getChildren();
        if (resizeElementArray != null) {
            ResizeElement<T>[] resizeElementArray2 = resizeElementArray;
            int n = resizeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResizeElement<T> resizeElement = resizeElementArray2[n2];
                if (resizeElement == null) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public abstract void adapt(double var1, double var3);

    public ResizeRoot<T> getResizeRoot() {
        return this.parent.getResizeRoot();
    }
}

