/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.DefaultConflictResolver;
import bibliothek.gui.dock.facile.station.split.DelegatingSplitLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeElement;
import bibliothek.gui.dock.facile.station.split.ResizeLeaf;
import bibliothek.gui.dock.facile.station.split.ResizeNode;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.facile.station.split.ResizeRoot;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import java.awt.Rectangle;

public abstract class LockedResizeLayoutManager<T>
extends DelegatingSplitLayoutManager {
    private ConflictResolver<T> conflictResolver = new DefaultConflictResolver();

    public LockedResizeLayoutManager() {
        this(new DefaultSplitLayoutManager());
    }

    public LockedResizeLayoutManager(SplitLayoutManager splitLayoutManager) {
        super(splitLayoutManager);
    }

    public void setConflictResolver(ConflictResolver<T> conflictResolver) {
        if (conflictResolver == null) {
            throw new IllegalArgumentException("conflictResolver must not be null");
        }
        this.conflictResolver = conflictResolver;
    }

    public ConflictResolver<T> getConflictResolver() {
        return this.conflictResolver;
    }

    @Override
    public void updateBounds(Root root, double d, double d2, double d3, double d4) {
        Rectangle rectangle = root.getCurrentBounds();
        Rectangle rectangle2 = root.getBounds();
        boolean bl = this.isResize(root);
        if (bl) {
            boolean bl2 = bl = rectangle.width > 10 && rectangle.height > 10 && rectangle2.width > 10 && rectangle2.height > 10;
        }
        if (bl) {
            this.updateBoundsLocked(root, d, d2, d3, d4);
        } else if (this.hasTreeChanged(root)) {
            this.updateBoundsLocked(root, d, d2, d3, d4);
        } else {
            super.updateBounds(root, d, d2, d3, d4);
        }
    }

    protected boolean isResize(Root root) {
        Rectangle rectangle;
        Rectangle rectangle2 = root.getCurrentBounds();
        return !rectangle2.equals(rectangle = root.getBounds());
    }

    protected boolean hasTreeChanged(Root root) {
        return root.hasTreeChanged();
    }

    public void updateBoundsLocked(Root root, double d, double d2, double d3, double d4) {
        ResizeElement<T> resizeElement = this.toElement(null, root);
        resizeElement.prepareResize();
        root.updateBounds(d, d2, 1.0, 1.0, d3, d4, false);
        resizeElement.prepareRequests();
        resizeElement.adapt(0.0, 0.0);
        root.updateBounds(d, d2, 1.0, 1.0, d3, d4, true);
    }

    public abstract ResizeRequest getRequest(T var1, Leaf var2);

    public abstract T prepareResize(Leaf var1);

    public ResizeElement<T> toElement(ResizeElement<T> resizeElement, SplitNode splitNode) {
        int n = 0;
        while (n < 5) {
            ResizeElement<T> resizeElement2 = this.asyncToElement(resizeElement, splitNode);
            if (resizeElement2 == null || resizeElement2.isValid()) {
                return resizeElement2;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
            ++n;
        }
        System.err.println("LockedResizeLayoutManager.toElement: Potential race condition detected, converting SplitNode to ResizeElement failed 5 times in a row. The node is ignored.");
        return null;
    }

    protected ResizeElement<T> asyncToElement(ResizeElement<T> resizeElement, SplitNode splitNode) {
        if (splitNode instanceof Root) {
            return new ResizeRoot(this, (Root)splitNode);
        }
        if (splitNode instanceof Node) {
            boolean bl;
            Node node = (Node)splitNode;
            SplitNode splitNode2 = node.getLeft();
            SplitNode splitNode3 = node.getRight();
            boolean bl2 = splitNode2 == null ? false : splitNode2.isVisible();
            boolean bl3 = bl = splitNode3 == null ? false : splitNode3.isVisible();
            if (bl2 && bl) {
                return new ResizeNode<T>(this, resizeElement, (Node)splitNode);
            }
            if (bl2) {
                return this.toElement(resizeElement, splitNode2.getVisible());
            }
            if (bl) {
                return this.toElement(resizeElement, splitNode3.getVisible());
            }
            return null;
        }
        if (splitNode instanceof Leaf) {
            return new ResizeLeaf<T>(this, resizeElement, (Leaf)splitNode);
        }
        return null;
    }
}

