/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.status;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.status.AbstractExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;
import bibliothek.util.Path;

public class DefaultExtendedModeEnablement
extends AbstractExtendedModeEnablement {
    public static final Path EXTENSION = new Path("dock.DefaultExtendedModeEnablement");
    public static final ExtendedModeEnablementFactory FACTORY = new ExtendedModeEnablementFactory(){

        @Override
        public ExtendedModeEnablement create(LocationModeManager<?> locationModeManager) {
            return new DefaultExtendedModeEnablement(locationModeManager);
        }
    };
    private CDockablePropertyListener listener = new CDockableAdapter(){

        @Override
        public void minimizableChanged(CDockable cDockable) {
            DefaultExtendedModeEnablement.this.fire(cDockable.intern(), ExtendedMode.MINIMIZED, DefaultExtendedModeEnablement.this.isAvailable(cDockable.intern(), ExtendedMode.MINIMIZED).isAvailable());
        }

        @Override
        public void maximizableChanged(CDockable cDockable) {
            DefaultExtendedModeEnablement.this.fire(cDockable.intern(), ExtendedMode.MAXIMIZED, DefaultExtendedModeEnablement.this.isAvailable(cDockable.intern(), ExtendedMode.MAXIMIZED).isAvailable());
        }

        @Override
        public void normalizeableChanged(CDockable cDockable) {
            DefaultExtendedModeEnablement.this.fire(cDockable.intern(), ExtendedMode.NORMALIZED, DefaultExtendedModeEnablement.this.isAvailable(cDockable.intern(), ExtendedMode.NORMALIZED).isAvailable());
        }
    };

    public DefaultExtendedModeEnablement(LocationModeManager<?> locationModeManager) {
        super(locationModeManager);
        this.init();
    }

    @Override
    protected void connect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(this.listener);
        }
    }

    @Override
    protected void disconnect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(this.listener);
        }
    }

    @Override
    public ExtendedModeEnablement.Availability isAvailable(Dockable dockable, ExtendedMode extendedMode) {
        ExtendedModeEnablement.Availability availability = this.isModeAvailable(dockable, extendedMode);
        return availability;
    }

    @Override
    public ExtendedModeEnablement.Hidden isHidden(Dockable dockable, ExtendedMode extendedMode) {
        ExtendedModeEnablement.Hidden hidden = ExtendedModeEnablement.Hidden.WEAK_VISIBLE;
        return hidden;
    }

    protected ExtendedModeEnablement.Availability isModeAvailable(Dockable dockable, ExtendedMode extendedMode) {
        int n;
        int n2;
        Object object;
        if (dockable instanceof CommonDockable) {
            object = ((CommonDockable)dockable).getDockable();
            n2 = 0;
            n = 0;
            if (extendedMode == ExtendedMode.MAXIMIZED) {
                n2 = object.isMaximizable();
                n = 1;
            } else if (extendedMode == ExtendedMode.MINIMIZED) {
                n2 = object.isMinimizable() ? 1 : 0;
                n = 1;
            } else if (extendedMode == ExtendedMode.NORMALIZED) {
                n2 = object.isNormalizeable() ? 1 : 0;
                n = 1;
            }
            if (n != 0) {
                if (n2 != 0) {
                    return ExtendedModeEnablement.Availability.WEAK_AVAILABLE;
                }
                return ExtendedModeEnablement.Availability.WEAK_FORBIDDEN;
            }
        }
        if ((object = dockable.asDockStation()) != null) {
            n2 = 0;
            n = object.getDockableCount();
            while (n2 < n) {
                ExtendedModeEnablement.Availability availability = this.isModeAvailable(object.getDockable(n2), extendedMode);
                if (availability != ExtendedModeEnablement.Availability.UNCERTAIN) {
                    return availability;
                }
                ++n2;
            }
        }
        return ExtendedModeEnablement.Availability.UNCERTAIN;
    }
}

