/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.status;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementListener;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExtendedModeEnablement
implements ExtendedModeEnablement {
    private List<ExtendedModeEnablementListener> listeners = new ArrayList<ExtendedModeEnablementListener>();
    private LocationModeManager<?> manager;
    private ModeManagerListener<Location, LocationMode> modeManagerListener = new ModeManagerListener<Location, LocationMode>(){

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable, LocationMode locationMode, LocationMode locationMode2) {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            AbstractExtendedModeEnablement.this.disconnect(dockable);
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            AbstractExtendedModeEnablement.this.connect(dockable);
        }
    };

    public AbstractExtendedModeEnablement(LocationModeManager<?> locationModeManager) {
        this.manager = locationModeManager;
    }

    public LocationModeManager<?> getManager() {
        return this.manager;
    }

    protected void init() {
        this.manager.addModeManagerListener(this.modeManagerListener);
        for (Dockable dockable : this.manager.listDockables()) {
            this.connect(dockable);
        }
    }

    @Override
    public void addListener(ExtendedModeEnablementListener extendedModeEnablementListener) {
        if (extendedModeEnablementListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(extendedModeEnablementListener);
    }

    @Override
    public void removeListener(ExtendedModeEnablementListener extendedModeEnablementListener) {
        this.listeners.remove(extendedModeEnablementListener);
    }

    protected void fire(Dockable dockable, ExtendedMode extendedMode, boolean bl) {
        ExtendedModeEnablementListener[] extendedModeEnablementListenerArray;
        ExtendedModeEnablementListener[] extendedModeEnablementListenerArray2 = extendedModeEnablementListenerArray = this.listeners.toArray(new ExtendedModeEnablementListener[this.listeners.size()]);
        int n = extendedModeEnablementListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExtendedModeEnablementListener extendedModeEnablementListener = extendedModeEnablementListenerArray2[n2];
            extendedModeEnablementListener.availabilityChanged(dockable, extendedMode, bl);
            ++n2;
        }
    }

    @Override
    public void destroy() {
        if (this.manager != null) {
            this.manager.removeModeManagerListener(this.modeManagerListener);
            for (Dockable dockable : this.manager.listDockables()) {
                this.disconnect(dockable);
            }
            this.manager = null;
        }
    }

    protected abstract void connect(Dockable var1);

    protected abstract void disconnect(Dockable var1);
}

