/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.MinimizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.util.DockUtilities;

public class FlapDockStationHandle
implements MinimizedModeArea {
    private String id;
    private FlapDockStation station;

    public FlapDockStationHandle(String string, FlapDockStation flapDockStation) {
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (flapDockStation == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.id = string;
        this.station = flapDockStation;
    }

    @Override
    public boolean autoDefaultArea() {
        return true;
    }

    @Override
    public boolean isLocationRoot() {
        return true;
    }

    @Override
    public void addModeAreaListener(ModeAreaListener modeAreaListener) {
    }

    @Override
    public void removeModeAreaListener(ModeAreaListener modeAreaListener) {
    }

    @Override
    public void setController(DockController dockController) {
    }

    @Override
    public void setMode(LocationMode locationMode) {
    }

    @Override
    public FlapDockStation getStation() {
        return this.station;
    }

    @Override
    public DockableProperty getLocation(Dockable dockable) {
        return DockUtilities.getPropertyChain(this.station, dockable);
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isChild(Dockable dockable) {
        return dockable.getDockParent() == this.station;
    }

    public boolean respectWorkingAreas() {
        return false;
    }

    @Override
    public boolean setLocation(Dockable dockable, DockableProperty dockableProperty, AffectedSet affectedSet) {
        affectedSet.add(dockable);
        if (this.isChild(dockable)) {
            if (dockableProperty != null) {
                this.station.move(dockable, dockableProperty);
            }
            return true;
        }
        boolean bl = DockUtilities.acceptable(this.getStation(), dockable);
        if (!bl) {
            return false;
        }
        if (dockableProperty != null && !this.station.drop(dockable, dockableProperty)) {
            dockableProperty = null;
        }
        if (dockableProperty == null) {
            this.station.drop(dockable);
        }
        return true;
    }
}

