/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class LocationModeAction
extends SimpleButtonAction {
    private LocationMode mode;
    private int count = 0;
    private DockActionIcon iconListener;
    private PropertyValue<KeyStroke> stroke;
    private DockActionText text;
    private DockActionText tooltip;
    private DockController controller;

    public LocationModeAction(DockController dockController, LocationMode locationMode, String string, String string2, String string3, PropertyKey<KeyStroke> propertyKey) {
        if (locationMode == null) {
            throw new NullPointerException("mode is null");
        }
        if (string == null) {
            throw new NullPointerException("iconKey is null");
        }
        if (propertyKey == null) {
            throw new NullPointerException("gotoStroke is null");
        }
        this.mode = locationMode;
        this.stroke = new PropertyValue<KeyStroke>(propertyKey){

            @Override
            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                LocationModeAction.this.setAccelerator(keyStroke2);
            }
        };
        this.iconListener = new DockActionIcon(string, this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                LocationModeAction.this.setIcon(icon2);
            }
        };
        this.text = new DockActionText(string2, this){

            @Override
            protected void changed(String string, String string2) {
                LocationModeAction.this.setText(string2);
            }
        };
        this.tooltip = new DockActionText(string3, this){

            @Override
            protected void changed(String string, String string2) {
                LocationModeAction.this.setTooltip(string2);
            }
        };
        this.setController(dockController);
    }

    @Override
    public void action(Dockable dockable) {
        super.action(dockable);
        LocationModeManager<?> locationModeManager = this.mode.getManager();
        while (dockable != null) {
            if (locationModeManager.isRegistered(dockable)) {
                locationModeManager.apply(dockable, this.mode.getUniqueIdentifier(), false);
                return;
            }
            DockStation dockStation = dockable.asDockStation();
            if (dockStation == null) {
                return;
            }
            dockable = dockStation.getFrontDockable();
        }
    }

    protected void setController(DockController dockController) {
        if (this.count > 0) {
            this.connect(this.controller, dockController);
        }
        this.controller = dockController;
    }

    private void connect(DockController dockController, DockController dockController2) {
        this.stroke.setProperties(dockController2);
        this.iconListener.setController(dockController2);
        this.text.setController(dockController2);
        this.tooltip.setController(dockController2);
    }

    protected DockController getController() {
        return this.controller;
    }

    protected boolean checkTrigger(KeyEvent keyEvent) {
        return true;
    }

    @Override
    protected void bound(Dockable dockable) {
        super.bound(dockable);
        if (this.count == 0) {
            this.connect(null, this.controller);
        }
        ++this.count;
    }

    @Override
    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        --this.count;
        if (this.count == 0) {
            this.connect(this.controller, null);
        }
    }
}

