/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.predefined.CMinimizeAction;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MinimizedModeArea;
import bibliothek.gui.dock.facile.mode.action.MinimizedModeAction;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.NullModeSettingsFactory;
import bibliothek.util.Path;

public class MinimizedMode<M extends MinimizedModeArea>
extends DefaultLocationMode<M> {
    public static final Path IDENTIFIER = new Path("dock.mode.minimized");
    public static final String ICON_IDENTIFIER = "locationmanager.minimize";

    protected MinimizedMode() {
        this.setShouldAutoFocus(false);
    }

    public MinimizedMode(CControl cControl) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new CMinimizeAction(cControl)));
        this.setShouldAutoFocus(false);
    }

    public MinimizedMode(DockController dockController) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new MinimizedModeAction(dockController, this)));
        this.setShouldAutoFocus(false);
    }

    @Override
    public Path getUniqueIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public ExtendedMode getExtendedMode() {
        return ExtendedMode.MINIMIZED;
    }

    @Override
    public boolean isDefaultMode(Dockable dockable) {
        return false;
    }

    @Override
    public ModeSettingFactory<Location> getSettingFactory() {
        return new NullModeSettingsFactory<Location>(this.getUniqueIdentifier());
    }

    @Override
    public void ensureNotHidden(Dockable dockable) {
    }

    @Override
    public void writeSetting(ModeSetting<Location> modeSetting) {
    }

    @Override
    public void readSetting(ModeSetting<Location> modeSetting) {
    }
}

