/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MaximizedModeSetting
implements ModeSetting<Location> {
    public static ModeSettingFactory<Location> FACTORY = new ModeSettingFactory<Location>(){

        @Override
        public ModeSetting<Location> create() {
            return new MaximizedModeSetting();
        }

        @Override
        public Path getModeId() {
            return MaximizedMode.IDENTIFIER;
        }
    };
    private HashMap<String, Path> lastMaximizedMode = new HashMap();
    private HashMap<String, Location> lastMaximizedLocation = new HashMap();

    @Override
    public Path getModeId() {
        return MaximizedMode.IDENTIFIER;
    }

    public void setLastMaximizedLocation(Map<String, Location> map) {
        this.lastMaximizedLocation = new HashMap<String, Location>(map);
    }

    public void setLastMaximizedMode(Map<String, Path> map) {
        this.lastMaximizedMode = new HashMap<String, Path>(map);
    }

    public Map<String, Location> getLastMaximizedLocation() {
        return Collections.unmodifiableMap(this.lastMaximizedLocation);
    }

    public Map<String, Path> getLastMaximizedMode() {
        return Collections.unmodifiableMap(this.lastMaximizedMode);
    }

    @Override
    public <B> void write(DataOutputStream dataOutputStream, ModeSettingsConverter<Location, B> modeSettingsConverter) throws IOException {
        int n;
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        if (this.lastMaximizedMode == null) {
            dataOutputStream.writeInt(0);
        } else {
            n = 0;
            for (Path object : this.lastMaximizedMode.values()) {
                if (object == null) continue;
                ++n;
            }
            dataOutputStream.writeInt(n);
            for (Map.Entry entry : this.lastMaximizedMode.entrySet()) {
                if (entry.getValue() == null) continue;
                dataOutputStream.writeUTF((String)entry.getKey());
                dataOutputStream.writeUTF(((Path)entry.getValue()).toString());
            }
        }
        if (this.lastMaximizedLocation == null) {
            dataOutputStream.writeInt(0);
        } else {
            n = 0;
            for (Location location : this.lastMaximizedLocation.values()) {
                if (location == null) continue;
                ++n;
            }
            dataOutputStream.writeInt(n);
            for (Map.Entry entry : this.lastMaximizedLocation.entrySet()) {
                if (entry.getValue() == null) continue;
                dataOutputStream.writeUTF((String)entry.getKey());
                modeSettingsConverter.writeProperty(modeSettingsConverter.convertToSetting((Location)entry.getValue()), dataOutputStream);
            }
        }
    }

    @Override
    public <B> void read(DataInputStream dataInputStream, ModeSettingsConverter<Location, B> modeSettingsConverter) throws IOException {
        Object object;
        String string;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.lastMaximizedLocation = new HashMap();
        this.lastMaximizedMode = new HashMap();
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            string = dataInputStream.readUTF();
            object = dataInputStream.readUTF();
            this.lastMaximizedMode.put(string, new Path((String)object));
            ++n2;
        }
        n = dataInputStream.readInt();
        n2 = 0;
        while (n2 < n) {
            string = dataInputStream.readUTF();
            object = modeSettingsConverter.convertToWorld(modeSettingsConverter.readProperty(dataInputStream));
            this.lastMaximizedLocation.put(string, (Location)object);
            ++n2;
        }
    }

    @Override
    public <B> void write(XElement xElement, ModeSettingsConverter<Location, B> modeSettingsConverter) {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.lastMaximizedLocation != null) {
            hashSet.addAll(this.lastMaximizedLocation.keySet());
        }
        if (this.lastMaximizedMode != null) {
            hashSet.addAll(this.lastMaximizedMode.keySet());
        }
        if (!hashSet.isEmpty()) {
            XElement xElement2 = xElement.addElement("maximized");
            for (String string : hashSet) {
                Path path = this.lastMaximizedMode.get(string);
                Location location = this.lastMaximizedLocation.get(string);
                if (path == null && location == null) continue;
                XElement xElement3 = xElement2.addElement("item");
                xElement3.addString("id", string);
                if (path != null) {
                    xElement3.addElement("mode").setString(path.toString());
                }
                if (location == null) continue;
                modeSettingsConverter.writePropertyXML(modeSettingsConverter.convertToSetting(location), xElement3.addElement("location"));
            }
        }
    }

    @Override
    public <B> void read(XElement xElement, ModeSettingsConverter<Location, B> modeSettingsConverter) {
        this.lastMaximizedLocation = new HashMap();
        this.lastMaximizedMode = new HashMap();
        XElement xElement2 = xElement.getElement("maximized");
        if (xElement2 != null) {
            XElement[] xElementArray = xElement2.getElements("item");
            int n = xElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                XElement xElement3;
                XElement xElement4 = xElementArray[n2];
                String string = xElement4.getString("id");
                XElement xElement5 = xElement4.getElement("mode");
                if (xElement5 != null) {
                    this.lastMaximizedMode.put(string, new Path(xElement5.getString()));
                }
                if ((xElement3 = xElement4.getElement("location")) != null) {
                    this.lastMaximizedLocation.put(string, modeSettingsConverter.convertToWorld(modeSettingsConverter.readPropertyXML(xElement3)));
                }
                ++n2;
            }
        }
    }
}

