/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.predefined.CMaximizeAction;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.facile.mode.AbstractLocationMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.facile.mode.action.MaximizedModeAction;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.util.Path;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public class MaximizedMode<M extends MaximizedModeArea>
extends AbstractLocationMode<M> {
    public static final Path IDENTIFIER = new Path("dock.mode.maximized");
    public static final String ICON_IDENTIFIER = "locationmanager.maximize";
    private Map<String, Path> lastMaximizedMode = new HashMap<String, Path>();
    private Map<String, Location> lastMaximizedLocation = new HashMap<String, Location>();
    private Listener listener = new Listener();
    private List<KeyHook> hooks = new LinkedList<KeyHook>();
    private PropertyValue<KeyStroke> keyStrokeMaximizeChange = new PropertyValue<KeyStroke>(CControl.KEY_MAXIMIZE_CHANGE){

        @Override
        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
        }
    };

    protected MaximizedMode() {
    }

    public MaximizedMode(CControl cControl) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new CMaximizeAction(cControl)));
    }

    public MaximizedMode(DockController dockController) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new MaximizedModeAction(dockController, this)));
    }

    @Override
    public void setManager(LocationModeManager<?> locationModeManager) {
        for (KeyHook object2 : this.hooks) {
            object2.destroy(false);
        }
        this.hooks.clear();
        LocationModeManager<?> locationModeManager2 = this.getManager();
        this.listener.replaceManager(locationModeManager2, locationModeManager);
        if (locationModeManager == null) {
            this.keyStrokeMaximizeChange.setProperties((DockProperties)null);
        } else {
            this.keyStrokeMaximizeChange.setProperties(locationModeManager.getController());
        }
        super.setManager(locationModeManager);
    }

    @Override
    public Path getUniqueIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public ExtendedMode getExtendedMode() {
        return ExtendedMode.MAXIMIZED;
    }

    @Override
    public boolean runApply(Dockable dockable, Location location, AffectedSet affectedSet) {
        MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockable, location);
        if (maximizedModeArea == null) {
            maximizedModeArea = (MaximizedModeArea)this.getDefaultArea();
        }
        maximizedModeArea.prepareApply(dockable, location, affectedSet);
        return this.maximize(maximizedModeArea, dockable, location, affectedSet);
    }

    @Override
    public Location current(Dockable dockable) {
        MaximizedModeArea maximizedModeArea = (MaximizedModeArea)this.get(dockable);
        if (maximizedModeArea == null) {
            return null;
        }
        DockableProperty dockableProperty = maximizedModeArea.getLocation(dockable);
        return new Location(this.getUniqueIdentifier(), maximizedModeArea.getUniqueId(), dockableProperty, false);
    }

    @Override
    public boolean isCurrentMode(Dockable dockable) {
        for (MaximizedModeArea maximizedModeArea : this) {
            if (!maximizedModeArea.isChild(dockable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultMode(Dockable dockable) {
        return false;
    }

    @Override
    public boolean isRepresenting(DockStation dockStation) {
        if (super.isRepresenting(dockStation)) {
            return true;
        }
        Dockable dockable = dockStation.asDockable();
        if (dockable == null) {
            return false;
        }
        for (MaximizedModeArea maximizedModeArea : this) {
            if (!maximizedModeArea.isChild(dockable)) continue;
            return true;
        }
        return false;
    }

    public LocationMode getUnmaximizedMode(Dockable dockable) {
        while (dockable != null) {
            Object object2;
            for (Object object2 : this) {
                if (!object2.isChild(dockable)) continue;
                return object2.getUnmaximizedMode();
            }
            object2 = dockable.getDockParent();
            Dockable dockable2 = dockable = object2 == null ? null : object2.asDockable();
        }
        return null;
    }

    public void maximize(MaximizedModeArea maximizedModeArea, Dockable dockable, AffectedSet affectedSet) {
        this.maximize(maximizedModeArea, dockable, null, affectedSet);
    }

    public boolean maximize(MaximizedModeArea maximizedModeArea, Dockable dockable, Location location, AffectedSet affectedSet) {
        Dockable dockable2 = this.getMaximizingElement(dockable);
        if (dockable2 != dockable) {
            this.getManager().store(dockable2);
        }
        if (maximizedModeArea == null) {
            maximizedModeArea = this.getMaximizeArea(dockable2);
        }
        if (maximizedModeArea == null) {
            maximizedModeArea = (MaximizedModeArea)this.getDefaultArea();
        }
        String string = this.getManager().getKey(dockable2);
        Mode mode = this.getManager().getCurrentMode(dockable2);
        if (string == null && mode == null) {
            throw new IllegalStateException("an unidentified dockable without location has been found, all dockables except true root-station must have a location, true root-stations can never be used in this method.");
        }
        if (string == null && mode != null) {
            this.lastMaximizedLocation.put(maximizedModeArea.getUniqueId(), (Location)mode.current(dockable2));
            this.lastMaximizedMode.put(maximizedModeArea.getUniqueId(), mode.getUniqueIdentifier());
        } else {
            this.getManager().store(dockable);
        }
        List<Dockable> list = this.getMaximized(maximizedModeArea);
        maximizedModeArea.setMaximized(dockable2, true, location, affectedSet);
        if (string != null || mode != null) {
            Dockable[] dockableArray = maximizedModeArea.getMaximized();
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable3 = dockableArray[n2];
                if (dockable3 != dockable2 && DockUtilities.isAncestor(dockable3, dockable2) && !list.contains(dockable3)) {
                    for (Dockable dockable4 : list) {
                        if (!DockUtilities.isAncestor(dockable3, dockable4)) continue;
                        this.storeLastMaximizedLocation(maximizedModeArea, dockable4);
                        break;
                    }
                }
                ++n2;
            }
        }
        affectedSet.add(dockable2);
        return true;
    }

    private List<Dockable> getMaximized(MaximizedModeArea maximizedModeArea) {
        Dockable[] dockableArray = maximizedModeArea.getMaximized();
        if (dockableArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(dockableArray);
    }

    private void storeLastMaximizedLocation(MaximizedModeArea maximizedModeArea, Dockable dockable) {
        Location location;
        LocationMode locationMode = (LocationMode)this.getManager().getPreviousMode(dockable);
        if (locationMode != null && (location = (Location)this.getManager().getHistory(dockable, locationMode.getUniqueIdentifier())) != null) {
            this.lastMaximizedLocation.put(maximizedModeArea.getUniqueId(), location);
            this.lastMaximizedMode.put(maximizedModeArea.getUniqueId(), locationMode.getUniqueIdentifier());
        }
    }

    public void unmaximize(Dockable dockable, AffectedSet affectedSet) {
        Dockable[] dockableArray;
        final MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockable);
        if (maximizedModeArea != null && maximizedModeArea.getMaximized() != null && (dockableArray = maximizedModeArea.getMaximized()) != null) {
            Dockable[] dockableArray2 = dockableArray;
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable2 = dockableArray2[n2];
                if (DockUtilities.isAncestor(dockable2, dockable)) {
                    affectedSet.add(dockable);
                    final Dockable dockable3 = dockable = dockable2;
                    LocationModeManager<?> locationModeManager = this.getManager();
                    locationModeManager.runTransaction(new AffectingRunnable(){

                        @Override
                        public void run(AffectedSet affectedSet) {
                            maximizedModeArea.setMaximized(dockable3, false, null, affectedSet);
                            String string = maximizedModeArea.getUniqueId();
                            boolean bl = false;
                            if (MaximizedMode.this.lastMaximizedLocation.get(string) != null) {
                                bl = MaximizedMode.this.getManager().apply(dockable3, (Path)MaximizedMode.this.lastMaximizedMode.remove(string), (Location)MaximizedMode.this.lastMaximizedLocation.remove(string), affectedSet);
                            }
                            if (!bl) {
                                MaximizedMode.this.applyOldLocation(dockable3, affectedSet);
                            }
                        }
                    }, true);
                    locationModeManager.store(dockable);
                    return;
                }
                ++n2;
            }
        }
    }

    private void applyOldLocation(Dockable dockable, AffectedSet affectedSet) {
        LocationModeManager<?> locationModeManager = this.getManager();
        if (locationModeManager.isRegistered(dockable)) {
            LocationMode locationMode = (LocationMode)locationModeManager.getPreviousMode(dockable);
            if (locationMode == null || locationMode == this) {
                locationMode = (LocationMode)locationModeManager.getMode(NormalMode.IDENTIFIER);
            }
            locationModeManager.apply(dockable, locationMode.getUniqueIdentifier(), affectedSet, true);
        } else if (dockable.asDockStation() != null) {
            DockStation dockStation = dockable.asDockStation();
            Dockable[] dockableArray = new Dockable[dockStation.getDockableCount()];
            int n = 0;
            while (n < dockableArray.length) {
                dockableArray[n] = dockStation.getDockable(n);
                ++n;
            }
            Dockable[] dockableArray2 = dockableArray;
            int n2 = dockableArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Dockable dockable2 = dockableArray2[n3];
                this.applyOldLocation(dockable2, affectedSet);
                ++n3;
            }
        }
    }

    public MaximizedModeArea getNextMaximizeArea(DockStation dockStation) {
        while (dockStation != null) {
            MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockStation);
            if (maximizedModeArea != null) {
                return maximizedModeArea;
            }
            Dockable dockable = dockStation.asDockable();
            if (dockable == null) {
                return null;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    public void unmaximize(DockStation dockStation, AffectedSet affectedSet) {
        Dockable[] dockableArray;
        MaximizedModeArea maximizedModeArea = this.getNextMaximizeArea(dockStation);
        if (maximizedModeArea != null && (dockableArray = maximizedModeArea.getMaximized()) != null) {
            Dockable[] dockableArray2 = dockableArray;
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable = dockableArray2[n2];
                this.unmaximize(dockable, affectedSet);
                ++n2;
            }
        }
    }

    public void unmaximize(MaximizedModeArea maximizedModeArea, AffectedSet affectedSet) {
        Dockable[] dockableArray = maximizedModeArea.getMaximized();
        if (dockableArray != null) {
            Dockable[] dockableArray2 = dockableArray;
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable = dockableArray2[n2];
                this.unmaximize(dockable, affectedSet);
                ++n2;
            }
        }
    }

    @Override
    public void ensureNotHidden(final Dockable dockable) {
        this.getManager().runTransaction(new AffectingRunnable(){

            @Override
            public void run(AffectedSet affectedSet) {
                Dockable dockable4 = dockable;
                DockStation dockStation = dockable4.getDockParent();
                Dockable dockable2 = MaximizedMode.this.getMaximizingElement(dockable4);
                while (dockStation != null) {
                    Dockable[] dockableArray;
                    MaximizedModeArea maximizedModeArea = MaximizedMode.this.getMaximizeArea(dockStation);
                    if (maximizedModeArea != null && (dockableArray = maximizedModeArea.getMaximized()) != null) {
                        Dockable[] dockableArray2 = dockableArray;
                        int n = dockableArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Dockable dockable3 = dockableArray2[n2];
                            if (dockableArray != null && dockable3 != dockable4 && dockable3 != dockable2) {
                                MaximizedMode.this.unmaximize(dockable3, affectedSet);
                            }
                            ++n2;
                        }
                    }
                    DockStation dockStation2 = dockStation = (dockable4 = dockStation.asDockable()) == null ? null : dockable4.getDockParent();
                }
            }
        });
    }

    public MaximizedModeArea getMaximizeArea(Dockable dockable, Location location) {
        return this.getMaximizeArea(dockable);
    }

    public MaximizedModeArea getMaximizeArea(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockStation);
            if (maximizedModeArea != null) {
                return maximizedModeArea;
            }
            dockable = dockStation.asDockable();
            dockStation = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    public MaximizedModeArea getMaximizeArea(DockStation dockStation) {
        for (MaximizedModeArea maximizedModeArea : this) {
            if (!maximizedModeArea.isRepresenting(dockStation)) continue;
            return maximizedModeArea;
        }
        return null;
    }

    public Dockable getMaximizingElement(Dockable dockable) {
        return this.getManager().getGroupBehavior().getGroupElement(this.getManager(), dockable, this.getExtendedMode());
    }

    public Dockable getMaximizingElement(Dockable dockable, Dockable dockable2) {
        return this.getManager().getGroupBehavior().getReplaceElement(this.getManager(), dockable, dockable2, this.getExtendedMode());
    }

    protected void applyStarting(LocationModeEvent locationModeEvent) {
        Dockable[] dockableArray;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : this) {
            dockableArray = object2.onApply(locationModeEvent);
            if (dockableArray == null) continue;
            arrayList.add(dockableArray);
        }
        object2 = locationModeEvent.getDockable();
        MaximizedModeArea maximizedModeArea = this.getMaximizeArea((Dockable)object2);
        if (maximizedModeArea == null) {
            return;
        }
        dockableArray = maximizedModeArea.getMaximized();
        if (dockableArray == null) {
            return;
        }
        Dockable dockable = null;
        int n = 0;
        while (n < dockableArray.length) {
            if (DockUtilities.isAncestor(dockableArray[n], (DockElement)object2)) {
                dockable = this.getMaximizingElement(dockableArray[n], (Dockable)object2);
                break;
            }
            ++n;
        }
        Runnable runnable = maximizedModeArea.onApply(locationModeEvent, dockable);
        if (runnable != null) {
            arrayList.add(runnable);
        }
        if (!arrayList.isEmpty()) {
            locationModeEvent.setClientObject(this.listener, arrayList);
        }
    }

    protected void applyDone(LocationModeEvent locationModeEvent) {
        List list = (List)locationModeEvent.getClientObject(this.listener);
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
    }

    @Override
    public ModeSettingFactory<Location> getSettingFactory() {
        return MaximizedModeSetting.FACTORY;
    }

    @Override
    public void writeSetting(ModeSetting<Location> modeSetting) {
        if (modeSetting instanceof MaximizedModeSetting) {
            MaximizedModeSetting maximizedModeSetting = (MaximizedModeSetting)modeSetting;
            maximizedModeSetting.setLastMaximizedLocation(this.lastMaximizedLocation);
            maximizedModeSetting.setLastMaximizedMode(this.lastMaximizedMode);
        }
    }

    @Override
    public void readSetting(ModeSetting<Location> modeSetting) {
        if (modeSetting instanceof MaximizedModeSetting) {
            MaximizedModeSetting maximizedModeSetting = (MaximizedModeSetting)modeSetting;
            this.lastMaximizedLocation = new HashMap<String, Location>(maximizedModeSetting.getLastMaximizedLocation());
            this.lastMaximizedMode = new HashMap<String, Path>(maximizedModeSetting.getLastMaximizedMode());
        }
    }

    protected boolean process(Dockable dockable, KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (keyStroke.equals(this.keyStrokeMaximizeChange.getValue())) {
            return this.switchMode(dockable);
        }
        return false;
    }

    public boolean switchMode(Dockable dockable) {
        LocationModeManager<?> locationModeManager = this.getManager();
        Mode mode = locationModeManager.getCurrentMode(dockable);
        if (mode == this) {
            LocationMode locationMode = (LocationMode)locationModeManager.getPreviousMode(dockable);
            if (locationMode != null && locationModeManager.isModeAvailable(dockable, locationMode.getExtendedMode())) {
                locationModeManager.setMode(dockable, locationMode.getExtendedMode());
                locationModeManager.ensureValidLocation(dockable);
                return true;
            }
        } else if (locationModeManager.isModeAvailable(dockable, this.getExtendedMode())) {
            locationModeManager.setMode(dockable, this.getExtendedMode());
            locationModeManager.ensureValidLocation(dockable);
            return true;
        }
        return false;
    }

    private class KeyHook
    extends DockRegisterAdapter
    implements KeyboardListener {
        private Dockable dockable;
        private DockController controller;

        public KeyHook(Dockable dockable) {
            this.dockable = dockable;
            this.controller = MaximizedMode.this.getController();
            this.controller.getKeyboardController().addListener(this);
            this.controller.getRegister().addDockRegisterListener(this);
            MaximizedMode.this.hooks.add(this);
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            if (this.dockable == dockable) {
                this.destroy(true);
            }
        }

        public void destroy(boolean bl) {
            this.controller.getKeyboardController().removeListener(this);
            this.controller.getRegister().removeDockRegisterListener(this);
            if (bl) {
                MaximizedMode.this.hooks.remove(this);
            }
        }

        @Override
        public DockElement getTreeLocation() {
            return this.dockable;
        }

        @Override
        public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
            return MaximizedMode.this.process(this.dockable, keyEvent);
        }

        @Override
        public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
            return MaximizedMode.this.process(this.dockable, keyEvent);
        }

        @Override
        public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
            return MaximizedMode.this.process(this.dockable, keyEvent);
        }
    }

    private class Listener
    implements ModeManagerListener<Location, LocationMode>,
    LocationModeListener {
        private Listener() {
        }

        public void replaceManager(LocationModeManager<?> locationModeManager, LocationModeManager<?> locationModeManager2) {
            if (locationModeManager != null) {
                locationModeManager.removeModeManagerListener(this);
                for (LocationMode object : locationModeManager.modes()) {
                    this.modeRemoved((ModeManager<? extends Location, ? extends LocationMode>)locationModeManager, object);
                }
            }
            if (locationModeManager2 != null) {
                locationModeManager2.addModeManagerListener(this);
                for (LocationMode locationMode : locationModeManager2.modes()) {
                    this.modeAdded((ModeManager<? extends Location, ? extends LocationMode>)locationModeManager2, locationMode);
                }
                for (Dockable dockable : locationModeManager2.listDockables()) {
                    new KeyHook(dockable);
                }
            }
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            new KeyHook(dockable);
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            if (locationMode != MaximizedMode.this) {
                locationMode.addLocationModeListener(this);
            }
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable, LocationMode locationMode, LocationMode locationMode2) {
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            locationMode.removeLocationModeListener(this);
        }

        @Override
        public void applyDone(LocationModeEvent locationModeEvent) {
            MaximizedMode.this.applyDone(locationModeEvent);
        }

        @Override
        public void applyStarting(LocationModeEvent locationModeEvent) {
            MaximizedMode.this.applyStarting(locationModeEvent);
        }
    }
}

