/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.group.CGroupBehaviorCallback;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.group.StackGroupBehavior;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.facile.mode.DoubleClickLocationStrategy;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.status.DefaultExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementListener;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.layout.location.AsideRequestFactory;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class LocationModeManager<M extends LocationMode>
extends ModeManager<Location, M> {
    public static final PropertyKey<ExtendedModeEnablementFactory> MODE_ENABLEMENT = new PropertyKey<ExtendedModeEnablementFactory>("locationmodemanager.mode_enablement", new ConstantPropertyFactory<ExtendedModeEnablementFactory>(DefaultExtendedModeEnablement.FACTORY), true);
    public static final PropertyKey<DoubleClickLocationStrategy> DOUBLE_CLICK_STRATEGY = new PropertyKey<DoubleClickLocationStrategy>("locationmodemanager.double_click_strategy", new ConstantPropertyFactory<DoubleClickLocationStrategy>(DoubleClickLocationStrategy.DEFAULT), true);
    private Map<Path, List<LocationModeListener>> listeners = new HashMap<Path, List<LocationModeListener>>();
    private RegisterListener registerListener = new RegisterListener();
    private HierarchyListener hierarchyListener = new HierarchyListener();
    private RelocatorListener relocatorListener = new RelocatorListener();
    private CGroupBehavior behavior = new StackGroupBehavior();
    private List<CGroupMovement> currentAction = new ArrayList<CGroupMovement>();
    private LinkedHashSet<Dockable> pendingRefreshs = new LinkedHashSet();
    private PropertyValue<ExtendedModeEnablementFactory> extendedModeFactory = new PropertyValue<ExtendedModeEnablementFactory>(MODE_ENABLEMENT){

        @Override
        protected void valueChanged(ExtendedModeEnablementFactory extendedModeEnablementFactory, ExtendedModeEnablementFactory extendedModeEnablementFactory2) {
            LocationModeManager.this.updateEnablement();
        }
    };
    private PropertyValue<DoubleClickLocationStrategy> doubleClickStrategy = new PropertyValue<DoubleClickLocationStrategy>(DOUBLE_CLICK_STRATEGY){

        @Override
        protected void valueChanged(DoubleClickLocationStrategy doubleClickLocationStrategy, DoubleClickLocationStrategy doubleClickLocationStrategy2) {
        }
    };
    private ExtendedModeEnablementListener enablementListener = new ExtendedModeEnablementListener(){

        @Override
        public void availabilityChanged(Dockable dockable, ExtendedMode extendedMode, boolean bl) {
            LocationModeManager.this.refresh(dockable, true);
        }
    };
    private DoubleClickListener doubleClickListener = new DoubleClickListener(){

        @Override
        public DockElement getTreeLocation() {
            return null;
        }

        @Override
        public boolean process(Dockable dockable, MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return false;
            }
            if ((dockable = LocationModeManager.this.getDoubleClickTarget(dockable)) != null) {
                Mode mode = LocationModeManager.this.getCurrentMode(dockable);
                ExtendedMode extendedMode = LocationModeManager.this.getDoubleClickStrategy().handleDoubleClick(dockable, mode == null ? null : mode.getExtendedMode(), LocationModeManager.this.enablement);
                if (extendedMode != null && LocationModeManager.this.isModeAvailable(dockable, extendedMode)) {
                    LocationModeManager.this.setMode(dockable, extendedMode);
                    LocationModeManager.this.ensureValidLocation(dockable);
                    return true;
                }
            }
            return false;
        }
    };
    private ExtendedModeEnablement enablement;
    private int layoutMode = 0;

    public LocationModeManager(DockController dockController) {
        super(dockController);
        this.registerListener.connect(dockController);
        dockController.getRelocator().addVetoableDockRelocatorListener(this.relocatorListener);
        this.updateEnablement();
        this.extendedModeFactory.setProperties(dockController);
        this.addModeManagerListener(new LocationModeListenerAdapter());
        dockController.getDoubleClickController().addListener(this.doubleClickListener);
    }

    @Override
    public void destroy() {
        this.registerListener.connect(null);
        DockController dockController = this.getController();
        dockController.getRelocator().removeVetoableDockRelocatorListener(this.relocatorListener);
        dockController.getDoubleClickController().removeListener(this.doubleClickListener);
        for (LocationMode locationMode : this.modes()) {
            locationMode.setController(null);
        }
        super.destroy();
        this.extendedModeFactory.setProperties((DockProperties)null);
    }

    protected void updateEnablement() {
        if (this.enablement != null) {
            this.enablement.removeListener(this.enablementListener);
            this.enablement.destroy();
            this.enablement = null;
        }
        if (this.getController() != null) {
            this.enablement = this.extendedModeFactory.getValue().create(this);
            this.enablement.addListener(this.enablementListener);
        }
        this.rebuildAll();
    }

    public void setGroupBehavior(CGroupBehavior cGroupBehavior) {
        if (cGroupBehavior == null) {
            throw new IllegalArgumentException("the group behavior must not be null");
        }
        this.behavior = cGroupBehavior;
    }

    public CGroupBehavior getGroupBehavior() {
        return this.behavior;
    }

    public void setMode(final Dockable dockable, final ExtendedMode extendedMode) {
        LocationMode locationMode = (LocationMode)this.getMode(extendedMode.getModeIdentifier());
        if (locationMode == null) {
            throw new IllegalArgumentException("No mode '" + extendedMode.getModeIdentifier() + "' available");
        }
        this.runTransaction(new Runnable(){

            @Override
            public void run() {
                CGroupMovement cGroupMovement = LocationModeManager.this.behavior.prepare(LocationModeManager.this, dockable, extendedMode);
                if (cGroupMovement == null) {
                    return;
                }
                LocationModeManager.this.apply(dockable, extendedMode, cGroupMovement);
            }
        });
    }

    public CGroupMovement getCurrentAction() {
        if (this.currentAction.isEmpty()) {
            return null;
        }
        return this.currentAction.get(this.currentAction.size() - 1);
    }

    public void apply(final Dockable dockable, final ExtendedMode extendedMode, final CGroupMovement cGroupMovement) {
        this.runTransaction(new AffectingRunnable(){

            @Override
            public void run(final AffectedSet affectedSet) {
                try {
                    LocationModeManager.this.getController().getFocusController().freezeFocus();
                    LocationModeManager.this.currentAction.add(cGroupMovement);
                    cGroupMovement.apply(new CGroupBehaviorCallback(){

                        @Override
                        public void setMode(Dockable dockable, ExtendedMode extendedMode) {
                            LocationModeManager.this.apply(dockable, extendedMode.getModeIdentifier(), false);
                        }

                        @Override
                        public void setLocation(Dockable dockable, Location location) {
                            LocationModeManager.this.apply(dockable, location.getMode(), location, affectedSet);
                        }

                        @Override
                        public LocationModeManager<? extends LocationMode> getManager() {
                            return LocationModeManager.this;
                        }

                        @Override
                        public Location getLocation(Dockable dockable) {
                            Mode mode = LocationModeManager.this.getCurrentMode(dockable);
                            if (mode == null) {
                                return null;
                            }
                            return (Location)mode.current(dockable);
                        }
                    });
                }
                finally {
                    LocationModeManager.this.currentAction.remove(cGroupMovement);
                    LocationModeManager.this.getController().getFocusController().meltFocus();
                }
                LocationMode locationMode = (LocationMode)LocationModeManager.this.getMode(extendedMode.getModeIdentifier());
                if (locationMode != null) {
                    if (locationMode.shouldAutoFocus()) {
                        LocationModeManager.this.getController().setFocusedDockable(new DefaultFocusRequest(dockable, null, true, true, false));
                    } else {
                        LocationModeManager.this.getController().setFocusedDockable(new DefaultFocusRequest(null, null, true));
                    }
                }
            }
        });
    }

    public ExtendedMode getMode(Dockable dockable) {
        Mode mode = this.getCurrentMode(dockable);
        if (mode == null) {
            return null;
        }
        return mode.getExtendedMode();
    }

    public Map<ExtendedMode, DockStation> getRepresentations(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        HashMap<ExtendedMode, DockStation> hashMap = new HashMap<ExtendedMode, DockStation>();
        for (LocationMode locationMode : this.modes()) {
            DockStation dockStation = locationMode.getRepresentation(string);
            if (dockStation == null) continue;
            hashMap.put(locationMode.getExtendedMode(), dockStation);
        }
        return hashMap;
    }

    @Override
    protected void applyDuringRead(String string, Path path, Path path2, Dockable dockable) {
    }

    @Override
    public void apply(Dockable dockable, M m, Location location, AffectedSet affectedSet) {
        super.apply(dockable, m, location, affectedSet);
        if (location != null) {
            location.resetApplicationDefined();
        }
    }

    public boolean isModeAvailable(Dockable dockable, ExtendedMode extendedMode) {
        if (this.enablement == null) {
            return false;
        }
        return this.enablement.isAvailable(dockable, extendedMode).isAvailable();
    }

    public boolean isModeHidden(Dockable dockable, ExtendedMode extendedMode) {
        if (this.enablement == null) {
            return false;
        }
        return this.enablement.isHidden(dockable, extendedMode).isHidden();
    }

    public void addListener(Path path, LocationModeListener locationModeListener) {
        if (locationModeListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        List<LocationModeListener> list = this.listeners.get(path);
        if (list == null) {
            list = new ArrayList<LocationModeListener>();
            this.listeners.put(path, list);
        }
        list.add(locationModeListener);
        LocationMode locationMode = (LocationMode)this.getMode(path);
        if (locationMode != null) {
            locationMode.addLocationModeListener(locationModeListener);
        }
    }

    public void removeListener(Path path, LocationModeListener locationModeListener) {
        LocationMode locationMode;
        List<LocationModeListener> list = this.listeners.get(path);
        if (list == null) {
            return;
        }
        list.remove(locationModeListener);
        if (list.isEmpty()) {
            this.listeners.remove(path);
        }
        if ((locationMode = (LocationMode)this.getMode(path)) != null) {
            locationMode.removeLocationModeListener(locationModeListener);
        }
    }

    @Override
    public M getCurrentMode(Dockable dockable) {
        while (dockable != null) {
            Object object2;
            for (Object object2 : this.modes()) {
                if (!object2.isCurrentMode(dockable)) continue;
                return (M)object2;
            }
            object2 = dockable.getDockParent();
            Dockable dockable2 = dockable = object2 == null ? null : object2.asDockable();
        }
        return null;
    }

    public DoubleClickLocationStrategy getDoubleClickStrategy() {
        return this.doubleClickStrategy.getValue();
    }

    public void setDoubleClickStrategy(DoubleClickLocationStrategy doubleClickLocationStrategy) {
        this.doubleClickStrategy.setValue(doubleClickLocationStrategy);
    }

    public boolean isLayouting() {
        return this.layoutMode > 0;
    }

    public void runLayoutTransaction(Runnable runnable) {
        try {
            ++this.layoutMode;
            this.runTransaction(runnable, true);
        }
        finally {
            --this.layoutMode;
        }
    }

    public void ensureNotHidden(final Dockable dockable) {
        if (this.isLayouting()) {
            return;
        }
        this.runTransaction(new Runnable(){

            @Override
            public void run() {
                for (LocationMode locationMode : LocationModeManager.this.modes()) {
                    locationMode.ensureNotHidden(dockable);
                }
            }
        });
    }

    public void ensureValidLocation(Dockable dockable) {
    }

    public void setLocationAside(Dockable dockable, Dockable dockable2) {
        Mode mode = this.getCurrentMode(dockable2);
        List list = this.getModeHistory(dockable2);
        for (LocationMode locationMode : list) {
            AsideRequestFactory asideRequestFactory;
            AsideRequest asideRequest;
            Location location;
            Location location2 = locationMode == mode ? (Location)locationMode.current(dockable2) : (Location)this.getHistory(dockable2, locationMode.getUniqueIdentifier());
            if (location2 == null || (location = locationMode.aside(asideRequest = (asideRequestFactory = this.getController().getProperties().get(AsideRequest.REQUEST_FACTORY)).createAsideRequest(location2.getLocation(), dockable), location2)) == null) continue;
            this.addToModeHistory(dockable, locationMode, location);
        }
    }

    @Override
    public DockActionSource getSharedActions(DockStation dockStation) {
        Dockable dockable = dockStation.getFrontDockable();
        if (dockable == null) {
            return null;
        }
        Mode mode = this.getCurrentMode(dockable);
        if (mode == null) {
            return null;
        }
        MultiDockActionSource multiDockActionSource = new MultiDockActionSource(new DockActionSource[0]);
        for (LocationMode locationMode : this.modes()) {
            DockActionSource dockActionSource;
            if (!this.behavior.shouldForwardActions(this, dockStation, dockable, locationMode.getExtendedMode()) || (dockActionSource = locationMode.getActionsFor(dockable, mode)) == null) continue;
            multiDockActionSource.add(dockActionSource);
        }
        return multiDockActionSource;
    }

    public void delayedRefresh(Dockable dockable) {
        if (this.getController().getRegister().isStalled()) {
            this.pendingRefreshs.add(dockable);
        } else {
            this.refresh(dockable, true);
        }
    }

    private class HierarchyListener
    implements DockHierarchyListener {
        private HierarchyListener() {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
            if (!LocationModeManager.this.isOnTransaction()) {
                LocationModeManager.this.delayedRefresh(dockHierarchyEvent.getDockable());
            }
        }
    }

    private class LocationModeListenerAdapter
    implements ModeManagerListener<Location, LocationMode> {
        private LocationModeListenerAdapter() {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            locationMode.setManager(LocationModeManager.this);
            locationMode.setController(LocationModeManager.this.getController());
            List list = (List)LocationModeManager.this.listeners.get(locationMode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener locationModeListener : list) {
                    locationMode.addLocationModeListener(locationModeListener);
                }
            }
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            locationMode.setManager(null);
            locationMode.setController(null);
            List list = (List)LocationModeManager.this.listeners.get(locationMode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener locationModeListener : list) {
                    locationMode.removeLocationModeListener(locationModeListener);
                }
            }
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable, LocationMode locationMode, LocationMode locationMode2) {
        }
    }

    private class RegisterListener
    extends DockRegisterAdapter {
        private DockController controller;

        private RegisterListener() {
        }

        public void connect(DockController dockController) {
            Dockable dockable;
            int n;
            int n2;
            Dockable[] dockableArray;
            DockRegister dockRegister;
            if (this.controller != null) {
                dockRegister = this.controller.getRegister();
                dockRegister.removeDockRegisterListener(this);
                dockableArray = dockRegister.listDockables();
                n2 = dockableArray.length;
                n = 0;
                while (n < n2) {
                    dockable = dockableArray[n];
                    dockable.removeDockHierarchyListener(LocationModeManager.this.hierarchyListener);
                    LocationModeManager.this.rebuild(dockable);
                    ++n;
                }
            }
            this.controller = dockController;
            if (dockController != null) {
                dockRegister = dockController.getRegister();
                dockRegister.addDockRegisterListener(this);
                dockableArray = dockRegister.listDockables();
                n2 = dockableArray.length;
                n = 0;
                while (n < n2) {
                    dockable = dockableArray[n];
                    dockable.addDockHierarchyListener(LocationModeManager.this.hierarchyListener);
                    ++n;
                }
            }
        }

        @Override
        public void dockableRegistered(DockController dockController, Dockable dockable) {
            dockable.addDockHierarchyListener(LocationModeManager.this.hierarchyListener);
            LocationModeManager.this.rebuild(dockable);
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            dockable.removeDockHierarchyListener(LocationModeManager.this.hierarchyListener);
        }

        @Override
        public void registerUnstalled(DockController dockController) {
            while (LocationModeManager.this.pendingRefreshs.size() > 0 && !dockController.getRegister().isStalled()) {
                Iterator iterator = LocationModeManager.this.pendingRefreshs.iterator();
                Dockable dockable = (Dockable)iterator.next();
                iterator.remove();
                LocationModeManager.this.refresh(dockable, true);
            }
        }
    }

    private class RelocatorListener
    extends VetoableDockRelocatorAdapter {
        private RelocatorListener() {
        }

        @Override
        public void dragging(DockRelocatorEvent dockRelocatorEvent) {
            LocationModeManager.this.store(dockRelocatorEvent.getDockable());
            Dockable[] dockableArray = dockRelocatorEvent.getImplicitDockables();
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable = dockableArray[n2];
                LocationModeManager.this.store(dockable);
                ++n2;
            }
        }
    }
}

