/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.facile.mode.MinimizedMode;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CLocationModeSettings<B>
extends ModeSettings<Location, B> {
    private Map<String, B> lastMaximizedLocation;
    private Map<String, String> lastMaximizedMode;
    private static final String MINIMIZED = "mini";
    private static final String MAXIMIZED = "maxi";
    private static final String NORMALIZED = "normal";

    public CLocationModeSettings(ModeSettingsConverter<Location, B> modeSettingsConverter) {
        super(modeSettingsConverter);
    }

    public void rescue(CMaximizedMode cMaximizedMode) {
        if (this.lastMaximizedLocation != null) {
            Object object;
            Map.Entry<String, String> entry2;
            MaximizedModeSetting maximizedModeSetting = new MaximizedModeSetting();
            HashMap<String, Path> hashMap = new HashMap<String, Path>();
            for (Map.Entry<String, String> entry2 : this.lastMaximizedMode.entrySet()) {
                String string = (String)entry2.getValue();
                object = this.resuceMode(string);
                if (object == null) continue;
                hashMap.put((String)entry2.getKey(), (Path)object);
            }
            entry2 = new HashMap();
            for (Map.Entry entry3 : this.lastMaximizedLocation.entrySet()) {
                object = (Location)this.getConverter().convertToWorld(entry3.getValue());
                entry2.put((String)entry3.getKey(), (String)object);
            }
            entry2.keySet().retainAll(hashMap.keySet());
            hashMap.keySet().retainAll(entry2.keySet());
            maximizedModeSetting.setLastMaximizedLocation((Map<String, Location>)((Object)entry2));
            maximizedModeSetting.setLastMaximizedMode(hashMap);
            cMaximizedMode.readSetting(maximizedModeSetting);
        }
    }

    @Override
    protected Path resuceMode(String string) {
        if (MINIMIZED.equals(string)) {
            return MinimizedMode.IDENTIFIER;
        }
        if (NORMALIZED.equals(string)) {
            return NormalMode.IDENTIFIER;
        }
        if (MAXIMIZED.equals(string)) {
            return MaximizedMode.IDENTIFIER;
        }
        return null;
    }

    @Override
    protected void rescueSettings(DataInputStream dataInputStream, Version version) throws IOException {
        if (version.compareTo(Version.VERSION_1_0_7) < 0) {
            if (dataInputStream.readBoolean()) {
                dataInputStream.readUTF();
            }
            if (dataInputStream.readBoolean()) {
                this.getConverter().readProperty(dataInputStream);
            }
        } else if (version.compareTo(Version.VERSION_1_0_7) == 0) {
            String string;
            String string2;
            this.lastMaximizedLocation = new HashMap<String, B>();
            this.lastMaximizedMode = new HashMap<String, String>();
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                string2 = dataInputStream.readUTF();
                string = dataInputStream.readUTF();
                this.lastMaximizedMode.put(string2, string);
                ++n2;
            }
            n = dataInputStream.readInt();
            n2 = 0;
            while (n2 < n) {
                string2 = dataInputStream.readUTF();
                string = this.getConverter().readProperty(dataInputStream);
                this.lastMaximizedLocation.put(string2, string);
                ++n2;
            }
        }
    }

    @Override
    protected void rescueSettings(XElement xElement) {
        XElement xElement2 = xElement.getElement("states");
        if (xElement2 != null) {
            this.lastMaximizedLocation = new HashMap<String, B>();
            this.lastMaximizedMode = new HashMap<String, String>();
            XElement xElement3 = xElement.getElement("maximized");
            if (xElement3 != null) {
                XElement[] xElementArray = xElement3.getElements("item");
                int n = xElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XElement xElement4;
                    XElement xElement5 = xElementArray[n2];
                    String string = xElement5.getString("id");
                    XElement xElement6 = xElement5.getElement("mode");
                    if (xElement6 != null) {
                        this.lastMaximizedMode.put(string, xElement6.getString());
                    }
                    if ((xElement4 = xElement5.getElement("location")) != null) {
                        XElement xElement7 = xElement4.copy();
                        xElement7.addElement("mode").setString(MaximizedMode.IDENTIFIER.toString());
                        this.lastMaximizedLocation.put(string, this.getConverter().readPropertyXML(xElement7));
                    }
                    ++n2;
                }
            }
        }
    }
}

