/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.ModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLocationMode<A extends ModeArea>
implements Iterable<A>,
LocationMode {
    private Map<String, A> areas = new HashMap<String, A>();
    private List<A> areaOrder = new LinkedList<A>();
    private A defaultArea;
    private LocationModeManager<?> manager;
    private List<LocationModeListener> listeners = new ArrayList<LocationModeListener>();
    private DockController controller;
    private AreaListener modeAreaListener = new AreaListener();
    private ModeManagerListener<Location, LocationMode> managerListener = new ManagerListener();
    private Map<Dockable, DockableHandle> handles = new HashMap<Dockable, DockableHandle>();
    private LocationModeActionProvider actionProvider = new DefaultLocationModeActionProvider();
    private boolean autoFocus = true;

    public void setActionProvider(LocationModeActionProvider locationModeActionProvider) {
        if (locationModeActionProvider == null) {
            throw new IllegalArgumentException("actionProvider must not be null");
        }
        if (!this.handles.isEmpty()) {
            throw new IllegalStateException("can only set actionProvider if no Dockables are currently showing actions of the old provider");
        }
        this.actionProvider = locationModeActionProvider;
    }

    @Override
    public void setManager(LocationModeManager<?> locationModeManager) {
        if (this.manager != null) {
            for (ModeArea modeArea : this.areas.values()) {
                modeArea.removeModeAreaListener(this.modeAreaListener);
            }
        }
        this.manager = locationModeManager;
        if (this.manager != null) {
            for (ModeArea modeArea : this.areas.values()) {
                modeArea.addModeAreaListener(this.modeAreaListener);
            }
            this.manager.addModeManagerListener(this.managerListener);
        }
    }

    @Override
    public LocationModeManager<?> getManager() {
        return this.manager;
    }

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        for (ModeArea modeArea : this.areas.values()) {
            modeArea.setController(dockController);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addLocationModeListener(LocationModeListener locationModeListener) {
        if (locationModeListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(locationModeListener);
    }

    @Override
    public void removeLocationModeListener(LocationModeListener locationModeListener) {
        this.listeners.remove(locationModeListener);
    }

    protected LocationModeListener[] listeners() {
        return this.listeners.toArray(new LocationModeListener[this.listeners.size()]);
    }

    @Override
    public boolean shouldAutoFocus() {
        return this.autoFocus;
    }

    public void setShouldAutoFocus(boolean bl) {
        this.autoFocus = bl;
    }

    public void add(A a) {
        if (a == null) {
            throw new IllegalArgumentException("area must not be null");
        }
        String string = a.getUniqueId();
        if (this.areas.containsKey(string)) {
            throw new IllegalArgumentException("key '" + string + "' already in use");
        }
        a.setController(this.getController());
        a.setMode(this);
        this.areas.put(string, a);
        this.areaOrder.add(a);
        if (this.getManager() != null) {
            a.addModeAreaListener(this.modeAreaListener);
        }
    }

    public A remove(String string) {
        ModeArea modeArea = (ModeArea)this.areas.remove(string);
        if (this.defaultArea == modeArea) {
            this.defaultArea = null;
        }
        if (modeArea != null) {
            modeArea.setController(null);
            modeArea.setMode(null);
            modeArea.removeModeAreaListener(this.modeAreaListener);
            this.areaOrder.remove(modeArea);
        }
        return (A)modeArea;
    }

    @Override
    public Iterator<A> iterator() {
        ArrayList<A> arrayList = new ArrayList<A>(this.areas.values());
        return arrayList.iterator();
    }

    public void setDefaultArea(A a) {
        if (a != null && !this.areas.containsKey(a.getUniqueId())) {
            throw new IllegalArgumentException("default area must be registered, call 'add' first");
        }
        this.defaultArea = a;
    }

    public A getDefaultArea() {
        if (this.defaultArea == null) {
            for (ModeArea modeArea : this.areaOrder) {
                if (!modeArea.autoDefaultArea()) continue;
                return (A)modeArea;
            }
        }
        return this.defaultArea;
    }

    public A get(String string) {
        return (A)((ModeArea)this.areas.get(string));
    }

    @Override
    public DockStation getRepresentation(String string) {
        A a = this.get(string);
        if (a == null) {
            return null;
        }
        return a.getStation();
    }

    @Override
    public Set<String> getRepresentationIds() {
        return Collections.unmodifiableSet(this.areas.keySet());
    }

    public A get(Dockable dockable) {
        return this.get(dockable, false);
    }

    public A get(Dockable dockable, boolean bl) {
        while (dockable != null) {
            Object object2;
            for (Object object2 : this.areas.values()) {
                if (bl && !object2.isLocationRoot() || !object2.isChild(dockable)) continue;
                return (A)object2;
            }
            object2 = dockable.getDockParent();
            if (object2 == null) {
                return null;
            }
            dockable = object2.asDockable();
        }
        return null;
    }

    public A get(DockStation dockStation) {
        while (dockStation != null) {
            Object object2;
            for (Object object2 : this) {
                if (object2.getStation() != dockStation) continue;
                return (A)object2;
            }
            object2 = dockStation.asDockable();
            DockStation dockStation2 = dockStation = object2 == null ? null : object2.getDockParent();
        }
        return null;
    }

    @Override
    public Location aside(AsideRequest asideRequest, Location location) {
        A a = this.get(location.getRoot());
        if (a == null) {
            return null;
        }
        AsideAnswer asideAnswer = asideRequest.execute(a.getStation());
        if (asideAnswer.isCanceled()) {
            return null;
        }
        return new Location(this.getUniqueIdentifier(), location.getRoot(), asideAnswer.getLocation(), true);
    }

    @Override
    public DockActionSource getActionsFor(Dockable dockable, Mode<Location> mode) {
        if (mode == this) {
            return null;
        }
        if (!this.isModeAvailable(dockable) || this.isModeHidden(dockable)) {
            return null;
        }
        DockableHandle dockableHandle = this.handles.get(dockable);
        if (dockableHandle == null) {
            return null;
        }
        return dockableHandle.getActions(mode);
    }

    protected boolean isModeAvailable(Dockable dockable) {
        LocationModeManager<?> locationModeManager = this.getManager();
        if (locationModeManager == null) {
            return false;
        }
        return locationModeManager.isModeAvailable(dockable, this.getExtendedMode());
    }

    protected boolean isModeHidden(Dockable dockable) {
        LocationModeManager<?> locationModeManager = this.getManager();
        if (locationModeManager == null) {
            return false;
        }
        return locationModeManager.isModeHidden(dockable, this.getExtendedMode());
    }

    @Override
    public boolean isRepresenting(DockStation dockStation) {
        for (ModeArea modeArea : this.areas.values()) {
            if (modeArea.getStation() != dockStation) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(Dockable dockable, Location location, AffectedSet affectedSet) {
        LocationModeListener locationModeListener;
        LocationModeEvent locationModeEvent = new LocationModeEvent(this, location, dockable, affectedSet);
        LocationModeListener[] locationModeListenerArray = this.listeners();
        int n = locationModeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            locationModeListener = locationModeListenerArray[n2];
            locationModeListener.applyStarting(locationModeEvent);
            ++n2;
        }
        if (!locationModeEvent.isDone()) {
            boolean bl = this.runApply(dockable, location, affectedSet);
            locationModeEvent.done(bl);
        }
        locationModeListenerArray = this.listeners();
        n = locationModeListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            locationModeListener = locationModeListenerArray[n2];
            locationModeListener.applyDone(locationModeEvent);
            ++n2;
        }
        return locationModeEvent.isSuccess();
    }

    protected abstract boolean runApply(Dockable var1, Location var2, AffectedSet var3);

    protected DockableHandle createHandle(Dockable dockable) {
        return new DockableHandle(dockable);
    }

    private class AreaListener
    implements ModeAreaListener {
        private AreaListener() {
        }

        @Override
        public void internalLocationChange(ModeArea modeArea, Set<Dockable> set) {
            LocationModeManager<?> locationModeManager = AbstractLocationMode.this.getManager();
            if (locationModeManager != null) {
                if (locationModeManager.isOnTransaction()) {
                    locationModeManager.addAffected(set);
                } else {
                    for (Dockable dockable : set) {
                        locationModeManager.refresh(dockable, true);
                    }
                }
            }
        }
    }

    protected class DockableHandle {
        private Dockable dockable;
        private DockActionSource source;

        public DockableHandle(Dockable dockable) {
            this.dockable = dockable;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public void destroy() {
            AbstractLocationMode.this.actionProvider.destroy(this.dockable, this.source);
            this.dockable = null;
            this.source = null;
        }

        public DockActionSource getActions(Mode<Location> mode) {
            this.source = AbstractLocationMode.this.actionProvider.getActions(this.dockable, mode, this.source);
            return this.source;
        }
    }

    private class ManagerListener
    implements ModeManagerListener<Location, LocationMode> {
        private ManagerListener() {
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            if (!AbstractLocationMode.this.handles.containsKey(dockable)) {
                DockableHandle dockableHandle = AbstractLocationMode.this.createHandle(dockable);
                AbstractLocationMode.this.handles.put(dockable, dockableHandle);
            }
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            DockableHandle dockableHandle = (DockableHandle)AbstractLocationMode.this.handles.remove(dockable);
            if (dockableHandle != null) {
                dockableHandle.destroy();
            }
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable, LocationMode locationMode, LocationMode locationMode2) {
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
        }
    }
}

