/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import javax.swing.Icon;

public class ReplaceAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    public static final String KEY_ICON = "replace";
    private DockStationListener dockStationListener = new DockStationAdapter(){

        @Override
        public void dockableAdded(DockStation dockStation, Dockable dockable) {
            ReplaceAction.this.setGroup(ReplaceAction.this.createGroupKey(dockStation.asDockable()), dockStation.asDockable());
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            ReplaceAction.this.setGroup(ReplaceAction.this.createGroupKey(dockStation.asDockable()), dockStation.asDockable());
        }
    };
    private DockActionText text;
    private DockActionText tooltip;
    private DockActionIcon icon;

    public ReplaceAction(DockController dockController) {
        super(null);
        this.setRemoveEmptyGroups(false);
        this.setEnabled(true, true);
        this.setEnabled(false, false);
        this.text = new DockActionText(KEY_ICON, this){

            @Override
            protected void changed(String string, String string2) {
                ReplaceAction.this.setText(true, string2);
                ReplaceAction.this.setText(false, string2);
            }
        };
        this.tooltip = new DockActionText("replace.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                ReplaceAction.this.setTooltip(true, string2);
                ReplaceAction.this.setTooltip(false, string2);
            }
        };
        this.icon = new DockActionIcon(KEY_ICON, this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                ReplaceAction.this.setIcon(true, icon2);
                ReplaceAction.this.setIcon(false, icon2);
            }
        };
        this.setController(dockController);
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("Only dockables which are also a DockStation can be used for a ReplaceAction");
        }
        DockStation dockStation2 = dockable.getDockParent();
        if (dockStation2 == null) {
            return false;
        }
        int n = dockStation.getDockableCount();
        if (n == 0) {
            return dockStation2.canDrag(dockable);
        }
        if (n == 1) {
            if (dockStation2.canReplace(dockable, dockStation.getDockable(0)) && dockStation2.accept(dockStation.getDockable(0)) && dockStation.getDockable(0).accept(dockStation2) && dockStation.canDrag(dockStation.getDockable(0))) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void action(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        DockStation dockStation2 = dockable.getDockParent();
        if (dockStation2 != null) {
            if (dockStation.getDockableCount() == 0) {
                if (dockStation2.canDrag(dockStation.asDockable())) {
                    dockStation2.drag(dockStation.asDockable());
                }
            } else if (dockStation2.canReplace(dockStation.asDockable(), dockStation.getDockable(0)) && dockStation2.accept(dockStation.getDockable(0)) && dockStation.getDockable(0).accept(dockStation2) && dockStation.canDrag(dockStation.getDockable(0))) {
                dockable = dockStation.getDockable(0);
                dockStation.drag(dockable);
                dockStation2.replace(dockStation.asDockable(), dockable);
            }
        }
    }

    @Override
    public void bound(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        dockStation.addDockStationListener(this.dockStationListener);
        super.bound(dockable);
    }

    @Override
    public void unbound(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        dockStation.removeDockStationListener(this.dockStationListener);
        super.unbound(dockable);
    }

    @Override
    public void setController(DockController dockController) {
        this.icon.setController(dockController);
        this.text.setController(dockController);
        this.tooltip.setController(dockController);
    }
}

