/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.facile.action.RenameAction;
import java.util.HashMap;
import java.util.Map;

public class RenameActionFactory {
    private DockController controller;
    private Map<Class<?>, RenameAction> actions = new HashMap();

    public RenameActionFactory(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("Controller must not be null");
        }
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public RenameAction find(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        Class<?> clazz = dockable.getClass();
        RenameAction renameAction = this.find(clazz);
        if (renameAction == null) {
            throw new IllegalStateException("Can't find a rule for " + clazz.getName());
        }
        return renameAction;
    }

    protected RenameAction find(Class<?> clazz) {
        RenameAction renameAction = this.actions.get(clazz);
        if (renameAction == null) {
            renameAction = this.create(clazz);
            if (renameAction == null) {
                Class<?> clazz2 = clazz.getSuperclass();
                if (clazz2 == null) {
                    return null;
                }
                renameAction = this.find(clazz2);
            }
            if (renameAction != null) {
                this.actions.put(clazz, renameAction);
            }
        }
        return renameAction;
    }

    protected RenameAction create(Class<?> clazz) {
        if (clazz.equals(DefaultDockable.class)) {
            return new RenameAction.RenameDefaultDockable(this.controller);
        }
        if (clazz.equals(SplitDockStation.class)) {
            return new RenameAction.RenameSplitDockStation(this.controller);
        }
        if (clazz.equals(FlapDockStation.class)) {
            return new RenameAction.RenameFlapDockStation(this.controller);
        }
        if (clazz.equals(StackDockStation.class)) {
            return new RenameAction.RenameStackDockStation(this.controller);
        }
        return null;
    }
}

