/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class RenameAction
extends SimpleButtonAction {
    public static final String KEY_ICON = "rename";
    private DockController controller;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JTextField titleField = new JTextField();
    private JPopupMenu menu = new JPopupMenu();
    private Dockable current;
    private DockActionIcon icon;
    private DockActionText text;
    private DockActionText tooltip;
    private DockActionText textOk;
    private DockActionText textCancel;
    private int bound = 0;

    public RenameAction(DockController dockController) {
        this.controller = dockController;
        this.icon = new DockActionIcon(KEY_ICON, this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                RenameAction.this.setIcon(icon2);
            }
        };
        this.text = new DockActionText(KEY_ICON, this){

            @Override
            protected void changed(String string, String string2) {
                RenameAction.this.setText(string2);
            }
        };
        this.tooltip = new DockActionText("rename.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                RenameAction.this.setTooltip(string2);
            }
        };
        this.menu.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.menu.add((Component)this.titleField, new GridBagConstraints(0, 0, 1, 1, 100.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.menu.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.titleField.setColumns(10);
        this.textOk = new DockActionText("rename.ok", this){

            @Override
            protected void changed(String string, String string2) {
                RenameAction.this.okButton.setText(string2);
            }
        };
        this.textCancel = new DockActionText("rename.cancel", this){

            @Override
            protected void changed(String string, String string2) {
                RenameAction.this.cancelButton.setText(string2);
            }
        };
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                RenameAction.this.current = null;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenameAction.this.rename();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenameAction.this.menu.setVisible(false);
            }
        });
        this.titleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenameAction.this.rename();
            }
        });
    }

    @Override
    public void action(Dockable dockable) {
        this.titleField.setText("");
        this.menu.setSize(this.menu.getPreferredSize());
        this.titleField.setText(dockable.getTitleText());
        Component component = DockUtilities.getShowingComponent(dockable);
        if (component != null) {
            this.current = dockable;
            this.menu.show(component, 0, 0);
            this.titleField.requestFocus();
        }
    }

    private void rename() {
        this.rename(this.current, this.titleField.getText());
        this.menu.setVisible(false);
    }

    @Override
    protected void bound(Dockable dockable) {
        super.bound(dockable);
        if (this.bound == 0) {
            this.icon.setController(this.controller);
            this.text.setController(this.controller);
            this.tooltip.setController(this.controller);
            this.textOk.setController(this.controller);
            this.textCancel.setController(this.controller);
        }
        ++this.bound;
    }

    @Override
    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        --this.bound;
        if (this.bound == 0) {
            this.icon.setController(null);
            this.text.setController(null);
            this.tooltip.setController(null);
            this.textOk.setController(null);
            this.textCancel.setController(null);
        }
    }

    protected abstract void rename(Dockable var1, String var2);

    public static class RenameDefaultDockable
    extends RenameAction {
        public RenameDefaultDockable(DockController dockController) {
            super(dockController);
        }

        @Override
        protected void rename(Dockable dockable, String string) {
            ((DefaultDockable)dockable).setTitleText(string);
        }
    }

    public static class RenameFlapDockStation
    extends RenameAction {
        public RenameFlapDockStation(DockController dockController) {
            super(dockController);
        }

        @Override
        protected void rename(Dockable dockable, String string) {
            ((FlapDockStation)dockable).setTitleText(string);
        }
    }

    public static class RenameSplitDockStation
    extends RenameAction {
        public RenameSplitDockStation(DockController dockController) {
            super(dockController);
        }

        @Override
        protected void rename(Dockable dockable, String string) {
            ((SplitDockStation)dockable).setTitleText(string);
        }
    }

    public static class RenameStackDockStation
    extends RenameAction {
        public RenameStackDockStation(DockController dockController) {
            super(dockController);
        }

        @Override
        protected void rename(Dockable dockable, String string) {
            ((StackDockStation)dockable).setTitleText(string);
        }
    }
}

