/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.Iterator;

public class KeyedActionSource
extends AbstractDockActionSource {
    private CDockable dockable;
    private String key;
    private DockAction defaultAction;
    private LocationHint hint = LocationHint.UNKNOWN;
    private boolean visible = true;
    private boolean propertyListenerInstalled = false;
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        @Override
        public void actionChanged(CDockable cDockable, String string, CAction cAction, CAction cAction2) {
            if (KeyedActionSource.this.visible) {
                boolean bl;
                boolean bl2 = cAction != null || KeyedActionSource.this.defaultAction != null;
                boolean bl3 = bl = cAction2 != null || KeyedActionSource.this.defaultAction != null;
                if (bl2 && !bl) {
                    KeyedActionSource.this.fireRemoved(0, 0);
                } else if (!bl2 && bl) {
                    KeyedActionSource.this.fireAdded(0, 0);
                } else if (bl2 && bl) {
                    KeyedActionSource.this.visible = false;
                    KeyedActionSource.this.fireRemoved(0, 0);
                    KeyedActionSource.this.visible = true;
                    KeyedActionSource.this.fireAdded(0, 0);
                }
            }
        }
    };

    public KeyedActionSource(CDockable cDockable, String string) {
        if (cDockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.dockable = cDockable;
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.addDockActionSourceListener(dockActionSourceListener);
        if (this.visible && !this.propertyListenerInstalled && !this.listeners.isEmpty()) {
            this.dockable.addCDockablePropertyListener(this.propertyListener);
            this.propertyListenerInstalled = true;
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (this.visible && this.propertyListenerInstalled && this.listeners.isEmpty()) {
            this.dockable.removeCDockablePropertyListener(this.propertyListener);
            this.propertyListenerInstalled = false;
        }
    }

    public void destroy() {
        if (this.propertyListenerInstalled) {
            this.dockable.removeCDockablePropertyListener(this.propertyListener);
            this.propertyListenerInstalled = false;
        }
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            int n;
            int n2 = this.getDockActionCount();
            this.visible = bl;
            if (bl) {
                if (!this.propertyListenerInstalled && !this.listeners.isEmpty()) {
                    this.dockable.addCDockablePropertyListener(this.propertyListener);
                    this.propertyListenerInstalled = true;
                }
            } else if (this.propertyListenerInstalled) {
                this.dockable.removeCDockablePropertyListener(this.propertyListener);
                this.propertyListenerInstalled = false;
            }
            if (n2 < (n = this.getDockActionCount())) {
                this.fireAdded(0, 0);
            } else if (n2 > n) {
                this.fireRemoved(0, 0);
            }
        }
    }

    public void setDefaultAction(DockAction dockAction) {
        if (this.visible) {
            if (this.dockable.getAction(this.key) == null) {
                this.visible = false;
                this.fireRemoved(0, 0);
                this.defaultAction = dockAction;
                this.visible = true;
                this.fireAdded(1, 1);
            } else {
                this.defaultAction = dockAction;
            }
        } else {
            this.defaultAction = dockAction;
        }
    }

    public DockAction getDefaultAction() {
        return this.defaultAction;
    }

    private DockAction currentAction() {
        if (!this.visible) {
            return null;
        }
        CAction cAction = this.dockable.getAction(this.key);
        if (cAction == null) {
            return this.defaultAction;
        }
        return cAction.intern();
    }

    @Override
    public DockAction getDockAction(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("only index=0 supported");
        }
        return this.currentAction();
    }

    @Override
    public int getDockActionCount() {
        if (this.currentAction() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private DockAction action;
            {
                this.action = KeyedActionSource.this.currentAction();
            }

            @Override
            public boolean hasNext() {
                return this.action != null;
            }

            @Override
            public DockAction next() {
                if (this.action == null) {
                    throw new IllegalStateException("no elements left");
                }
                DockAction dockAction = this.action;
                this.action = null;
                return dockAction;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

