/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.dock.dockable.MovingImage;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TrueMovingImage
extends JPanel
implements MovingImage {
    private BufferedImage image;
    private float alpha = 1.0f;
    private boolean transparent = true;

    public void setAlpha(float f) {
        if (f < 0.0f || f > 1.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("alpha must be between 0 and 1");
        }
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.image != null) {
            if (this.alpha == 1.0f || !this.transparent) {
                graphics.drawImage(this.image, 0, 0, this);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(11, this.alpha));
                graphics.drawImage(this.image, 0, 0, this);
                graphics2D.setComposite(composite);
            }
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        if (bufferedImage != null) {
            this.setPreferredSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        this.repaint();
    }

    @Override
    public Point getOffset(Point point) {
        return null;
    }

    @Override
    public void bind(boolean bl) {
        this.transparent = bl;
        this.setOpaque(!bl);
    }

    @Override
    public void unbind() {
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

