/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.dockable.TrueMovingImage;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.AWTComponentCaptureStrategy;
import bibliothek.gui.dock.util.DockSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ScreencaptureMovingImageFactory
implements DockableMovingImageFactory {
    private Dimension max;
    private float alpha;

    public ScreencaptureMovingImageFactory(Dimension dimension) {
        this(dimension, 1.0f);
    }

    public ScreencaptureMovingImageFactory(Dimension dimension, float f) {
        this.max = dimension;
        this.setAlpha(f);
    }

    public void setAlpha(float f) {
        if (f < 0.0f || f > 1.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("alpha must be between 0 and 1");
        }
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public MovingImage create(DockController dockController, DockTitle dockTitle) {
        return this.create(dockController, dockTitle.getDockable());
    }

    @Override
    public MovingImage create(DockController dockController, Dockable dockable) {
        BufferedImage bufferedImage = this.createImageFrom(dockController, dockable);
        TrueMovingImage trueMovingImage = new TrueMovingImage();
        trueMovingImage.setAlpha(this.alpha);
        trueMovingImage.setImage(bufferedImage);
        return trueMovingImage;
    }

    public BufferedImage createImageFrom(DockController dockController, Dockable dockable) {
        Component component = dockable.getComponent();
        BufferedImage bufferedImage = this.createImageFrom(dockController, component);
        if (bufferedImage == null) {
            Icon icon = dockable.getTitleIcon();
            if (icon == null || icon.getIconHeight() < 1 || icon.getIconWidth() < 1) {
                return null;
            }
            bufferedImage = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(component.getBackground());
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            icon.paintIcon(component, graphics2D, 1, 1);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public BufferedImage createImageFrom(DockController dockController, Component component) {
        Dimension dimension = new Dimension(Math.max(1, component.getWidth()), Math.max(1, component.getHeight()));
        BufferedImage bufferedImage = null;
        if (dimension.width >= 10 && dimension.height >= 10) {
            if (DockSwingUtilities.containsAWTComponents(component)) {
                bufferedImage = dockController.getProperties().get(AWTComponentCaptureStrategy.STRATEGY).createCapture(dockController, component);
            } else {
                bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                component.paint(graphics2D);
                graphics2D.dispose();
            }
            if (bufferedImage != null) {
                double d = 1.0;
                if (this.max != null) {
                    d = Math.min(this.max.getWidth() / dimension.getWidth(), this.max.getHeight() / dimension.getHeight());
                }
                if (d < 1.0) {
                    int n = (int)(d * dimension.getWidth());
                    int n2 = (int)(d * dimension.getHeight());
                    n = Math.max(n, 1);
                    n2 = Math.max(n2, 1);
                    if (n != dimension.width || n2 != dimension.height) {
                        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
                        Graphics2D graphics2D = bufferedImage2.createGraphics();
                        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, dimension.width, dimension.height, null);
                        graphics2D.dispose();
                        bufferedImage = bufferedImage2;
                    }
                }
            }
        }
        return bufferedImage;
    }
}

