/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableStateEvent;
import bibliothek.gui.dock.dockable.DockableStateListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

public class DockableStateListenerManager {
    private List<DockableStateListener> listeners = new ArrayList<DockableStateListener>();
    private int current = 0;
    private DockStation parent;
    private Dockable dockable;
    private boolean dockableShowing;
    private boolean firing = false;
    private DockableStateListener dockableStateListener = new DockableStateListener(){

        @Override
        public void changed(DockableStateEvent dockableStateEvent) {
            int n = dockableStateEvent.getFlags();
            if (dockableStateEvent.didLocationChange()) {
                n &= 0xFFFFFFFE;
                n |= 2;
            }
            if (dockableStateEvent.didParentSelectionChange()) {
                n &= 0xFFFFFFF7;
                n |= 0x10;
            }
            if (dockableStateEvent.didShowingChange()) {
                boolean bl = DockableStateListenerManager.this.dockable.isDockableShowing();
                if (bl != DockableStateListenerManager.this.dockableShowing) {
                    DockableStateListenerManager.this.dockableShowing = bl;
                    n |= 4;
                } else {
                    n &= 0xFFFFFFFB;
                }
            }
            DockableStateListenerManager.this.event(n);
        }
    };
    private DockHierarchyListener dockHierarchyListener = new DockHierarchyListener(){

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
            if (DockableStateListenerManager.this.parent != null) {
                if (DockableStateListenerManager.this.parent.asDockable() != null) {
                    DockableStateListenerManager.this.parent.asDockable().removeDockableStateListener(DockableStateListenerManager.this.dockableStateListener);
                }
                DockableStateListenerManager.this.parent.removeDockStationListener(DockableStateListenerManager.this.dockStationListener);
                DockableStateListenerManager.this.parent = null;
            }
            DockableStateListenerManager.this.parent = DockableStateListenerManager.this.dockable.getDockParent();
            if (DockableStateListenerManager.this.parent != null) {
                if (DockableStateListenerManager.this.parent.asDockable() != null) {
                    DockableStateListenerManager.this.parent.asDockable().addDockableStateListener(DockableStateListenerManager.this.dockableStateListener);
                }
                DockableStateListenerManager.this.parent.addDockStationListener(DockableStateListenerManager.this.dockStationListener);
            }
            DockableStateListenerManager.this.event(32);
            DockableStateListenerManager.this.checkShowing();
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            DockableStateListenerManager.this.checkShowing();
        }
    };
    private DockStationListener dockStationListener = new DockStationAdapter(){

        @Override
        public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
            if (dockable == DockableStateListenerManager.this.dockable) {
                DockableStateListenerManager.this.checkShowing();
            }
        }

        @Override
        public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
            if (dockable == DockableStateListenerManager.this.dockable || dockable2 == DockableStateListenerManager.this.dockable) {
                DockableStateListenerManager.this.event(8);
            }
        }

        @Override
        public void dockablesRepositioned(DockStation dockStation, Dockable[] dockableArray) {
            Dockable[] dockableArray2 = dockableArray;
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable = dockableArray2[n2];
                if (dockable == DockableStateListenerManager.this.dockable) {
                    DockableStateListenerManager.this.event(1);
                    break;
                }
                ++n2;
            }
        }
    };

    public DockableStateListenerManager(Dockable dockable) {
        this.dockable = dockable;
    }

    public void checkShowing() {
        boolean bl = this.dockable.isDockableShowing();
        if (this.dockableShowing != bl) {
            this.dockableShowing = bl;
            this.event(4);
        }
    }

    public void addListener(DockableStateListener dockableStateListener) {
        if (dockableStateListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        boolean bl = this.hasListeners();
        this.listeners.add(dockableStateListener);
        if (!bl && this.hasListeners()) {
            this.install();
        }
    }

    public void removeListener(DockableStateListener dockableStateListener) {
        boolean bl = this.hasListeners();
        this.listeners.remove(dockableStateListener);
        if (bl && !this.hasListeners()) {
            this.uninstall();
        }
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    public void event(int n) {
        this.current |= n;
        if (!this.firing) {
            this.firing = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockableStateListenerManager.this.firing = false;
                    DockableStateListenerManager.this.fireNow();
                }
            });
        }
    }

    private void fireNow() {
        if (this.current != 0) {
            if (this.listeners.size() > 0) {
                DockableStateEvent dockableStateEvent = new DockableStateEvent(this.dockable, this.current);
                this.current = 0;
                DockableStateListener[] dockableStateListenerArray = this.listeners.toArray(new DockableStateListener[this.listeners.size()]);
                int n = dockableStateListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockableStateListener dockableStateListener = dockableStateListenerArray[n2];
                    dockableStateListener.changed(dockableStateEvent);
                    ++n2;
                }
            }
            this.current = 0;
        }
    }

    protected void install() {
        this.dockable.addDockHierarchyListener(this.dockHierarchyListener);
        this.parent = this.dockable.getDockParent();
        if (this.parent != null) {
            if (this.parent.asDockable() != null) {
                this.parent.asDockable().addDockableStateListener(this.dockableStateListener);
            }
            this.parent.addDockStationListener(this.dockStationListener);
        }
        this.dockableShowing = this.dockable.isDockableShowing();
    }

    protected void uninstall() {
        this.dockable.removeDockHierarchyListener(this.dockHierarchyListener);
        if (this.parent != null) {
            if (this.parent.asDockable() != null) {
                this.parent.asDockable().removeDockableStateListener(this.dockableStateListener);
            }
            this.parent.removeDockStationListener(this.dockStationListener);
            this.parent = null;
        }
    }
}

