/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import java.util.ArrayList;
import java.util.List;

public class DockHierarchyObserver
implements DockHierarchyListener {
    private DockElement parent;
    private List<DockHierarchyListener> hierarchyListeners = new ArrayList<DockHierarchyListener>();
    private Dockable owner;

    public DockHierarchyObserver(Dockable dockable) {
        this.owner = dockable;
    }

    @Override
    public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        this.fireHierarchyChanged();
    }

    @Override
    public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
    }

    public void controllerChanged(DockController dockController) {
        this.fireControllerChanged(dockController);
    }

    public void addDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyListeners.add(dockHierarchyListener);
    }

    public void removeDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyListeners.remove(dockHierarchyListener);
    }

    protected void fireHierarchyChanged() {
        if (!this.hierarchyListeners.isEmpty()) {
            DockHierarchyEvent dockHierarchyEvent = new DockHierarchyEvent(this.owner);
            DockHierarchyListener[] dockHierarchyListenerArray = this.hierarchyListeners.toArray(new DockHierarchyListener[this.hierarchyListeners.size()]);
            int n = dockHierarchyListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockHierarchyListener dockHierarchyListener = dockHierarchyListenerArray[n2];
                dockHierarchyListener.hierarchyChanged(dockHierarchyEvent);
                ++n2;
            }
        }
    }

    protected void fireControllerChanged(DockController dockController) {
        if (!this.hierarchyListeners.isEmpty()) {
            DockHierarchyEvent dockHierarchyEvent = new DockHierarchyEvent(this.owner, dockController);
            DockHierarchyListener[] dockHierarchyListenerArray = this.hierarchyListeners.toArray(new DockHierarchyListener[this.hierarchyListeners.size()]);
            int n = dockHierarchyListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockHierarchyListener dockHierarchyListener = dockHierarchyListenerArray[n2];
                dockHierarchyListener.controllerChanged(dockHierarchyEvent);
                ++n2;
            }
        }
    }

    public void update() {
        DockElement dockElement = this.parent;
        this.parent = this.owner.getDockParent();
        if (dockElement != this.parent) {
            if (dockElement != null && dockElement.asDockable() != null) {
                dockElement.asDockable().removeDockHierarchyListener(this);
            }
            if (this.parent != null && this.parent.asDockable() != null) {
                this.parent.asDockable().addDockHierarchyListener(this);
            }
            this.fireHierarchyChanged();
        }
    }
}

