/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.HierarchyDockActionSource;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.dockable.DockHierarchyObserver;
import bibliothek.gui.dock.dockable.DockableStateListener;
import bibliothek.gui.dock.dockable.DockableStateListenerManager;
import bibliothek.gui.dock.dockable.IconHandling;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.MouseInputListener;

public abstract class AbstractDockable
implements Dockable {
    private DockStation parent;
    private DockController controller;
    private List<DockableListener> dockableListeners = new ArrayList<DockableListener>();
    private DockHierarchyObserver hierarchyObserver;
    private DockableStateListenerManager dockableStateListeners;
    private List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    private KeyboardListener keyboardListener;
    private PropertyValue<String> titleText;
    private DockIcon titleIcon;
    private Icon currentTitleIcon;
    private IconHandling titleIconHandling = IconHandling.KEEP_NULL_ICON;
    private PropertyValue<String> titleToolTip;
    private List<DockTitle> titles = new LinkedList<DockTitle>();
    private DockableDisplayerHints hints;
    private DockComponentRootHandler rootHandler;
    private DockActionSource source;
    private HierarchyDockActionSource globalSource;

    protected AbstractDockable(PropertyKey<String> propertyKey, PropertyKey<String> propertyKey2) {
        this.titleText = new PropertyValue<String>(propertyKey){

            @Override
            protected void valueChanged(String string, String string2) {
                if (string == null) {
                    string = "";
                }
                if (string2 == null) {
                    string2 = "";
                }
                AbstractDockable.this.fireTitleTextChanged(string, string2);
            }
        };
        this.titleToolTip = new PropertyValue<String>(propertyKey2){

            @Override
            protected void valueChanged(String string, String string2) {
                AbstractDockable.this.fireTitleTooltipChanged(string, string2);
            }
        };
        this.dockableStateListeners = new DockableStateListenerManager(this);
        this.hierarchyObserver = new DockHierarchyObserver(this);
        this.globalSource = new HierarchyDockActionSource(this);
        this.globalSource.bind();
    }

    protected DockComponentRootHandler getRootHandler() {
        if (this.rootHandler == null) {
            this.rootHandler = this.createRootHandler();
            this.rootHandler.addRoot(this.getComponent());
        }
        return this.rootHandler;
    }

    protected abstract DockComponentRootHandler createRootHandler();

    protected abstract DockIcon createTitleIcon();

    private DockIcon titleIcon() {
        if (this.titleIcon == null) {
            this.titleIcon = this.createTitleIcon();
            this.titleIcon.setController(this.getController());
        }
        return this.titleIcon;
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        if (this.parent != dockStation) {
            this.parent = dockStation;
            this.hierarchyObserver.update();
        }
    }

    @Override
    public DockStation getDockParent() {
        return this.parent;
    }

    @Override
    public Dockable asDockable() {
        return this;
    }

    @Override
    public void setController(DockController dockController) {
        this.getRootHandler().setController(null);
        if (this.controller != null && this.keyboardListener != null) {
            this.controller.getKeyboardController().removeListener(this.keyboardListener);
            this.keyboardListener = null;
        }
        this.controller = dockController;
        this.titleIcon().setController(dockController);
        this.titleText.setProperties(dockController);
        this.hierarchyObserver.controllerChanged(dockController);
        if (!this.keyListeners.isEmpty()) {
            this.registerKeyboardListener();
        }
        this.getRootHandler().setController(dockController);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        this.getRootHandler().setConfiguration(dockComponentConfiguration);
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.getRootHandler().getConfiguration();
    }

    @Override
    public boolean isDockableShowing() {
        return this.isDockableVisible();
    }

    @Override
    @Deprecated
    public boolean isDockableVisible() {
        DockController dockController = this.getController();
        if (dockController == null) {
            return false;
        }
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isVisible(this);
        }
        return false;
    }

    @Override
    public void addDockableListener(DockableListener dockableListener) {
        this.dockableListeners.add(dockableListener);
    }

    @Override
    public void removeDockableListener(DockableListener dockableListener) {
        this.dockableListeners.remove(dockableListener);
    }

    @Override
    public void addDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.addDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void removeDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.removeDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void addDockableStateListener(DockableStateListener dockableStateListener) {
        this.dockableStateListeners.addListener(dockableStateListener);
    }

    @Override
    public void removeDockableStateListener(DockableStateListener dockableStateListener) {
        this.dockableStateListeners.removeListener(dockableStateListener);
    }

    protected DockableStateListenerManager getDockableStateListeners() {
        return this.dockableStateListeners;
    }

    protected DockableStateListenerManager getDockElementObserver() {
        return this.dockableStateListeners;
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.getComponent().addMouseListener(mouseInputListener);
        this.getComponent().addMouseMotionListener(mouseInputListener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.getComponent().removeMouseListener(mouseInputListener);
        this.getComponent().removeMouseMotionListener(mouseInputListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListeners.add(keyListener);
        this.registerKeyboardListener();
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyListeners.remove(keyListener);
        if (this.keyboardListener != null && this.controller != null) {
            this.controller.getKeyboardController().removeListener(this.keyboardListener);
            this.keyboardListener = null;
        }
    }

    private KeyListener[] getKeyListeners() {
        return this.keyListeners.toArray(new KeyListener[this.keyListeners.size()]);
    }

    private void registerKeyboardListener() {
        if (this.keyboardListener == null && this.controller != null) {
            this.keyboardListener = new KeyboardListener(){

                @Override
                public DockElement getTreeLocation() {
                    return AbstractDockable.this;
                }

                @Override
                public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
                    if (dockElement == AbstractDockable.this) {
                        KeyListener[] keyListenerArray = AbstractDockable.this.getKeyListeners();
                        int n = keyListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            KeyListener keyListener = keyListenerArray[n2];
                            keyListener.keyTyped(keyEvent);
                            ++n2;
                        }
                        return keyEvent.isConsumed();
                    }
                    return false;
                }

                @Override
                public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
                    if (dockElement == AbstractDockable.this) {
                        KeyListener[] keyListenerArray = AbstractDockable.this.getKeyListeners();
                        int n = keyListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            KeyListener keyListener = keyListenerArray[n2];
                            keyListener.keyReleased(keyEvent);
                            ++n2;
                        }
                        return keyEvent.isConsumed();
                    }
                    return false;
                }

                @Override
                public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
                    if (dockElement == AbstractDockable.this) {
                        KeyListener[] keyListenerArray = AbstractDockable.this.getKeyListeners();
                        int n = keyListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            KeyListener keyListener = keyListenerArray[n2];
                            keyListener.keyPressed(keyEvent);
                            ++n2;
                        }
                        return keyEvent.isConsumed();
                    }
                    return false;
                }
            };
            this.controller.getKeyboardController().addListener(this.keyboardListener);
        }
    }

    @Override
    public DockElement getElement() {
        return this;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return false;
    }

    @Override
    public boolean accept(DockStation dockStation) {
        return true;
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        return true;
    }

    @Override
    public String getTitleText() {
        String string = this.titleText.getValue();
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setTitleText(String string) {
        this.titleText.setValue(string);
    }

    @Override
    public Icon getTitleIcon() {
        return this.currentTitleIcon;
    }

    public void setTitleToolTip(String string) {
        this.titleToolTip.setValue(string);
    }

    @Override
    public String getTitleToolTip() {
        return this.titleToolTip.getValue();
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public void setTitleIconHandling(IconHandling iconHandling) {
        if (iconHandling == null) {
            throw new IllegalArgumentException("titleIconHandling must not be null");
        }
        this.titleIconHandling = iconHandling;
    }

    public IconHandling getTitleIconHandling() {
        return this.titleIconHandling;
    }

    public void setTitleIcon(Icon icon) {
        switch (this.getTitleIconHandling()) {
            case KEEP_NULL_ICON: {
                this.titleIcon().setValue(icon, true);
                break;
            }
            case REPLACE_NULL_ICON: {
                this.titleIcon().setValue(icon, false);
                break;
            }
            default: {
                throw new IllegalStateException("unknown behavior: " + (Object)((Object)this.titleIconHandling));
            }
        }
    }

    public void resetTitleIcon() {
        this.titleIcon().setValue(null);
    }

    @Override
    public void requestDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void requestDisplayer(DisplayerRequest displayerRequest) {
    }

    @Override
    public void bind(DockTitle dockTitle) {
        if (this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is already bound");
        }
        this.titles.add(dockTitle);
        this.fireTitleBound(dockTitle);
    }

    @Override
    public void unbind(DockTitle dockTitle) {
        if (!this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is unknown");
        }
        this.titles.remove(dockTitle);
        this.fireTitleUnbound(dockTitle);
    }

    @Override
    public DockTitle[] listBoundTitles() {
        return this.titles.toArray(new DockTitle[this.titles.size()]);
    }

    @Override
    public DockActionSource getLocalActionOffers() {
        return this.source;
    }

    @Override
    public DockActionSource getGlobalActionOffers() {
        return this.globalSource;
    }

    public void setActionOffers(DockActionSource dockActionSource) {
        this.source = dockActionSource;
        this.globalSource.update();
    }

    protected void fireTitleTextChanged(String string, String string2) {
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleTextChanged(this, string, string2);
            ++n2;
        }
    }

    protected void fireTitleTooltipChanged(String string, String string2) {
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleToolTipChanged(this, string, string2);
            ++n2;
        }
    }

    protected void fireTitleIconChanged(Icon icon, Icon icon2) {
        this.currentTitleIcon = icon2;
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleIconChanged(this, icon, icon2);
            ++n2;
        }
    }

    protected void fireTitleBound(DockTitle dockTitle) {
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleBound(this, dockTitle);
            ++n2;
        }
    }

    protected void fireTitleUnbound(DockTitle dockTitle) {
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleUnbound(this, dockTitle);
            ++n2;
        }
    }

    protected void fireTitleExchanged(DockTitle dockTitle) {
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleExchanged(this, dockTitle);
            ++n2;
        }
    }

    protected void fireTitleExchanged() {
        DockTitle[] dockTitleArray;
        DockTitle[] dockTitleArray2 = dockTitleArray = this.listBoundTitles();
        int n = dockTitleArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockTitle dockTitle = dockTitleArray2[n2];
            this.fireTitleExchanged(dockTitle);
            ++n2;
        }
        this.fireTitleExchanged(null);
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        this.hints = dockableDisplayerHints;
    }

    protected DockableDisplayerHints getConfigurableDisplayerHints() {
        return this.hints;
    }
}

