/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.displayer;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.ResourceRequest;

public abstract class DisplayerRequest
extends ResourceRequest<DockableDisplayer> {
    private Dockable target;
    private DockStation parent;
    private DockTitle title;
    private DockController controller;
    private DisplayerFactory defaultFactory;

    public DisplayerRequest(DockStation dockStation, Dockable dockable, DisplayerFactory displayerFactory) {
        if (dockStation == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.parent = dockStation;
        this.target = dockable;
        this.defaultFactory = displayerFactory;
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            this.controller = dockController;
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void request(DockTitle dockTitle) {
        this.title = dockTitle;
        try {
            this.request();
        }
        finally {
            this.title = null;
        }
    }

    public Dockable getTarget() {
        return this.target;
    }

    public DockStation getParent() {
        return this.parent;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    @Override
    public void answer(DockableDisplayer dockableDisplayer) {
        super.answer(dockableDisplayer);
    }

    @Override
    protected void executeRequestList() {
        this.target.requestDisplayer(this);
        if (this.isAnswered()) {
            return;
        }
        this.parent.requestChildDisplayer(this);
        if (this.isAnswered()) {
            return;
        }
        this.defaultFactory.request(this);
    }

    @Override
    protected void validate(DockableDisplayer dockableDisplayer) {
        if (dockableDisplayer == null) {
            throw new IllegalArgumentException("displayer is null");
        }
        if (dockableDisplayer.getDockable() != this.getTarget()) {
            throw new IllegalArgumentException("displayer.getDockable() is not target");
        }
    }
}

