/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.disable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.util.HashSet;
import java.util.Set;

public abstract class TabDisablingStrategyObserver {
    private PropertyValue<DisablingStrategy> disablingStrategy = new PropertyValue<DisablingStrategy>(DisablingStrategy.STRATEGY){

        @Override
        protected void valueChanged(DisablingStrategy disablingStrategy, DisablingStrategy disablingStrategy2) {
            if (disablingStrategy != null) {
                disablingStrategy.removeDisablingStrategyListener(TabDisablingStrategyObserver.this.disablingStrategyListener);
            }
            if (disablingStrategy2 != null) {
                disablingStrategy2.addDisablingStrategyListener(TabDisablingStrategyObserver.this.disablingStrategyListener);
            }
            for (Dockable dockable : TabDisablingStrategyObserver.this.items) {
                TabDisablingStrategyObserver.this.setDisabled(dockable, TabDisablingStrategyObserver.this.isDisabled(dockable));
            }
        }
    };
    private DisablingStrategyListener disablingStrategyListener = new DisablingStrategyListener(){

        @Override
        public void changed(DockElement dockElement) {
            Dockable dockable = dockElement.asDockable();
            if (dockable != null && TabDisablingStrategyObserver.this.items.contains(dockable)) {
                TabDisablingStrategyObserver.this.setDisabled(dockable, TabDisablingStrategyObserver.this.isDisabled(dockable));
            }
        }
    };
    private Set<Dockable> items = new HashSet<Dockable>();

    public void setController(DockController dockController) {
        this.disablingStrategy.setProperties(dockController);
    }

    public void add(Dockable dockable) {
        this.items.add(dockable);
        this.setDisabled(dockable, this.isDisabled(dockable));
    }

    public void remove(Dockable dockable) {
        this.items.remove(dockable);
        this.setDisabled(dockable, false);
    }

    public boolean isDisabled(Dockable dockable) {
        DisablingStrategy disablingStrategy = this.disablingStrategy.getValue();
        if (disablingStrategy == null) {
            return false;
        }
        return disablingStrategy.isTabDisabled(dockable);
    }

    public abstract void setDisabled(Dockable var1, boolean var2);
}

